/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.OutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.CoreOutputLocationManager;
import org.eclipse.ajdt.core.builder.IProjectProperties;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.ajdt.internal.core.builder.BuildClasspathResolver;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;

public class CoreProjectProperties
implements IProjectProperties {
    private String cachedClasspath = null;
    private Map filesKnownMap = new HashMap();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public String getProjectName() {
        return AspectJPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        AJLog.log(2, "*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return project.getLocation().toOSString();
    }

    public List getBuildConfigFiles() {
        return null;
    }

    public String getDefaultBuildConfigFile() {
        String defaultLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return defaultLstFile;
    }

    public String getLastActiveBuildConfigFile() {
        String currentLstFile = AspectJPlugin.getBuildConfigurationFile(AspectJPlugin.getDefault().getCurrentProject());
        return currentLstFile;
    }

    public List getProjectSourceFiles() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        List files = BuildConfig.getIncludedSourceFiles(project);
        ArrayList<String> iofiles = new ArrayList<String>(files.size());
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile f = (IFile)iter.next();
            iofiles.add(f.getLocation().toOSString());
        }
        return iofiles;
    }

    public void setProjectSourceFileListKnown(IProject project, boolean known) {
        this.filesKnownMap.put(project, new Boolean(known));
    }

    public boolean isProjectSourceFileListKnown(IProject project) {
        Boolean known = (Boolean)this.filesKnownMap.get(project);
        if (known == null) {
            return false;
        }
        return known;
    }

    public String getProjectSourcePath() {
        IProject p = AspectJPlugin.getDefault().getCurrentProject();
        return p.getLocation().toOSString();
    }

    public String getClasspath() {
        if (this.cachedClasspath != null) {
            return this.cachedClasspath;
        }
        IProject proj = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jp = JavaCore.create((IProject)proj);
        this.cachedClasspath = new BuildClasspathResolver().getClasspath(AspectJPlugin.getWorkspace().getRoot(), jp);
        return this.cachedClasspath;
    }

    public void flushClasspathCache() {
        this.cachedClasspath = null;
    }

    public String getOutputPath() {
        IPath workspaceRelativeOutputPath;
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)currProject);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
            return currProject.getLocation().toOSString();
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            return jProject.getResource().getLocation().toOSString();
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        return out.getLocation().toOSString();
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        return "";
    }

    public String getVmArgs() {
        return null;
    }

    public Set getInJars() {
        return null;
    }

    public String getOutJar() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String outputJar = AspectJCorePreferences.getProjectOutJar(thisProject);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                String projectBaseDirectory = thisProject.getLocation().toOSString();
                outputJar = new String(String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim());
            }
        }
        return outputJar;
    }

    public Set getSourceRoots() {
        return null;
    }

    public Set getAspectPath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJCorePreferences.getProjectAspectPath(thisProject);
        String aspectpath = this.expandVariables(v[0], v[2]);
        if ((aspectpath = this.fullyQualifyPathEntries(aspectpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    public Set getInpath() {
        IProject thisProject = AspectJPlugin.getDefault().getCurrentProject();
        String[] v = AspectJCorePreferences.getProjectInPath(thisProject);
        String inpath = this.expandVariables(v[0], v[2]);
        if ((inpath = this.fullyQualifyPathEntries(inpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    public String expandVariables(String path, String eKinds) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(path, File.pathSeparator);
        StringTokenizer strTok2 = new StringTokenizer(eKinds, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            int entryKind = Integer.parseInt(strTok2.nextToken());
            if (entryKind == 4) {
                String exp;
                int slashPos = current.indexOf("/", 0);
                if (slashPos != -1) {
                    exp = JavaCore.getClasspathVariable((String)current.substring(0, slashPos)).toOSString();
                    resultBuffer.append(exp);
                    resultBuffer.append(current.substring(slashPos));
                } else {
                    exp = JavaCore.getClasspathVariable((String)current).toOSString();
                    resultBuffer.append(exp);
                }
            } else {
                resultBuffer.append(current);
            }
            resultBuffer.append(File.pathSeparator);
        }
        return resultBuffer.toString();
    }

    public String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            File f = new File(current);
            if (f.exists() && f.isAbsolute()) {
                resultBuffer.append(current);
            } else {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.getLocation() != null) {
                    String projectPath = project.getLocation().toString();
                    if (slashPos != -1) {
                        resultBuffer.append(String.valueOf(projectPath) + "/" + current.substring(slashPos + 1));
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJLog.log(2, "AspectJ path entry " + current + " does not exist.");
                    resultBuffer.append(current);
                }
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Set mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            Ajde.getDefault().getErrorHandler().handleWarning(NLS.bind((String)CoreMessages.missingJarsWarning, (Object)invalidEntries.toString()));
        }
        return fileSet;
    }

    private boolean isUsingSeparateOutputFolders(IJavaProject jp) {
        try {
            IClasspathEntry[] cpe = jp.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                if (cpe[i].getEntryKind() == 3 && cpe[i].getOutputLocation() != null) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, ajc$tjp_3);
        }
        return false;
    }

    public OutputLocationManager getOutputLocationManager() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        if (project == null) {
            return null;
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return null;
        }
        if (this.isUsingSeparateOutputFolders(jp)) {
            return new CoreOutputLocationManager(jp);
        }
        return null;
    }

    public Map getSourcePathResources() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        HashMap<String, File> map = new HashMap<String, File>();
        try {
            String realOutputLocation;
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = jProject.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                realOutputLocation = out.getLocation().toOSString();
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    ArrayList files = new ArrayList();
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath = sourcePath.removeFirstSegments(1))};
                    if (srcContainer[0] != null) {
                        this.getProjectRelativePaths(srcContainer, files, CoreUtils.RESOURCE_FILTER, srcContainer[0].getFullPath().segmentCount() - 1, sourceEntry);
                        ArrayList linkedSrcFolders = this.getLinkedChildFolders(srcContainer[0]);
                        Iterator it = files.iterator();
                        while (it.hasNext()) {
                            File file;
                            String relPath = (String)it.next();
                            String fullPath = this.getResourceFullPath(srcContainer[0], relPath, linkedSrcFolders);
                            if (fullPath.startsWith(realOutputLocation) || relPath.endsWith(".classpath") || relPath.endsWith(".project") || relPath.endsWith(".ajsym") || relPath.endsWith(".lst") || !(file = new File(fullPath)).exists()) continue;
                            map.put(relPath, file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, ajc$tjp_5);
        }
        return map;
    }

    private ArrayList getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFolder && children[i].isLinked()) {
                        resultList.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_6, ajc$tjp_7);
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            Iterator it = linkedFolders.iterator();
            while (it.hasNext()) {
                IFolder folder = (IFolder)it.next();
                String linkedFolderName = folder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(folder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    private void getProjectRelativePaths(IResource[] resource_list, List allProjectFiles, CoreUtils.FilenameFilter filter, int trimSegments, IClasspathEntry sourceEntry) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                char[][] exclusionPatterns;
                IResource ir = resource_list[i];
                char[][] inclusionPatterns = ((ClasspathEntry)sourceEntry).fullInclusionPatternChars();
                if (!Util.isExcluded((IResource)ir, (char[][])inclusionPatterns, (char[][])(exclusionPatterns = ((ClasspathEntry)sourceEntry).fullExclusionPatternChars()))) {
                    if (ir instanceof IContainer) {
                        this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments, sourceEntry);
                    } else if (filter.accept(ir.getName())) {
                        String[] segments = ir.getProjectRelativePath().segments();
                        String path = "";
                        int j = trimSegments;
                        while (j < segments.length) {
                            path = String.valueOf(path) + segments[j];
                            if (j < segments.length - 1) {
                                path = String.valueOf(path) + '/';
                            }
                            ++j;
                        }
                        allProjectFiles.add(path);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_8, ajc$tjp_9);
        }
    }

    static {
        Factory factory = new Factory("CoreProjectProperties.java", Class.forName("org.eclipse.ajdt.core.builder.CoreProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 168);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOutputPath-org.eclipse.ajdt.core.builder.CoreProjectProperties----java.lang.String-"), 162);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 433);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isUsingSeparateOutputFolders-org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.IJavaProject:-jp:--boolean-"), 423);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 513);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSourcePathResources-org.eclipse.ajdt.core.builder.CoreProjectProperties----java.util.Map-"), 458);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 534);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLinkedChildFolders-org.eclipse.ajdt.core.builder.CoreProjectProperties-org.eclipse.core.resources.IResource:-resource:--java.util.ArrayList-"), 522);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.CoreProjectProperties-java.lang.Exception-<missing>-"), 597);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProjectRelativePaths-org.eclipse.ajdt.core.builder.CoreProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:org.eclipse.ajdt.core.CoreUtils$FilenameFilter:int:org.eclipse.jdt.core.IClasspathEntry:-resource_list:allProjectFiles:filter:trimSegments:sourceEntry:--void-"), 567);
    }
}

