/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.IAJLogger;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerFactory;
import org.eclipse.ajdt.internal.core.ajde.ICompilerFactory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class AspectJPlugin
extends Plugin {
    private static AspectJPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.ajdt.core";
    public static final String TOOLS_PLUGIN_ID = "org.aspectj.ajde";
    public static final String WEAVER_PLUGIN_ID = "org.aspectj.weaver";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.runtime";
    public static final String ID_BUILDER = "org.eclipse.ajdt.core.ajbuilder";
    public static final String DEFAULT_CONFIG_FILE = ".generated.lst";
    public static final String UI_PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";
    public static final String AJ_FILE_EXT = "aj";
    public static final String ASPECTJRT_CONTAINER = "org.eclipse.ajdt.core.ASPECTJRT_CONTAINER";
    public static final String[] ajKeywords;
    public static final String NON_OS_SPECIFIC_SEPARATOR = "/";
    public static boolean usingCUprovider;
    private IProject currentProject;
    private ICompilerFactory compilerFactory;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("AspectJPlugin.java", Class.forName("org.eclipse.ajdt.core.AspectJPlugin"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.AspectJPlugin-org.eclipse.core.runtime.CoreException-<missing>-"), 180);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isAJProject-org.eclipse.ajdt.core.AspectJPlugin-org.eclipse.core.resources.IProject:-project:--boolean-"), 173);
        ajKeywords = new String[]{"aspect", "pointcut", "privileged", "call", "execution", "initialization", "preinitialization", "handler", "get", "set", "staticinitialization", "target", "args", "within", "withincode", "cflow", "cflowbelow", "annotation", "before", "after", "around", "proceed", "throwing", "returning", "adviceexecution", "declare", "parents", "warning", "error", "soft", "precedence", "thisJoinPoint", "thisJoinPointStaticPart", "thisEnclosingJoinPointStaticPart", "issingleton", "perthis", "pertarget", "percflow", "percflowbelow", "pertypewithin"};
        usingCUprovider = false;
    }

    public AspectJPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.checkForCUprovider();
        this.setCompilerFactory(new CoreCompilerFactory());
    }

    private void checkForCUprovider() {
        String EJDT_CU_PROVIDER_EXTENSION = "org.eclipse.jdt.core.compilationUnitProvider";
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(EJDT_CU_PROVIDER_EXTENSION);
        if (exP != null && Platform.getBundle((String)"org.eclipse.ajdt.cuprovider") != null) {
            usingCUprovider = true;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        AJModel.getInstance().saveAllModels();
    }

    public static AspectJPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static boolean isAJProject(IProject project) {
        if (project.isOpen()) {
            try {
                if (project != null && project.hasNature(ID_NATURE)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_0, ajc$tjp_1);
            }
        }
        return false;
    }

    public void setAJLogger(IAJLogger logger) {
        AJLog.setLogger(logger);
    }

    public ICompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(ICompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }
}

