/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.IStateListener;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.ajdt.internal.core.AspectJRTInitializer;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class AJBuilder
extends IncrementalProjectBuilder {
    private static IStateListener isl;
    private static List buildListeners;
    private IProgressMonitor progressMonitor;
    private String lastWorkbenchPreference = "abort";
    private static IProject lastBuiltProject;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    static {
        Factory factory = new Factory("AJBuilder.java", Class.forName("org.eclipse.ajdt.core.builder.AJBuilder"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 255);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-build-org.eclipse.ajdt.core.builder.AJBuilder-int:java.util.Map:org.eclipse.core.runtime.IProgressMonitor:-kind:args:progressMonitor:-org.eclipse.core.runtime.CoreException:-[Lorg.eclipse.core.resources.IProject;-"), 105);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 788);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.osgi.service.prefs.BackingStoreException-<missing>-"), 789);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-<missing>-"), 884);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeProblemsAndTasksFor-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IResource:-resource:--void-"), 878);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.JavaModelException-<missing>-"), 908);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-sourceFilesChanged-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IResourceDelta:org.eclipse.core.resources.IProject:-delta:project:--boolean-"), 889);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.JavaModelException-<missing>-"), 997);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-migrateToRTContainerIfNecessary-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.IJavaProject:-javaProject:--void-"), 977);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.runtime.CoreException-e-"), 315);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-markProject-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IProject:java.lang.String:-project:errorMessage:--void-"), 310);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.JavaModelException-<missing>-"), 360);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getRequiredProjects-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.resources.IProject:boolean:-project:includeBinaryPrerequisites:--[Lorg.eclipse.core.resources.IProject;-"), 325);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.core.internal.resources.ResourceException-e-"), 445);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-copyResources-org.eclipse.ajdt.core.builder.AJBuilder-org.eclipse.jdt.core.IJavaProject:org.eclipse.core.resources.IResourceDelta:-project:delta:-org.eclipse.core.runtime.CoreException:-boolean-"), 417);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.builder.AJBuilder-org.osgi.service.prefs.BackingStoreException-<missing>-"), 782);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateJavaCompilerPreferences-org.eclipse.ajdt.core.builder.AJBuilder-[Lorg.eclipse.core.resources.IProject;:-dependingProjects:--void-"), 731);
        isl = null;
        buildListeners = new ArrayList();
        lastBuiltProject = null;
    }

    public static IProject getLastBuildTarget() {
        return lastBuiltProject;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor progressMonitor) throws CoreException {
        IProject project = this.getProject();
        AjCompiler compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project);
        this.progressMonitor = progressMonitor;
        progressMonitor.beginTask(CoreMessages.builder_taskname, 102);
        AJLog.logStart("Total time spent in AJBuilder.build()");
        String kindS = null;
        if (kind == 9) {
            kindS = "AUTOBUILD";
        }
        if (kind == 10) {
            kindS = "INCREMENTALBUILD";
        }
        if (kind == 6) {
            kindS = "FULLBUILD";
        }
        if (kind == 15) {
            kindS = "CLEANBUILD";
        }
        AJLog.log(2, "===========================================================================================");
        AJLog.log(2, "Build kind = " + kindS);
        IProject[] requiredProjects = this.getRequiredProjects(project, true);
        this.preCallListeners(kind, project, requiredProjects);
        progressMonitor.worked(1);
        String mode = "";
        mode = kind != 6 ? "Incremental AspectJ compilation" : "Full AspectJ compilation";
        AJLog.log(2, "Project=" + project.getName() + ", kind of build requested=" + mode);
        if (!this.validateInpathAspectPath(project)) {
            this.postCallListeners(true);
            AJLog.log(2, "build: Abort due to missing inpath/aspectpath entries");
            AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
            progressMonitor.done();
            return requiredProjects;
        }
        IProject[] dependingProjects = this.getDependingProjects(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!javaProject.hasBuildState() && dependingProjects.length > 0) {
            this.updateJavaCompilerPreferences(dependingProjects);
        }
        BuildConfig.flushIncludedSourceFileCache(project);
        CoreCompilerConfiguration compilerConfig = (CoreCompilerConfiguration)compiler.getCompilerConfiguration();
        IResourceDelta dta = this.getDelta(this.getProject());
        if (dta != null) {
            this.copyResources(javaProject, dta);
        }
        if (kind != 6 && !this.sourceFilesChanged(dta, project)) {
            AJLog.log(2, "build: Examined delta - no source file changes for project " + project.getName());
            boolean continueToBuild = false;
            int i = 0;
            while (!continueToBuild && i < requiredProjects.length) {
                IResourceDelta delta = this.getDelta(requiredProjects[i]);
                continueToBuild = this.sourceFilesChanged(delta, requiredProjects[i]);
                ++i;
            }
            if (!continueToBuild) {
                compilerConfig.flushClasspathCache();
                this.postCallListeners(true);
                AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
                progressMonitor.done();
                return requiredProjects;
            }
        }
        this.migrateToRTContainerIfNecessary(javaProject);
        IAJCompilerMonitor compilerMonitor = (IAJCompilerMonitor)compiler.getBuildProgressMonitor();
        if (kind == 6) {
            IJavaProject ijp = JavaCore.create((IProject)project);
            if (ijp != null) {
                this.cleanOutputFolders(ijp, false);
            } else {
                AJLog.log(2, "Unable to empty output folder on build all - why cant we find the IJavaProject?");
            }
        }
        compilerMonitor.prepare((IProgressMonitor)new SubProgressMonitor(progressMonitor, 100));
        lastBuiltProject = project;
        AJLog.log(3, "Classpath=" + compilerConfig.getClasspath());
        AJLog.logStart("Total time spent in AJDE");
        if (kind == 6) {
            compiler.buildFresh();
        } else {
            compiler.build();
        }
        AJLog.logEnd(2, "Total time spent in AJDE");
        boolean javaDep = false;
        int i = 0;
        while (!javaDep && i < dependingProjects.length) {
            if (dependingProjects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                javaDep = true;
            }
            ++i;
        }
        try {
            if (javaDep) {
                project.refreshLocal(2, null);
            } else {
                IPath[] paths = CoreUtils.getOutputFolders(javaProject);
                int i2 = 0;
                while (i2 < paths.length) {
                    IPath workspaceRelativeOutputPath = paths[i2];
                    if (workspaceRelativeOutputPath.segmentCount() == 1) {
                        project.refreshLocal(2, null);
                    } else {
                        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                        out.refreshLocal(2, null);
                        project.refreshLocal(1, null);
                    }
                    ++i2;
                }
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        AJModel.getInstance().createMap(project);
        compilerConfig.flushClasspathCache();
        this.postCallListeners(false);
        progressMonitor.worked(1);
        progressMonitor.done();
        AJLog.logEnd(2, "Total time spent in AJBuilder.build()");
        return requiredProjects;
    }

    private boolean validateInpathAspectPath(IProject project) {
        Set aspectpath;
        CoreCompilerConfiguration compilerConfig = (CoreCompilerConfiguration)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
        boolean success = true;
        Set inpath = compilerConfig.getInpath();
        if (inpath != null) {
            Iterator iter = inpath.iterator();
            while (iter.hasNext()) {
                File f = (File)iter.next();
                if (f.exists()) continue;
                String missingMessage = NLS.bind((String)CoreMessages.BuilderMissingInpathEntry, (Object)project.getName(), (Object)f.getName());
                this.markProject(project, missingMessage);
                success = false;
            }
        }
        if ((aspectpath = compilerConfig.getAspectPath()) != null) {
            Iterator iter = aspectpath.iterator();
            while (iter.hasNext()) {
                File f = (File)iter.next();
                if (f.exists()) continue;
                String missingMessage = NLS.bind((String)CoreMessages.BuilderMissingAspectpathEntry, (Object)project.getName(), (Object)f.getName());
                this.markProject(project, missingMessage);
                success = false;
            }
        }
        return success;
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, ajc$tjp_3);
            CoreException e = coreException;
            AJLog.log(2, "build: Problem occured creating the error marker for project " + project.getName() + ": " + e.getStackTrace());
        }
    }

    private IProject[] getRequiredProjects(IProject project, boolean includeBinaryPrerequisites) {
        JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        if (javaProject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries = javaProject.getExpandedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, ajc$tjp_5);
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects(project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IClasspathEntry[] getSrcClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        ArrayList<IClasspathEntry> srcEntries = new ArrayList<IClasspathEntry>();
        if (javaProject == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
        int j = 0;
        while (j < cpEntry.length) {
            IClasspathEntry entry = cpEntry[j];
            if (entry.getEntryKind() == 3) {
                srcEntries.add(entry);
            }
            ++j;
        }
        return srcEntries.toArray(new IClasspathEntry[srcEntries.size()]);
    }

    private boolean copyResources(IJavaProject project, IResourceDelta delta) throws CoreException {
        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(project);
        int i = 0;
        int l = srcEntries.length;
        while (i < l) {
            IClasspathEntry srcEntry = srcEntries[i];
            IPath srcPath = srcEntry.getPath().removeFirstSegments(1);
            IContainer srcContainer = this.getContainerForGivenPath(srcPath, project.getProject());
            if (srcContainer.equals((Object)project.getProject())) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    if (!this.isExcludedFromProject(project, children[j].getFullPath(), srcEntries)) {
                        this.copyResources(project, children[j], srcEntry, segmentCount);
                    }
                    ++j;
                }
            } else {
                IPath projectRelativePath = srcEntry.getPath().removeFirstSegments(1);
                projectRelativePath.makeRelative();
                IResourceDelta sourceDelta = delta.findMember(projectRelativePath);
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    try {
                        int j = 0;
                        int m = children.length;
                        while (j < m) {
                            this.copyResources(project, children[j], srcEntry, segmentCount);
                            ++j;
                        }
                    }
                    catch (ResourceException resourceException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(resourceException, (Object)this, ajc$tjp_6, ajc$tjp_7);
                        ResourceException e = resourceException;
                        if (e.getStatus().getCode() == 275) {
                            return false;
                        }
                        throw e;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void copyResources(IJavaProject javaProject, IResourceDelta sourceDelta, IClasspathEntry srcEntry, int segmentCount) throws CoreException {
        char[][] exclusionPatterns;
        char[][] inclusionPatterns;
        IResource resource = sourceDelta.getResource();
        if (Util.isExcluded((IResource)resource, (char[][])(inclusionPatterns = ((ClasspathEntry)srcEntry).fullInclusionPatternChars()), (char[][])(exclusionPatterns = ((ClasspathEntry)srcEntry).fullExclusionPatternChars()))) {
            return;
        }
        IPath outputPath = srcEntry.getOutputLocation();
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        outputPath = outputPath.removeFirstSegments(1).makeRelative();
        IContainer outputFolder = this.getContainerForGivenPath(outputPath, javaProject.getProject());
        IContainer srcContainer = this.getContainerForGivenPath(srcEntry.getPath().removeFirstSegments(1), javaProject.getProject());
        switch (resource.getType()) {
            case 2: {
                switch (sourceDelta.getKind()) {
                    case 1: {
                        IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        this.createFolder(addedPackagePath, outputFolder);
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.copyResources(javaProject, children[i], srcEntry, segmentCount);
                            ++i;
                        }
                        return;
                    }
                    case 2: {
                        IFolder removedPackageFolder;
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        IClasspathEntry[] srcEntries = this.getSrcClasspathEntry(javaProject);
                        if (srcEntries.length > 1) {
                            int i = 0;
                            int l = srcEntries.length;
                            while (i < l) {
                                IPath srcPath = srcEntries[i].getPath().removeFirstSegments(1);
                                IFolder srcFolder = javaProject.getProject().getFolder(srcPath);
                                if (srcFolder.getFolder(removedPackagePath).exists()) {
                                    this.createFolder(removedPackagePath, outputFolder);
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.copyResources(javaProject, removedChildren[j], srcEntry, segmentCount);
                                        ++j;
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        if (!(removedPackageFolder = outputFolder.getFolder(removedPackagePath)).exists()) break;
                        removedPackageFolder.delete(1, null);
                    }
                }
                return;
            }
            case 1: {
                if (!outputFolder.equals((Object)srcContainer)) {
                    IPath resourcePath = resource.getFullPath().removeFirstSegments(segmentCount);
                    if (resourcePath == null) {
                        return;
                    }
                    if (resourcePath.getFileExtension() != null && (resourcePath.getFileExtension().equals("aj") || resourcePath.getFileExtension().equals("java"))) {
                        return;
                    }
                    IFile outputFile = outputFolder.getFile(resourcePath);
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            if (outputFile.exists()) {
                                AJLog.log(2, "Deleting existing file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            AJLog.log(2, "Copying added file " + resourcePath);
                            this.createFolder(resourcePath.removeLastSegments(1), outputFolder);
                            resource.copy(outputFile.getFullPath(), 1, null);
                            outputFile.setDerived(true);
                            Util.setReadOnly((IResource)outputFile, (boolean)false);
                            outputFile.refreshLocal(0, null);
                            return;
                        }
                        case 2: {
                            if (outputFile.exists()) {
                                AJLog.log(2, "Deleting removed file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            return;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                                return;
                            }
                            if (outputFile.exists()) {
                                AJLog.log(2, "Deleting existing file " + resourcePath);
                                outputFile.delete(1, null);
                            }
                            AJLog.log(2, "Copying changed file " + resourcePath);
                            this.createFolder(resourcePath.removeLastSegments(1), outputFolder);
                            resource.copy(outputFile.getFullPath(), 1, null);
                            outputFile.setDerived(true);
                            Util.setReadOnly((IResource)outputFile, (boolean)false);
                            outputFile.refreshLocal(0, null);
                        }
                    }
                }
                return;
            }
        }
    }

    private IContainer getContainerForGivenPath(IPath path, IProject project) {
        if (path.toOSString().equals("")) {
            return project;
        }
        return project.getFolder(path);
    }

    private IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (!outputFolder.exists() && outputFolder instanceof IFolder) {
            ((IFolder)outputFolder).create(true, true, null);
        }
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        folder.refreshLocal(0, null);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(true, true, null);
            folder.setDerived(true);
            folder.refreshLocal(0, null);
        }
        return folder;
    }

    private boolean isExcludedFromProject(IJavaProject javaProject, IPath childPath, IClasspathEntry[] srcEntries) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        int j = 0;
        int k = srcEntries.length;
        while (j < k) {
            IPath outputPath = srcEntries[j].getOutputLocation();
            if (outputPath == null) {
                outputPath = javaProject.getOutputLocation();
            }
            if (childPath.equals((Object)this.getContainerForGivenPath(outputPath = outputPath.removeFirstSegments(1).makeRelative(), javaProject.getProject()).getFullPath())) {
                return true;
            }
            IPath srcPath = srcEntries[j].getPath().removeFirstSegments(1);
            if (childPath.equals((Object)this.getContainerForGivenPath(srcPath, javaProject.getProject()).getFullPath())) {
                return true;
            }
            ++j;
        }
        return childPath.equals((Object)javaProject.getOutputLocation());
    }

    protected void cleanOutputFolders(IJavaProject project, boolean refresh) throws CoreException {
        boolean deleteAll = "clean".equals(project.getOption("org.eclipse.jdt.core.builder.cleanOutputFolder", true));
        if (deleteAll) {
            int numberDeleted = 0;
            IPath[] paths = CoreUtils.getOutputFolders(project);
            int i = 0;
            while (i < paths.length) {
                numberDeleted += this.cleanFolder(project, paths[i], refresh);
                ++i;
            }
            AJLog.log(2, "Builder: Tidied output folder(s), deleted " + numberDeleted + " .class files");
        }
    }

    private int cleanFolder(IJavaProject project, IPath outputFolder, boolean refresh) throws CoreException {
        IProject outputResource;
        String realOutputLocation = null;
        if (outputFolder.segmentCount() == 1) {
            outputResource = project.getProject();
            realOutputLocation = project.getResource().getLocation().toOSString();
        } else {
            outputResource = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputFolder);
            realOutputLocation = outputResource.getLocation().toOSString();
        }
        File outputDir = new File(realOutputLocation);
        int numberDeleted = AJBuilder.wipeFiles(outputDir.listFiles(), ".class");
        if (refresh) {
            outputResource.refreshLocal(2, null);
        }
        return numberDeleted;
    }

    public static void cleanAJFilesFromOutputFolder(IPath workspaceRelativeOutputPath) throws CoreException {
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        String realOutputLocation = out.getLocation().toOSString();
        File outputDir = new File(realOutputLocation);
        int numberDeleted = AJBuilder.wipeFiles(outputDir.listFiles(), ".aj");
        out.refreshLocal(2, null);
        AJLog.log(2, "Builder: Tidied output folder, deleted " + numberDeleted + " .aj files from " + realOutputLocation + (out.isLinked() ? " (Linked output folder from " + workspaceRelativeOutputPath.toOSString() + ")" : ""));
    }

    private static int wipeFiles(File[] fs, String fileExtension) {
        int count = 0;
        if (fs != null) {
            int fcounter = 0;
            while (fcounter < fs.length) {
                File file = fs[fcounter];
                if (file.getName().endsWith(fileExtension)) {
                    file.delete();
                    ++count;
                }
                if (file.isDirectory()) {
                    count += AJBuilder.wipeFiles(file.listFiles(), fileExtension);
                }
                ++fcounter;
            }
        }
        return count;
    }

    private void updateJavaCompilerPreferences(IProject[] dependingProjects) {
        boolean setWorkbenchPref = false;
        int i = 0;
        while (i < dependingProjects.length) {
            block15: {
                IProject dependingProject = dependingProjects[i];
                try {
                    if (AspectJPlugin.isAJProject(dependingProject) || !dependingProject.hasNature("org.eclipse.jdt.core.javanature")) break block15;
                    JavaProject jp = (JavaProject)JavaCore.create((IProject)dependingProject);
                    IEclipsePreferences projectPreferences = jp.getEclipsePreferences();
                    String[] keys = projectPreferences.keys();
                    if (keys.length == 0 && !setWorkbenchPref) {
                        Hashtable options = JavaCore.getOptions();
                        String workbenchSetting = (String)options.get("org.eclipse.jdt.core.builder.invalidClasspath");
                        if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("ignore")) {
                            this.lastWorkbenchPreference = "ignore";
                        } else if (this.lastWorkbenchPreference.equals("abort") && workbenchSetting.equals("abort")) {
                            if (!setWorkbenchPref) {
                                options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                                JavaCore.setOptions((Hashtable)options);
                                setWorkbenchPref = true;
                                this.lastWorkbenchPreference = "ignore";
                            }
                        } else if (this.lastWorkbenchPreference.equals("ignore") && workbenchSetting.equals("abort")) {
                            if (!setWorkbenchPref) {
                                options.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                                JavaCore.setOptions((Hashtable)options);
                                setWorkbenchPref = true;
                            } else {
                                this.lastWorkbenchPreference = "abort";
                            }
                        }
                        break block15;
                    }
                    if (keys.length <= 0 || !this.usingProjectBuildingOptions(keys)) break block15;
                    projectPreferences.put("org.eclipse.jdt.core.builder.invalidClasspath", "ignore");
                    try {
                        projectPreferences.flush();
                    }
                    catch (BackingStoreException backingStoreException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException, (Object)this, ajc$tjp_8, ajc$tjp_9);
                    }
                    this.lastWorkbenchPreference = (String)JavaCore.getOptions().get("org.eclipse.jdt.core.builder.invalidClasspath");
                }
                catch (CoreException coreException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_10, ajc$tjp_9);
                }
                catch (BackingStoreException backingStoreException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(backingStoreException, (Object)this, ajc$tjp_11, ajc$tjp_9);
                }
            }
            ++i;
        }
    }

    private boolean usingProjectBuildingOptions(String[] keys) {
        List<String> listOfKeys = Arrays.asList(keys);
        return listOfKeys.contains("org.eclipse.jdt.core.compiler.maxProblemPerUnit") || listOfKeys.contains("org.eclipse.jdt.core.builder.duplicateResourceTask") || listOfKeys.contains("org.eclipse.jdt.core.builder.invalidClasspath") || listOfKeys.contains("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter") || listOfKeys.contains("org.eclipse.jdt.core.classpath.multipleOutputLocations") || listOfKeys.contains("org.eclipse.jdt.core.circularClasspath") || listOfKeys.contains("org.eclipse.jdt.core.incompleteClasspath") || listOfKeys.contains("org.eclipse.jdt.core.incompatibleJDKLevel");
    }

    public static void addAJBuildListener(IAJBuildListener listener) {
        if (!buildListeners.contains(listener)) {
            buildListeners.add(listener);
        }
    }

    public static void removeAJBuildListener(IAJBuildListener listener) {
        buildListeners.remove(listener);
    }

    public static void addAdviceListener(IAdviceChangedListener adviceListener) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.addAdviceListener(adviceListener);
        }
    }

    public static void removeAdviceListener(IAdviceChangedListener adviceListener) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.removeAdviceListener(adviceListener);
        }
    }

    private void preCallListeners(int kind, IProject project, IProject[] requiredProjects) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.preAJBuild(kind, project, requiredProjects);
        }
    }

    private void postCallListeners(boolean noSourceChanges) {
        Iterator iter = buildListeners.iterator();
        while (iter.hasNext()) {
            IAJBuildListener listener = (IAJBuildListener)iter.next();
            listener.postAJBuild(this.getProject(), noSourceChanges);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        AspectJPlugin.getDefault().getCompilerFactory().removeCompilerForProject(project);
        this.removeProblemsAndTasksFor((IResource)project);
        if (AspectJPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            this.cleanOutputFolders(JavaCore.create((IProject)project), false);
        } else {
            this.cleanOutputFolders(JavaCore.create((IProject)project), true);
        }
    }

    private void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_12, ajc$tjp_13);
        }
        AJLog.log(2, "Removed problems and tasks for project " + resource.getName());
    }

    public boolean sourceFilesChanged(IResourceDelta delta, IProject project) {
        if (delta != null && delta.getAffectedChildren().length != 0) {
            List includedFileNames = BuildConfig.getIncludedSourceFiles(project);
            IJavaProject ijp = JavaCore.create((IProject)project);
            if (ijp == null) {
                return true;
            }
            try {
                IPath outputPath = ijp.getOutputLocation();
                if (project.getFullPath().equals((Object)outputPath)) {
                    outputPath = null;
                }
                if (this.sourceFilesChanged(delta, includedFileNames, outputPath)) {
                    AJLog.log(2, "build: Examined delta - source file changes in required project " + project.getName());
                    return true;
                }
                return false;
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_14, ajc$tjp_15);
            }
        }
        return true;
    }

    private boolean sourceFilesChanged(IResourceDelta dta, List includedFileNames, IPath outputLocation) {
        if (dta == null) {
            return false;
        }
        if (outputLocation != null && outputLocation.equals((Object)dta.getFullPath())) {
            return false;
        }
        String resname = dta.getFullPath().toString();
        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(resname)) {
            return includedFileNames == null || includedFileNames.contains(dta.getResource()) || dta.getKind() == 2;
        }
        if (resname.endsWith(".classpath")) {
            return true;
        }
        boolean kids_results = false;
        int i = 0;
        IResourceDelta[] kids = dta.getAffectedChildren();
        while (!kids_results && i < kids.length) {
            kids_results |= this.sourceFilesChanged(kids[i], includedFileNames, outputLocation);
            ++i;
        }
        return kids_results;
    }

    public static void addStateListener() {
        if (isl == null) {
            isl = new IStateListener(){

                public void detectedClassChangeInThisDir(File f) {
                }

                public void aboutToCompareClasspaths(List oldClasspath, List newClasspath) {
                }

                public void pathChangeDetected() {
                }

                public void buildSuccessful(boolean arg0) {
                    AJLog.log(1, "AspectJ reports build successful, build was: " + (arg0 ? "FULL" : "INCREMENTAL"));
                }

                public void detectedAspectDeleted(File f) {
                }

                public void recordDecision(String decision) {
                    AJLog.log(1, decision);
                }

                public void recordInformation(String info) {
                    AJLog.log(1, info);
                }
            };
        }
        AjState.stateListener = isl;
    }

    public static void removeStateListener() {
        AjState.stateListener = null;
    }

    private void migrateToRTContainerIfNecessary(IJavaProject javaProject) {
        if (!AspectJRTInitializer.hasBeenUsed) {
            return;
        }
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                String var;
                if (entries[i].getEntryKind() == 4 && (var = entries[i].getPath().segment(0)).equals("ASPECTJRT_LIB")) {
                    entries[i] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.ajdt.core.ASPECTJRT_CONTAINER"), (boolean)false);
                    javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_16, ajc$tjp_17);
        }
    }
}

