/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class AJModel {
    private static AJModel instance;
    private Map projectModelMap = new HashMap();
    private static String lastLoadedConfigFile;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    private AJModel() {
    }

    public static AJModel getInstance() {
        if (instance == null) {
            instance = new AJModel();
        }
        return instance;
    }

    public void saveAllModels() {
        Iterator iter = this.projectModelMap.keySet().iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
            pm.saveModel();
        }
    }

    public void saveModel(IProject project) {
        AJProjectModel pm = this.getModelForProject(project);
        if (pm != null) {
            pm.saveModel();
        }
    }

    public AJProjectModel getModelForProject(IProject project) {
        if (project == null || !project.isAccessible() || !AspectJPlugin.isAJProject(project)) {
            return null;
        }
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm != null) {
            return pm;
        }
        AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        projectModel.loadModel();
        return projectModel;
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getRelatedElements(rel, je);
    }

    public boolean isAdvised(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return false;
        }
        return pm.isAdvised(je);
    }

    public boolean hasRuntimeTest(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return false;
        }
        return pm.hasRuntimeTest(je);
    }

    public List getExtraChildren(IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getExtraChildren(je);
    }

    public void createMap(IProject project) {
        final AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    projectModel.createProjectMap();
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public void clearMap(IProject project, boolean delete) {
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm != null && delete) {
            pm.deleteModelFile();
        }
        this.projectModelMap.remove(project);
        AJLog.log("Cleared AJDT relationship map for project " + project.getName());
    }

    public List getAllRelationships(IProject project, AJRelationshipType[] rels) {
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return null;
        }
        return pm.getAllRelationships(rels);
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        if (je == null) {
            return -1;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return -1;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return -1;
        }
        return pm.getJavaElementLineNumber(je);
    }

    public String getJavaElementLinkName(IJavaElement je) {
        if (je == null) {
            return "";
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return je.getElementName();
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return je.getElementName();
        }
        return pm.getJavaElementLinkName(je);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        IResource res = this.programElementToResource(ipe);
        if (res != null && res instanceof IFile) {
            IFile file = (IFile)res;
            AJProjectModel pm = this.getModelForProject(file.getProject());
            if (pm == null) {
                return null;
            }
            return pm.getCorrespondingJavaElement(ipe);
        }
        return null;
    }

    private IResource programElementToResource(IProgramElement ipe) {
        try {
            String fileString = ipe.getSourceLocation().getSourceFile().getCanonicalPath();
            IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                String root;
                if (projects[i].isOpen() && AspectJPlugin.isAJProject(projects[i]) && fileString.startsWith(root = CoreUtils.getProjectRootDirectory(projects[i]))) {
                    String path = fileString.substring(root.length());
                    Path ipath = new Path(path);
                    IResource res = projects[i].findMember((IPath)ipath);
                    return res;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_2, ajc$tjp_3);
        }
        return null;
    }

    static {
        Factory factory = new Factory("AJModel.java", Class.forName("org.eclipse.ajdt.core.model.AJModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.runtime.CoreException-<missing>-"), 172);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createMap-org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.resources.IProject:-project:--void-"), 163);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-java.io.IOException-<missing>-"), 277);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-programElementToResource-org.eclipse.ajdt.core.model.AJModel-org.aspectj.asm.IProgramElement:-ipe:--org.eclipse.core.resources.IResource-"), 258);
    }
}

