/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ajdocexport;

import java.io.File;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AJdocWizardPage
extends NewElementWizardPage {
    protected AJdocWizardPage(String pageName) {
        super(pageName);
        this.setTitle(UIMessages.ajdocWizardPage_javadocwizardpage_description);
    }

    protected Button createButton(Composite composite, int style, String message, GridData gd) {
        Button button = new Button(composite, style);
        button.setText(message);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected GridLayout createGridLayout(int columns) {
        return new GridLayout(columns, false);
    }

    protected GridData createGridData(int flag, int hspan, int vspan, int indent) {
        GridData gd = new GridData(flag);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = hspan;
        gd.verticalSpan = vspan;
        return gd;
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData gd = new GridData(flag);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = hspan;
        return gd;
    }

    protected GridData createGridData(int hspan) {
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        return gd;
    }

    protected Label createLabel(Composite composite, int style, String message, GridData gd) {
        Label label = new Label(composite, style);
        label.setText(message);
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Text createText(Composite composite, int style, String message, GridData gd) {
        Text text = new Text(composite, style);
        if (message != null) {
            text.setText(message);
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Combo createCombo(Composite composite, int style, String message, GridData gd) {
        Combo combo = new Combo(composite, style);
        if (message != null) {
            combo.setText(message);
        }
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected void handleFileBrowseButtonPressed(Text text, String[] extensions, String title) {
        String selectedDirectory;
        File path;
        FileDialog dialog = new FileDialog(text.getShell());
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        String dirName = text.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            text.setText(selectedDirectory);
        }
    }

    protected String handleFolderBrowseButtonPressed(String dir, String title, String message) {
        File file;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(dir);
        dialog.setText(title);
        dialog.setMessage(message);
        String res = dialog.open();
        if (res != null && (file = new File(res)).isDirectory()) {
            return res;
        }
        return dir;
    }

    protected static class EnableSelectionAdapter
    extends SelectionAdapter {
        private Control[] fEnable;
        private Control[] fDisable;

        protected EnableSelectionAdapter(Control[] enable, Control[] disable) {
            this.fEnable = enable;
            this.fDisable = disable;
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < this.fEnable.length) {
                this.fEnable[i].setEnabled(true);
                ++i;
            }
            i = 0;
            while (i < this.fDisable.length) {
                this.fDisable[i].setEnabled(false);
                ++i;
            }
            this.validate();
        }

        public void validate() {
        }
    }

    protected static class ToggleSelectionAdapter
    extends SelectionAdapter {
        Control[] controls;

        protected ToggleSelectionAdapter(Control[] controls) {
            this.controls = controls;
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < this.controls.length) {
                Control control;
                control.setEnabled(!(control = this.controls[i]).getEnabled());
                ++i;
            }
            this.validate();
        }

        public void validate() {
        }
    }
}

