/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchConfigurationManagementUtils {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    public static void updateAspectPaths(IJavaProject project, List existingAspectPathEntries, List newAspectPathEntries) {
        try {
            String projectName = project.getElementName();
            List configs = LaunchConfigurationManagementUtils.getLaunchConfigsForProject(projectName);
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)iter.next();
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
                ArrayList<IRuntimeClasspathEntry> entriesAsList = new ArrayList<IRuntimeClasspathEntry>(Arrays.asList(entries));
                Iterator iterator = existingAspectPathEntries.iterator();
                block3: while (iterator.hasNext()) {
                    IClasspathEntry entryToRemove = ((CPListElement)iterator.next()).getClasspathEntry();
                    Iterator iterator2 = entriesAsList.iterator();
                    while (iterator2.hasNext()) {
                        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator2.next();
                        if (entry.getClasspathProperty() != 3 || !entryToRemove.equals(entry.getClasspathEntry())) continue;
                        iterator2.remove();
                        continue block3;
                    }
                }
                iterator = newAspectPathEntries.iterator();
                while (iterator.hasNext()) {
                    IClasspathEntry newEntry = ((CPListElement)iterator.next()).getClasspathEntry();
                    entriesAsList.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(newEntry));
                }
                IRuntimeClasspathEntry[] updatedEntries = entriesAsList.toArray(new IRuntimeClasspathEntry[0]);
                LaunchConfigurationManagementUtils.updateConfigurationClasspath(configuration, updatedEntries);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_0, ajc$tjp_1);
            CoreException cEx = coreException;
            AJLog.log((String)cEx.getMessage());
        }
    }

    public static void updateOutJar(IJavaProject project, IClasspathEntry oldOutJar, IClasspathEntry newOutJar) {
        try {
            String projectName = project.getElementName();
            List configs = LaunchConfigurationManagementUtils.getLaunchConfigsForProject(projectName);
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)iter.next();
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
                ArrayList<IRuntimeClasspathEntry> entriesAsList = new ArrayList<IRuntimeClasspathEntry>(Arrays.asList(entries));
                if (oldOutJar != null) {
                    Iterator iterator2 = entriesAsList.iterator();
                    while (iterator2.hasNext()) {
                        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator2.next();
                        if (entry.getClasspathProperty() != 3 || !oldOutJar.equals(entry.getClasspathEntry())) continue;
                        iterator2.remove();
                        break;
                    }
                }
                if (newOutJar != null) {
                    entriesAsList.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(newOutJar));
                }
                IRuntimeClasspathEntry[] updatedEntries = entriesAsList.toArray(new IRuntimeClasspathEntry[0]);
                LaunchConfigurationManagementUtils.updateConfigurationClasspath(configuration, updatedEntries);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_2, ajc$tjp_3);
            CoreException cEx = coreException;
            AJLog.log((String)cEx.getMessage());
        }
    }

    private static void updateConfigurationClasspath(ILaunchConfiguration configuration, IRuntimeClasspathEntry[] classpath) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            try {
                ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                int i = 0;
                while (i < classpath.length) {
                    IRuntimeClasspathEntry entry = classpath[i];
                    mementos.add(entry.getMemento());
                    ++i;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_4, ajc$tjp_5);
                CoreException e = coreException;
                AJLog.log((String)e.getMessage());
            }
            wc.doSave();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_6, ajc$tjp_5);
            CoreException e1 = coreException;
            AJLog.log((String)e1.getMessage());
        }
    }

    private static List getLaunchConfigsForProject(String projectName) {
        ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJConfigurationType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_7, ajc$tjp_8);
            CoreException cEx = coreException;
            AJLog.log((String)cEx.getMessage());
        }
        return candidateConfigs;
    }

    static {
        Factory factory = new Factory("LaunchConfigurationManagementUtils.java", Class.forName("org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.core.runtime.CoreException-cEx-"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-updateAspectPaths-org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.jdt.core.IJavaProject:java.util.List:java.util.List:-project:existingAspectPathEntries:newAspectPathEntries:--void-"), 49);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.core.runtime.CoreException-cEx-"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-updateOutJar-org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.jdt.core.IJavaProject:org.eclipse.jdt.core.IClasspathEntry:org.eclipse.jdt.core.IClasspathEntry:-project:oldOutJar:newOutJar:--void-"), 105);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.core.runtime.CoreException-e-"), 166);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-updateConfigurationClasspath-org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.debug.core.ILaunchConfiguration:[Lorg.eclipse.jdt.launching.IRuntimeClasspathEntry;:-configuration:classpath:--void-"), 147);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.core.runtime.CoreException-e1-"), 170);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-org.eclipse.core.runtime.CoreException-cEx-"), 197);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getLaunchConfigsForProject-org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils-java.lang.String:-projectName:--java.util.List-"), 180);
    }
}

