/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.CoreProjectProperties;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectProperties
extends CoreProjectProperties {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public String getExecutionArgs() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        return AspectJPreferences.getCompilerOptions(project);
    }

    public void clearMarkers(boolean recurse) {
        IProject currProject = AspectJPlugin.getDefault().getCurrentProject();
        try {
            currProject.deleteMarkers("org.eclipse.jdt.core.problem", false, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.core.resources.taskmarker", true, recurse ? 2 : 0);
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public IResource findResource(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(fullPath);
        return root.getFileForLocation((IPath)path);
    }

    private String toCanonical(String path) {
        if (path.charAt(1) == ':' && (path.charAt(0) >= 'a' && path.charAt(0) <= 'z' || path.charAt(0) >= 'A' && path.charAt(0) <= 'Z')) {
            return String.valueOf(Character.toUpperCase(path.charAt(0))) + path.substring(1);
        }
        return path;
    }

    private boolean caseInsensitiveMatch(String toMatch, IResource resource) {
        if (toMatch.charAt(1) == ':') {
            return toMatch.toLowerCase().startsWith(resource.getLocation().toString().toLowerCase());
        }
        return false;
    }

    public IResource findResource(String fullPath, IProject p) {
        String toMatch = this.toCanonical(fullPath.replace('\\', '/'));
        try {
            IJavaProject jp = JavaCore.create((IProject)p);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath pe;
                IClasspathEntry e = cpes[i];
                if (e.getEntryKind() == 3 && (pe = e.getPath()).segment(0).equals(p.getName())) {
                    IProject iproj;
                    String postfix;
                    Path postfixPath;
                    IResource ires = p.findMember(pe.removeFirstSegments(1));
                    if (ires instanceof IFolder) {
                        IFolder f = (IFolder)ires;
                        if ((toMatch.startsWith(this.toCanonical(f.getLocation().toString())) || this.caseInsensitiveMatch(toMatch, (IResource)f)) && f.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(f.getLocation().toString().length()))))) {
                            return f.findMember((IPath)postfixPath);
                        }
                    } else if (ires instanceof IProject && (toMatch.startsWith(this.toCanonical((iproj = (IProject)ires).getLocation().toString())) || this.caseInsensitiveMatch(toMatch, (IResource)iproj)) && iproj.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(iproj.getLocation().toString().length()))))) {
                        return iproj.findMember((IPath)postfixPath);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
        String projectPathStr = p.getLocation().toString();
        try {
            projectPathStr = p.getLocation().toFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_4, ajc$tjp_3);
        }
        Path projectPath = new Path(projectPathStr);
        Path filePath = new Path(fullPath);
        if (projectPath.isPrefixOf((IPath)filePath)) {
            filePath = filePath.removeFirstSegments(projectPath.segmentCount());
        }
        IResource ret = p.findMember((IPath)filePath);
        return ret;
    }

    public String getAspectjrtClasspath() {
        return CoreUtils.getAspectjrtClasspath();
    }

    private void getProjectRelativePaths(IResource[] resource_list, List allProjectFiles, CoreUtils.FilenameFilter filter, int trimSegments) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments);
                } else if (filter.accept(ir.getName())) {
                    String[] segments = ir.getProjectRelativePath().segments();
                    String path = "";
                    int j = trimSegments;
                    while (j < segments.length) {
                        path = String.valueOf(path) + segments[j];
                        if (j < segments.length - 1) {
                            path = String.valueOf(path) + '/';
                        }
                        ++j;
                    }
                    allProjectFiles.add(path);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_5, ajc$tjp_6);
        }
    }

    public List getBuildConfigFiles() {
        return new ArrayList();
    }

    public Map getSourcePathResources() {
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        HashMap<String, File> map = new HashMap<String, File>();
        try {
            String realOutputLocation;
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = jProject.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                realOutputLocation = out.getLocation().toOSString();
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    ArrayList files = new ArrayList();
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath = sourcePath.removeFirstSegments(1))};
                    if (srcContainer[0] != null) {
                        this.getProjectRelativePaths(srcContainer, files, CoreUtils.RESOURCE_FILTER, srcContainer[0].getFullPath().segmentCount() - 1);
                        ArrayList linkedSrcFolders = this.getLinkedChildFolders(srcContainer[0]);
                        Iterator it = files.iterator();
                        while (it.hasNext()) {
                            File file;
                            String relPath = (String)it.next();
                            String fullPath = this.getResourceFullPath(srcContainer[0], relPath, linkedSrcFolders);
                            if (fullPath.startsWith(realOutputLocation) || relPath.endsWith(".classpath") || relPath.endsWith(".project") || relPath.endsWith(".ajsym") || relPath.endsWith(".lst") || !(file = new File(fullPath)).exists()) continue;
                            map.put(relPath, file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_7, ajc$tjp_8);
        }
        return map;
    }

    private ArrayList getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFolder && children[i].isLinked()) {
                        resultList.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_9, ajc$tjp_10);
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            Iterator it = linkedFolders.iterator();
            while (it.hasNext()) {
                IFolder folder = (IFolder)it.next();
                String linkedFolderName = folder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(folder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    static {
        Factory factory = new Factory("ProjectProperties.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-clearMarkers-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-boolean:-recurse:--void-"), 73);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLinkedChildFolders-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.resources.IResource:-resource:--java.util.ArrayList-"), 315);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 185);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-findResource-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.String:org.eclipse.core.resources.IProject:-fullPath:p:--org.eclipse.core.resources.IResource-"), 130);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.io.IOException-<missing>-"), 191);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 230);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProjectRelativePaths-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:org.eclipse.ajdt.core.CoreUtils$FilenameFilter:int:-resource_list:allProjectFiles:filter:trimSegments:--void-"), 210);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 306);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSourcePathResources-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.util.Map-"), 251);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 327);
    }
}

