/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AspectJBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private IEditorStatusLine fStatusLine;
    private ToggleBreakpointAdapter fBreakpointAdapter;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public AspectJBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor, IEditorPart editorPart) {
        super(ActionMessages.ManageBreakpointRulerAction_label);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter((Class)clazz);
        this.fBreakpointAdapter = new ToggleBreakpointAdapter();
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    public void run() {
        try {
            List list = this.getMarkers();
            if (list.isEmpty()) {
                IDocument document = this.getDocument();
                int lineNumber = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
                if (lineNumber >= document.getNumberOfLines()) {
                    return;
                }
                try {
                    IRegion line = document.getLineInformation(lineNumber);
                    TextSelection selection = new TextSelection(document, line.getOffset(), line.getLength());
                    this.fBreakpointAdapter.toggleLineBreakpoints((IWorkbenchPart)this.fTextEditor, (ISelection)selection);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IMarker marker = (IMarker)iterator.next();
                    IBreakpoint breakpoint = manager.getBreakpoint(marker);
                    if (breakpoint == null) continue;
                    breakpoint.delete();
                }
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, ajc$tjp_3);
            CoreException e = coreException;
            JDIDebugUIPlugin.errorDialog((String)ActionMessages.ManageBreakpointRulerAction_error_adding_message1, (Throwable)e);
        }
    }

    protected IResource getResource() {
        IFile resource = null;
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)editorInput).getFile();
        }
        return resource;
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model.getMarkerPosition(markers[i]), document)) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, ajc$tjp_5);
                CoreException x = coreException;
                JDIDebugUIPlugin.log((IStatus)x.getStatus());
            }
        }
        return breakpoints;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AspectJBreakpointRulerAction.this.fStatusLine != null) {
                    AspectJBreakpointRulerAction.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    static {
        Factory factory = new Factory("AspectJBreakpointRulerAction.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction-java.lang.ClassNotFoundException-<missing>-"), 61);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction-org.eclipse.jface.text.source.IVerticalRulerInfo:org.eclipse.ui.texteditor.ITextEditor:org.eclipse.ui.IEditorPart:-ruler:editor:editorPart:--"), 55);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction-org.eclipse.core.runtime.CoreException-e-"), 135);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction----void-"), 106);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction-org.eclipse.core.runtime.CoreException-x-"), 191);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getMarkers-org.eclipse.ajdt.internal.ui.editor.AspectJBreakpointRulerAction----java.util.List-"), 154);
    }
}

