/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.weaver.patterns.Pointcut;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTStructureViewNodeAdapter;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class AJDTStructureViewNode
implements IStructureViewNode,
IAdaptable {
    private static final String JDT_IMPORTS_LABEL;
    private IStructureViewNode.Kind kind = IStructureViewNode.Kind.DECLARATION;
    private String relationshipName = null;
    private List children = new ArrayList();
    private AJDTIcon icon;
    private IProgramElement node;
    private AJDTStructureViewNode parent = null;
    private IMarker marker = null;
    private boolean computedCategory = false;
    private int category = 12;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("AJDTStructureViewNode.java", Class.forName("org.eclipse.ajdt.internal.utils.AJDTStructureViewNode"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTStructureViewNode-java.lang.ClassNotFoundException-<missing>-"), 154);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAdapter-org.eclipse.ajdt.internal.utils.AJDTStructureViewNode-java.lang.Class:-adapter:--java.lang.Object-"), 153);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.utils.AJDTStructureViewNode-org.eclipse.core.runtime.CoreException-<missing>-"), 178);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMarker-org.eclipse.ajdt.internal.utils.AJDTStructureViewNode-org.eclipse.core.resources.IProject:-currentProject:--org.eclipse.core.resources.IMarker-"), 164);
        JDT_IMPORTS_LABEL = UIMessages.AJDTStructureViewNode_import_declarations;
    }

    private AJDTStructureViewNode() {
    }

    public AJDTStructureViewNode(IRelationship relationship, AbstractIcon icon) {
        this.icon = (AJDTIcon)icon;
        this.kind = IStructureViewNode.Kind.RELATIONSHIP;
        this.relationshipName = String.valueOf(relationship.getName()) + (relationship.hasRuntimeTest() ? " " + UIMessages.AJDTStructureViewNode_runtime_test : "");
    }

    public AJDTStructureViewNode(IProgramElement node, AbstractIcon icon) {
        this.icon = (AJDTIcon)icon;
        this.kind = IStructureViewNode.Kind.LINK;
        this.node = node;
    }

    public AJDTStructureViewNode(IProgramElement node, AbstractIcon icon, List children) {
        this.children = children;
        this.icon = (AJDTIcon)icon;
        boolean isImportContainer = node.getName().equals(JDT_IMPORTS_LABEL);
        if (isImportContainer) {
            this.icon = AspectJImages.JDT_IMPORT_CONTAINER;
        }
        this.kind = IStructureViewNode.Kind.DECLARATION;
        this.node = node;
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                AJDTStructureViewNode child = (AJDTStructureViewNode)it.next();
                child.setParent(this);
                if (!isImportContainer) continue;
                child.icon = AspectJImages.JDT_IMPORTED;
            }
        }
    }

    public AbstractIcon getIcon() {
        return this.icon;
    }

    public List getChildren() {
        return this.children;
    }

    public AJDTStructureViewNode getParent() {
        return this.parent;
    }

    public String getLabel() {
        String ret = null;
        ret = this.kind == IStructureViewNode.Kind.RELATIONSHIP ? this.relationshipName : (this.kind == IStructureViewNode.Kind.LINK ? this.node.toLinkLabelString(false) : this.node.toLabelString());
        return ret;
    }

    private void setParent(AJDTStructureViewNode parent) {
        this.parent = parent;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return AJDTStructureViewNodeAdapter.getDefault();
        }
        return null;
    }

    public IMarker getMarker(IProject currentProject) {
        IResource ir;
        ISourceLocation sLoc;
        if (this.marker != null) {
            return this.marker;
        }
        IProgramElement targetNode = this.node;
        if (targetNode != null && (sLoc = targetNode.getSourceLocation()) != null && sLoc.getSourceFile().getAbsolutePath() != null && (ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(sLoc.getSourceFile().getAbsolutePath(), currentProject)) != null) {
            try {
                this.marker = ir.createMarker("org.eclipse.core.resources.marker");
                this.marker.setAttribute("lineNumber", sLoc.getLine());
                this.marker.setAttribute("charStart", sLoc.getColumn());
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, ajc$tjp_3);
            }
        }
        return this.marker;
    }

    public void add(IStructureViewNode child) {
        this.children.add(child);
        ((AJDTStructureViewNode)child).setParent(this);
    }

    public void remove(IStructureViewNode child) {
        this.children.remove(child);
    }

    public int category() {
        if (!this.computedCategory) {
            this.computedCategory = true;
            IProgramElement pNode = this.node;
            IProgramElement.Kind kind = pNode.getKind();
            if (kind.equals(IProgramElement.Kind.PACKAGE)) {
                this.category = 0;
            } else if (kind.equals(IProgramElement.Kind.CLASS)) {
                this.category = 2;
            } else if (kind.equals(IProgramElement.Kind.INTERFACE)) {
                this.category = 3;
            } else if (kind.equals(IProgramElement.Kind.ASPECT)) {
                this.category = 4;
            } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
                this.category = 5;
            } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_FIELD)) {
                this.category = 5;
            } else if (kind.equals(IProgramElement.Kind.INTER_TYPE_METHOD)) {
                this.category = 5;
            } else if (kind.equals(IProgramElement.Kind.POINTCUT)) {
                this.category = 7;
            } else if (kind.equals(IProgramElement.Kind.DECLARE_ERROR) || kind.equals(IProgramElement.Kind.DECLARE_WARNING) || kind.equals(IProgramElement.Kind.DECLARE_PARENTS) || kind.equals(IProgramElement.Kind.DECLARE_SOFT)) {
                this.category = 8;
            } else if (kind.equals(IProgramElement.Kind.ADVICE)) {
                this.category = 9;
            } else if (kind.equals(IProgramElement.Kind.FIELD)) {
                this.category = 6;
            } else if (kind.equals(IProgramElement.Kind.CONSTRUCTOR)) {
                this.category = 10;
            } else if (kind.equals(IProgramElement.Kind.METHOD)) {
                this.category = 11;
            }
            if (this.getLabel().equals(JDT_IMPORTS_LABEL)) {
                this.category = 1;
            }
        }
        return this.category;
    }

    public boolean isPublic() {
        boolean isPublic = true;
        IProgramElement.Accessibility acc = this.node.getAccessibility();
        if (acc != null && !acc.equals(IProgramElement.Accessibility.PUBLIC)) {
            isPublic = false;
        }
        return isPublic;
    }

    public void add(IStructureViewNode child, int position) {
        this.children.add(position, child);
        ((AJDTStructureViewNode)child).setParent(this);
    }

    public IStructureViewNode.Kind getKind() {
        return this.kind;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public IProgramElement getStructureNode() {
        return this.node;
    }

    public Object getRelationshipsSource() {
        return this;
    }

    public Collection getRelationships() {
        ArrayList<Object> rels = new ArrayList<Object>();
        Iterator c = this.children.iterator();
        while (c.hasNext()) {
            AJDTStructureViewNode child = (AJDTStructureViewNode)c.next();
            if (child.kind != IStructureViewNode.Kind.RELATIONSHIP) continue;
            rels.add(new AJDTNodeRelationship(child));
        }
        if (this.node.getKind() == IProgramElement.Kind.POINTCUT) {
            rels.add(new AJDTPointcutMatcher(this));
        }
        return rels;
    }

    public static interface Category {
        public static final int PACKAGE = 0;
        public static final int IMPORTS = 1;
        public static final int CLASS = 2;
        public static final int INTERFACE = 3;
        public static final int ASPECT = 4;
        public static final int INTRODUCTION = 5;
        public static final int FIELD = 6;
        public static final int POINTCUT = 7;
        public static final int DECLARATION = 8;
        public static final int ADVICE = 9;
        public static final int CONSTRUCTOR = 10;
        public static final int METHOD = 11;
        public static final int OTHER = 12;
    }

    static class AJDTNodeRelationship {
        private AJDTStructureViewNode anchor = null;

        public AJDTNodeRelationship(AJDTStructureViewNode anchor) {
            this.anchor = anchor;
        }

        public String getName() {
            return this.anchor.relationshipName;
        }

        public Iterator getAssociates() {
            return this.anchor.children.iterator();
        }
    }

    static class AJDTPointcutMatcher {
        private AJDTStructureViewNode anchor = null;

        public AJDTPointcutMatcher(AJDTStructureViewNode anchor) {
            this.anchor = anchor;
        }

        public String getName() {
            return UIMessages.AJDTStructureViewNode_matches;
        }

        public Iterator getAssociates() {
            ArrayList<AJDTStructureViewNode> l = new ArrayList<AJDTStructureViewNode>();
            l.add(this.anchor);
            return l.iterator();
        }

        public void run() {
            Pointcut p = Pointcut.fromString((String)"execution(* *(..))");
            p.toString();
        }
    }
}

