/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.internal.launching.AJClasspathModel;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddLibraryAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RestoreDefaultEntriesAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.BootpathFilter;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AJClasspathTab
extends JavaClasspathTab {
    protected RuntimeClasspathViewer fClasspathViewer;
    private AJClasspathModel fModel;
    protected static final String DIALOG_SETTINGS_PREFIX = "JavaClasspathTab";
    protected ILaunchConfiguration fLaunchConfiguration;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        Label label = new Label(comp, 0);
        label.setText(LauncherMessages.JavaClasspathTab_0);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fClasspathViewer = new RuntimeClasspathViewer(comp);
        this.fClasspathViewer.addEntriesChangedListener((IEntriesChangedListener)this);
        this.fClasspathViewer.getControl().setFont(font);
        this.fClasspathViewer.setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.fClasspathViewer.setContentProvider((IContentProvider)new ClasspathContentProvider((JavaClasspathTab)this));
        if (!this.isShowBootpath()) {
            this.fClasspathViewer.addFilter((ViewerFilter)new BootpathFilter());
        }
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createPathButtons(pathButtonComp);
    }

    protected void createPathButtons(Composite pathButtonComp) {
        ArrayList<AddFolderAction> advancedActions = new ArrayList<AddFolderAction>(5);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveUpAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new MoveDownAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new RemoveAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddProjectAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddJarAction((IClasspathViewer)this.fClasspathViewer));
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddExternalJarAction((IClasspathViewer)this.fClasspathViewer, DIALOG_SETTINGS_PREFIX));
        AddFolderAction action = new AddFolderAction(null);
        advancedActions.add(action);
        action = new AddExternalFolderAction(null, DIALOG_SETTINGS_PREFIX);
        advancedActions.add(action);
        action = new AddVariableAction(null);
        advancedActions.add(action);
        action = new AddLibraryAction(null);
        advancedActions.add(action);
        action = new AttachSourceAction(null, 16);
        advancedActions.add(action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)new AddAdvancedAction((IClasspathViewer)this.fClasspathViewer, adv));
        action = new RestoreDefaultEntriesAction((IClasspathViewer)this.fClasspathViewer, (JavaClasspathTab)this);
        this.createButton(pathButtonComp, (RuntimeClasspathAction)action);
        action.setEnabled(true);
    }

    protected Button createButton(Composite pathButtonComp, RuntimeClasspathAction action) {
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.refresh(configuration);
        this.updateClassPathWithAspectPathAndOutJar(configuration);
        this.fClasspathViewer.expandToLevel(2);
    }

    private void updateClassPathWithAspectPathAndOutJar(ILaunchConfiguration configuration) {
        block7: {
            if (this.fModel == null) {
                return;
            }
            try {
                ILaunchConfigurationWorkingCopy wc = configuration instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
                IRuntimeClasspathEntry[] classpath = LaunchConfigurationClasspathUtils.getCurrentClasspath(this.fModel);
                boolean def = LaunchConfigurationClasspathUtils.isDefaultClasspath(classpath, (ILaunchConfiguration)wc);
                if (def) {
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                    break block7;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    CoreException e = coreException;
                    AJLog.log((String)e.getMessage());
                }
                wc.doSave();
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, ajc$tjp_1);
                CoreException e1 = coreException;
                AJLog.log((String)e1.getMessage());
            }
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            boolean useDefault = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (useDefault && !this.isDefaultClasspath(this.getCurrentClasspath(), (ILaunchConfiguration)workingCopy)) {
                this.initializeFrom((ILaunchConfiguration)workingCopy);
                return;
            }
            this.fClasspathViewer.refresh();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_3, ajc$tjp_4);
        }
    }

    private void refresh(ILaunchConfiguration configuration) {
        CoreException e;
        boolean useDefault = true;
        this.setErrorMessage(null);
        try {
            useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_5, ajc$tjp_6);
            e = coreException;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        if (configuration == this.getLaunchConfiguration() && !useDefault) {
            this.setDirty(false);
            return;
        }
        this.setLaunchConfiguration(configuration);
        try {
            this.fModel = LaunchConfigurationClasspathUtils.createClasspathModel(configuration);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_7, ajc$tjp_6);
            e = coreException;
            this.setErrorMessage(e.getMessage());
        }
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fClasspathViewer.setInput((Object)this.fModel);
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            IRuntimeClasspathEntry[] classpath = this.getCurrentClasspath();
            boolean def = this.isDefaultClasspath(classpath, configuration.getOriginal());
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_8, ajc$tjp_9);
                    CoreException e = coreException;
                    JDIDebugUIPlugin.errorDialog((String)LauncherMessages.JavaClasspathTab_Unable_to_save_classpath_1, (Throwable)e);
                }
            }
        }
    }

    private IRuntimeClasspathEntry[] getCurrentClasspath() {
        IRuntimeClasspathEntry entry;
        IClasspathEntry[] boot = this.fModel.getEntries(0);
        IClasspathEntry[] user = this.fModel.getEntries(1);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(boot.length + user.length);
        int i = 0;
        while (i < boot.length) {
            IClasspathEntry bootEntry = boot[i];
            entry = null;
            if (bootEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)bootEntry).getDelegate();
            } else if (bootEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)boot[i];
            }
            if (entry != null) {
                if (entry.getClasspathProperty() == 3) {
                    entry.setClasspathProperty(2);
                }
                entries.add(entry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length) {
            IClasspathEntry userEntry = user[i2];
            entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i2];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i2;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    private boolean isDefaultClasspath(IRuntimeClasspathEntry[] classpath, ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            if (classpath.length == entries.length) {
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry entry = entries[i];
                    if (!entry.equals(classpath[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_10, ajc$tjp_11);
            return false;
        }
    }

    public String getName() {
        return LauncherMessages.JavaClasspathTab_Cla_ss_path_3;
    }

    public static Image getClasspathImage() {
        return JavaDebugImages.get((String)"IMG_OBJS_CLASSPATH");
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    public void dispose() {
        if (this.fClasspathViewer != null) {
            this.fClasspathViewer.removeEntriesChangedListener((IEntriesChangedListener)this);
        }
        super.dispose();
    }

    public Image getImage() {
        return AJClasspathTab.getClasspathImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = null;
        try {
            projectName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_12, ajc$tjp_13);
            return false;
        }
        if (projectName.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(projectName, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_20, projectName));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_21, projectName));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_19, status.getMessage()));
                return false;
            }
        }
        IRuntimeClasspathEntry[] entries = this.fModel.getAllEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getType() == 2 && !entries[i].getPath().isAbsolute()) {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaClasspathTab_Invalid_runtime_classpath_1, entries[i].getPath().toString()));
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isShowBootpath() {
        return true;
    }

    protected ClasspathModel getModel() {
        return this.fModel;
    }

    static {
        Factory factory = new Factory("AJClasspathTab.java", Class.forName("org.eclipse.ajdt.internal.launching.AJClasspathTab"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 241);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateClassPathWithAspectPathAndOutJar-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfiguration:-configuration:--void-"), 202);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-<missing>-"), 400);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isDefaultClasspath-org.eclipse.ajdt.internal.launching.AJClasspathTab-[Lorg.eclipse.jdt.launching.IRuntimeClasspathEntry;:org.eclipse.debug.core.ILaunchConfiguration:-classpath:configuration:--boolean-"), 385);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-<missing>-"), 459);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isValid-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfiguration:-launchConfig:--boolean-"), 453);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e1-"), 246);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-<missing>-"), 265);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-activated-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfigurationWorkingCopy:-workingCopy:--void-"), 255);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 278);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-refresh-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfiguration:-configuration:--void-"), 273);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 296);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 326);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performApply-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfigurationWorkingCopy:-configuration:--void-"), 310);
    }
}

