/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine;
import org.eclipse.ajdt.internal.launching.AJMainTypeSelectionDialog;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.SharedJavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AspectJMainTab
extends SharedJavaMainTab {
    public static final String ATTR_INCLUDE_EXTERNAL_JARS;
    public static final String ATTR_CONSIDER_INHERITED_MAIN;
    private Button fSearchExternalJarsCheckButton;
    private Button fConsiderInheritedMainButton;
    private Button fStopInMainCheckButton;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("AspectJMainTab.java", Class.forName("org.eclipse.ajdt.internal.launching.AspectJMainTab"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.jdt.core.JavaModelException-e-"), 140);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-handleSearchButtonSelected-org.eclipse.ajdt.internal.launching.AspectJMainTab----void-"), 131);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-java.lang.reflect.InvocationTargetException-e-"), 164);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-java.lang.InterruptedException-e-"), 168);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.core.runtime.CoreException-e-"), 289);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateExternalJars-org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.debug.core.ILaunchConfiguration:-config:--void-"), 284);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.core.runtime.CoreException-e-"), 302);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateInheritedMainsFromConfig-org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.debug.core.ILaunchConfiguration:-config:--void-"), 297);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.core.runtime.CoreException-e-"), 315);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateStopInMainFromConfig-org.eclipse.ajdt.internal.launching.AspectJMainTab-org.eclipse.debug.core.ILaunchConfiguration:-config:--void-"), 310);
        ATTR_INCLUDE_EXTERNAL_JARS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".INCLUDE_EXTERNAL_JARS";
        ATTR_CONSIDER_INHERITED_MAIN = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".CONSIDER_INHERITED_MAIN";
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.fSearchExternalJarsCheckButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_E_xt__jars_6);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fSearchExternalJarsCheckButton.setLayoutData((Object)gd);
        this.fSearchExternalJarsCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fConsiderInheritedMainButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_22);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fConsiderInheritedMainButton.setLayoutData((Object)gd);
        this.fConsiderInheritedMainButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.fStopInMainCheckButton = this.createCheckButton(parent, LauncherMessages.JavaMainTab_St_op_in_main_1);
        gd = new GridData();
        this.fStopInMainCheckButton.setLayoutData((Object)gd);
        this.fStopInMainCheckButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.createMainTypeEditor(comp, LauncherMessages.JavaMainTab_Main_cla_ss__4, new Button[]{this.fSearchExternalJarsCheckButton, this.fConsiderInheritedMainButton, this.fStopInMainCheckButton});
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public String getName() {
        return LauncherMessages.JavaMainTab__Main_19;
    }

    protected void handleSearchButtonSelected() {
        IJavaProject project = this.getJavaProject();
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    JavaModelException e = javaModelException;
                    JDIDebugUIPlugin.log((Throwable)e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 2;
            constraints |= 4;
        }
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        AJMainMethodSearchEngine engine = new AJMainMethodSearchEngine();
        Object[] types = null;
        try {
            types = engine.searchMainMethodsIncludingAspects((IRunnableContext)this.getLaunchConfigurationDialog(), searchScope, this.fConsiderInheritedMainButton.getSelection());
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_2, ajc$tjp_1);
            InvocationTargetException e = invocationTargetException;
            this.setErrorMessage(e.getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_3, ajc$tjp_1);
            InterruptedException e = interruptedException;
            this.setErrorMessage(e.getMessage());
            return;
        }
        AJMainTypeSelectionDialog dialog = null;
        dialog = new AJMainTypeSelectionDialog(this.getShell(), types);
        dialog.setTitle(LauncherMessages.JavaMainTab_Choose_Main_Type_11);
        dialog.setMessage(LauncherMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            this.fProjText.setText(type.getJavaProject().getElementName());
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateMainTypeFromConfig(config);
        this.updateStopInMainFromConfig(config);
        this.updateInheritedMainsFromConfig(config);
        this.updateExternalJars(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_20, name));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_21, name));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.JavaMainTab_19, status.getMessage()));
                return false;
            }
        }
        if ((name = this.fMainText.getText().trim()).length() == 0) {
            this.setErrorMessage(LauncherMessages.JavaMainTab_Main_type_not_specified_16);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText().trim());
        if (this.fStopInMainCheckButton.getSelection()) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, true);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, null);
        }
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, true);
        } else {
            config.setAttribute(ATTR_INCLUDE_EXTERNAL_JARS, null);
        }
        if (this.fConsiderInheritedMainButton.getSelection()) {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, true);
        } else {
            config.setAttribute(ATTR_CONSIDER_INHERITED_MAIN, null);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.initializeMainTypeAndName(javaElement, config);
    }

    private void updateExternalJars(ILaunchConfiguration config) {
        boolean search = false;
        try {
            search = config.getAttribute(ATTR_INCLUDE_EXTERNAL_JARS, false);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, ajc$tjp_5);
            CoreException e = coreException;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fSearchExternalJarsCheckButton.setSelection(search);
    }

    private void updateInheritedMainsFromConfig(ILaunchConfiguration config) {
        boolean inherit = false;
        try {
            inherit = config.getAttribute(ATTR_CONSIDER_INHERITED_MAIN, false);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_6, ajc$tjp_7);
            CoreException e = coreException;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fConsiderInheritedMainButton.setSelection(inherit);
    }

    private void updateStopInMainFromConfig(ILaunchConfiguration config) {
        boolean stop = false;
        try {
            stop = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_8, ajc$tjp_9);
            CoreException e = coreException;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        this.fStopInMainCheckButton.setSelection(stop);
    }
}

