/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.builder.CoreProjectProperties;
import org.eclipse.ajdt.core.exports.AJBuildScriptGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;

public class BuildPluginAction
extends BaseBuildAction {
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AJBuildScriptGenerator generator = new AJBuildScriptGenerator();
        AJBuildScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        AJBuildScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        AJBuildScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        IProject project = this.fManifestFile.getProject();
        List inpath = this.getInpath(project);
        List aspectpath = this.getAspectpath(project);
        generator.setInpath(inpath);
        generator.setAspectpath(aspectpath);
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(project.getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(url);
        generator.setPDEState(TargetPlatform.getState());
        generator.setNextId(TargetPlatform.getPDEState().getNextId());
        generator.setStateExtraData(TargetPlatform.getBundleClasspaths((PDEState)TargetPlatform.getPDEState()), TargetPlatform.getPatchMap((PDEState)TargetPlatform.getPDEState()));
        generator.setBuildingOSGi(true);
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
        generator.setElements(new String[]{"plugin@" + model.getPluginBase().getId()});
        generator.generate();
    }

    private List getAspectpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectAspectPath((IProject)project);
        ProjectPropertiesAdapter adapter = Ajde.getDefault().getProjectProperties();
        if (adapter instanceof CoreProjectProperties) {
            String aspectPath = ((CoreProjectProperties)adapter).expandVariables(v[0], v[2]);
            if ((aspectPath = ((CoreProjectProperties)adapter).fullyQualifyPathEntries(aspectPath)).length() > 0) {
                String[] entries = aspectPath.split(File.pathSeparator);
                ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
                return entryList;
            }
        }
        return null;
    }

    private List getInpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectInPath((IProject)project);
        ProjectPropertiesAdapter adapter = Ajde.getDefault().getProjectProperties();
        if (adapter instanceof CoreProjectProperties) {
            String inPath = ((CoreProjectProperties)adapter).expandVariables(v[0], v[2]);
            if ((inPath = ((CoreProjectProperties)adapter).fullyQualifyPathEntries(inPath)).length() > 0) {
                String[] entries = inPath.split(File.pathSeparator);
                ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
                return entryList;
            }
        }
        return null;
    }
}

