/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.dialogs.AJTypeInfoLabelProvider;
import org.eclipse.ajdt.internal.ui.dialogs.TypeInfoViewer;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class TypeSelectionComponent
extends Composite {
    private IDialogSettings fSettings;
    private boolean fMultipleSelection;
    private ITitleLabel fTitleLabel;
    private ToolBar fToolBar;
    private ToolItem fToolItem;
    private MenuManager fMenuManager;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private TypeSelectionExtension fTypeSelectionExtension;
    private Text fFilter;
    private String fInitialFilterText;
    private IJavaSearchScope fScope;
    private TypeInfoViewer fViewer;
    private ViewForm fForm;
    private CLabel fLabel;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static final String DIALOG_SETTINGS = "org.eclipse.jdt.internal.ui.dialogs.TypeSelectionComponent";
    private static final String SHOW_STATUS_LINE = "show_status_line";
    private static final String FULLY_QUALIFY_DUPLICATES = "fully_qualify_duplicates";
    private static final String WORKINGS_SET_SETTINGS = "workingset_settings";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public TypeSelectionComponent(Composite parent, int style, String message, boolean multi, IJavaSearchScope scope, int elementKind, String initialFilter, ITitleLabel titleLabel, TypeSelectionExtension extension) {
        super(parent, style);
        this.setFont(parent.getFont());
        this.fMultipleSelection = multi;
        this.fScope = scope;
        this.fInitialFilterText = initialFilter;
        this.fTitleLabel = titleLabel;
        this.fTypeSelectionExtension = extension;
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
        }
        if (this.fSettings.get(SHOW_STATUS_LINE) == null) {
            this.fSettings.put(SHOW_STATUS_LINE, true);
        }
        this.createContent(message, elementKind);
    }

    public TypeInfo[] getSelection() {
        return this.fViewer.getSelection();
    }

    public IJavaSearchScope getScope() {
        return this.fScope;
    }

    private void createContent(String message, int elementKind) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Font font = this.getFont();
        Control header = this.createHeader(this, font, message);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        header.setLayoutData((Object)gd);
        this.fFilter = new Text((Composite)this, 0x800800);
        this.fFilter.setFont(font);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fFilter.setLayoutData((Object)gd);
        this.fFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypeSelectionComponent.this.patternChanged((Text)e.widget);
            }
        });
        this.fFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    TypeSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        Label label = new Label((Composite)this, 0);
        label.setFont(font);
        label.setText(JavaUIMessages.TypeSelectionComponent_label);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    TypeSelectionComponent.this.fViewer.setFocus();
                }
            }
        });
        label = new Label((Composite)this, 131072);
        label.setFont(font);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.fViewer = new TypeInfoViewer(this, this.fMultipleSelection ? 2 : 0, label, this.fScope, elementKind, this.fInitialFilterText, this.fTypeSelectionExtension != null ? this.fTypeSelectionExtension.getFilterExtension() : null, this.fTypeSelectionExtension != null ? this.fTypeSelectionExtension.getImageProvider() : null);
        gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)this.fViewer.getTable());
        gd.widthHint = converter.convertWidthInCharsToPixels(70);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)this.fViewer.getTable(), (int)10);
        gd.horizontalSpan = 2;
        this.fViewer.getTable().setLayoutData((Object)gd);
        this.fViewer.setFullyQualifyDuplicates(this.fSettings.getBoolean(FULLY_QUALIFY_DUPLICATES), false);
        if (!this.fMultipleSelection) {
            this.fForm = new ViewForm((Composite)this, 0x800800);
            this.fForm.setFont(font);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.exclude = !this.fSettings.getBoolean(SHOW_STATUS_LINE);
            this.fForm.setLayoutData((Object)gd);
            this.fLabel = new CLabel((Composite)this.fForm, 0x800000);
            this.fLabel.setFont(this.fForm.getFont());
            this.fForm.setContent((Control)this.fLabel);
            this.fViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){
                private TypeInfoLabelProvider fLabelProvider = new AJTypeInfoLabelProvider(40);

                public void widgetSelected(SelectionEvent event) {
                    TypeInfo[] selection = TypeSelectionComponent.this.fViewer.getSelection();
                    if (selection.length != 1) {
                        TypeSelectionComponent.this.fLabel.setText("");
                        TypeSelectionComponent.this.fLabel.setImage(null);
                    } else {
                        TypeInfo type = selection[0];
                        TypeSelectionComponent.this.fLabel.setText(TypeSelectionComponent.this.fViewer.getLabelProvider().getQualificationText(type));
                        TypeSelectionComponent.this.fLabel.setImage(this.fLabelProvider.getImage((Object)type));
                    }
                }
            });
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TypeSelectionComponent.this.disposeComponent();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fViewer.getTable().addSelectionListener(listener);
    }

    public void populate(int selectionMode) {
        if (this.fInitialFilterText != null) {
            this.fFilter.setText(this.fInitialFilterText);
            switch (selectionMode) {
                case 1: {
                    this.fFilter.setSelection(0, 0);
                    break;
                }
                case 2: {
                    this.fFilter.setSelection(0, this.fInitialFilterText.length());
                }
            }
        }
        this.fViewer.reset();
        this.fFilter.setFocus();
    }

    private void patternChanged(Text text) {
        this.fViewer.setSearchPattern(text.getText());
    }

    private Control createHeader(Composite parent, Font font, String message) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        header.setFont(font);
        Label label = new Label(header, 0);
        label.setText(message);
        label.setFont(font);
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    TypeSelectionComponent.this.fFilter.setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.createViewMenu(header);
        return header;
    }

    private void createViewMenu(Composite parent) {
        this.fToolBar = new ToolBar(parent, 0x800000);
        this.fToolItem = new ToolItem(this.fToolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.fToolBar.setLayoutData((Object)data);
        this.fToolItem.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.elcl16view_menu.gif"));
        this.fToolItem.setDisabledImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.dlcl16view_menu.gif"));
        this.fToolItem.setToolTipText(JavaUIMessages.TypeSelectionComponent_menu);
        this.fToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeSelectionComponent.this.showViewMenu();
            }
        });
        this.fMenuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.fMenuManager);
    }

    private void showViewMenu() {
        Menu menu = this.fMenuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.fToolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.fToolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    private void fillViewMenu(IMenuManager viewMenu) {
        FullyQualifyDuplicatesAction fullyQualifyDuplicatesAction = new FullyQualifyDuplicatesAction();
        fullyQualifyDuplicatesAction.setChecked(this.fSettings.getBoolean(FULLY_QUALIFY_DUPLICATES));
        viewMenu.add((IAction)fullyQualifyDuplicatesAction);
        if (!this.fMultipleSelection) {
            viewMenu.add((IContributionItem)new Separator());
            ToggleStatusLineAction showStatusLineAction = new ToggleStatusLineAction();
            showStatusLineAction.setChecked(this.fSettings.getBoolean(SHOW_STATUS_LINE));
            viewMenu.add((IAction)showStatusLineAction);
        }
        if (this.fScope == null) {
            IWorkingSet ws;
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IWorkingSet ws = (IWorkingSet)event.getNewValue();
                    if (ws == null) {
                        TypeSelectionComponent.this.fScope = SearchEngine.createWorkspaceScope();
                        TypeSelectionComponent.this.fTitleLabel.setText(null);
                    } else {
                        TypeSelectionComponent.this.fScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true);
                        TypeSelectionComponent.this.fTitleLabel.setText(ws.getName());
                    }
                    TypeSelectionComponent.this.fViewer.setSearchScope(TypeSelectionComponent.this.fScope, true);
                }
            });
            String setting = this.fSettings.get(WORKINGS_SET_SETTINGS);
            if (setting != null) {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                    this.fFilterActionGroup.restoreState((IMemento)memento);
                }
                catch (WorkbenchException workbenchException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(workbenchException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                }
            }
            if ((ws = this.fFilterActionGroup.getWorkingSet()) != null) {
                this.fScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true);
                this.fTitleLabel.setText(ws.getName());
            } else {
                this.fScope = SearchEngine.createWorkspaceScope();
                this.fTitleLabel.setText(null);
            }
            this.fFilterActionGroup.fillViewMenu(viewMenu);
        }
    }

    private void disposeComponent() {
        if (this.fFilterActionGroup != null) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)memento);
            this.fFilterActionGroup.dispose();
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                this.fSettings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_2, ajc$tjp_3);
            }
        }
    }

    static {
        Factory factory = new Factory("TypeSelectionComponent.java", Class.forName("org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent-org.eclipse.ui.WorkbenchException-<missing>-"), 376);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-fillViewMenu-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent-org.eclipse.jface.action.IMenuManager:-viewMenu:--void-"), 345);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent-java.io.IOException-<missing>-"), 400);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-disposeComponent-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent----void-"), 391);
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(JavaUIMessages.TypeSelectionComponent_show_status_line_label, 2);
        }

        public void run() {
            if (TypeSelectionComponent.this.fForm == null) {
                return;
            }
            GridData gd = (GridData)TypeSelectionComponent.this.fForm.getLayoutData();
            gd.exclude = !this.isChecked();
            TypeSelectionComponent.this.fSettings.put(TypeSelectionComponent.SHOW_STATUS_LINE, !gd.exclude);
            TypeSelectionComponent.this.layout();
        }
    }

    private class FullyQualifyDuplicatesAction
    extends Action {
        public FullyQualifyDuplicatesAction() {
            super(JavaUIMessages.TypeSelectionComponent_fully_qualify_duplicates_label, 2);
        }

        public void run() {
            boolean checked = this.isChecked();
            TypeSelectionComponent.this.fViewer.setFullyQualifyDuplicates(checked, true);
            TypeSelectionComponent.this.fSettings.put(TypeSelectionComponent.FULLY_QUALIFY_DUPLICATES, checked);
        }
    }

    public static interface ITitleLabel {
        public void setText(String var1);
    }
}

