/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.dialogs.AJTypeInfoHistory;
import org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionComponent;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TypeSelectionDialog2
extends SelectionStatusDialog {
    private String fTitle;
    private boolean fMultipleSelection;
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fElementKind;
    private String fInitialFilter;
    private int fSelectionMode;
    private ISelectionStatusValidator fValidator;
    private TypeSelectionComponent fContent;
    private TypeSelectionExtension fExtension;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static boolean fgFirstTime;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("TypeSelectionDialog2.java", Class.forName("org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2-java.lang.reflect.InvocationTargetException-e-"), 175);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-open-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2----int-"), 172);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2-java.lang.InterruptedException-<missing>-"), 178);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2-org.eclipse.jdt.core.JavaModelException-e-"), 225);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-computeResult-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2----void-"), 196);
        fgFirstTime = true;
    }

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMultipleSelection = multi;
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKind = elementKinds;
        this.fSelectionMode = 0;
        this.fExtension = extension;
        if (this.fExtension != null) {
            this.fValidator = this.fExtension.getSelectionValidator();
        }
    }

    public void setFilter(String filter) {
        this.setFilter(filter, 2);
    }

    public void setFilter(String filter, int selectionMode) {
        this.fInitialFilter = filter;
        this.fSelectionMode = selectionMode;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected TypeInfo[] getSelectedTypes() {
        if (this.fContent == null || this.fContent.isDisposed()) {
            return null;
        }
        return this.fContent.getSelection();
    }

    public void create() {
        super.create();
        this.fContent.populate(this.fSelectionMode);
        this.getOkButton().setEnabled(this.fContent.getSelection().length > 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fContent = new TypeSelectionComponent(area, 0, this.getMessage(), this.fMultipleSelection, this.fScope, this.fElementKind, this.fInitialFilter, new TitleLabel(), this.fExtension);
        GridData gd = new GridData(1808);
        this.fContent.setLayoutData(gd);
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleDefaultSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleWidgetSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }
        });
        return area;
    }

    protected void handleDefaultSelected(TypeInfo[] selection) {
        if (selection.length == 0) {
            return;
        }
        this.okPressed();
    }

    protected void handleWidgetSelected(TypeInfo[] selection) {
        Object status = selection.length == 0 ? new Status(4, JavaPlugin.getPluginId(), 4, "", null) : (this.fValidator != null ? this.fValidator.validate((Object[])selection) : new Status(0, JavaPlugin.getPluginId(), 0, "", null));
        this.updateStatus((IStatus)status);
    }

    public int open() {
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_0, ajc$tjp_1);
            InvocationTargetException e = invocationTargetException;
            ExceptionHandler.handle((InvocationTargetException)e, (String)JavaUIMessages.TypeSelectionDialog_error3Title, (String)JavaUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_2, ajc$tjp_1);
            return 1;
        }
        return super.open();
    }

    public boolean close() {
        AJTypeInfoHistory.getInstance().save();
        return super.close();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    protected void computeResult() {
        TypeInfo[] selected = this.fContent.getSelection();
        if (selected == null || selected.length == 0) {
            this.setResult(null);
            return;
        }
        if (this.fScope == null) {
            this.fScope = this.fContent.getScope();
        }
        AJTypeInfoHistory history = AJTypeInfoHistory.getInstance();
        ArrayList<IType> result = new ArrayList<IType>(selected.length);
        if (result != null) {
            int i = 0;
            while (i < selected.length) {
                try {
                    TypeInfo typeInfo = selected[i];
                    history.accessed(typeInfo);
                    IType type = typeInfo.resolveType(this.fScope);
                    if (type == null) {
                        String title = JavaUIMessages.TypeSelectionDialog_errorTitle;
                        String message = Messages.format((String)JavaUIMessages.TypeSelectionDialog_dialogMessage, (Object)typeInfo.getPath());
                        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                        this.setResult(null);
                    } else {
                        result.add(type);
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_3, ajc$tjp_4);
                    JavaModelException e = javaModelException;
                    String title = JavaUIMessages.MultiTypeSelectionDialog_errorTitle;
                    String message = JavaUIMessages.MultiTypeSelectionDialog_errorMessage;
                    ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
                }
                ++i;
            }
        }
        this.setResult(result);
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AJTypeInfoHistory history = AJTypeInfoHistory.getInstance();
                if (fgFirstTime || history.isEmpty()) {
                    monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    monitor.done();
                    fgFirstTime = false;
                } else {
                    history.checkConsistency(monitor);
                }
            }

            private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    new SearchEngine().searchAllTypeNames(null, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    }, 3, monitor);
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
                    JavaModelException e = javaModelException;
                    throw new InvocationTargetException(e);
                }
            }

            static {
                Factory factory = new Factory("TypeSelectionDialog2.java", Class.forName("org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2$2"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2$2-org.eclipse.jdt.core.JavaModelException-e-"), 263);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-refreshSearchIndices-org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog2$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:-java.lang.reflect.InvocationTargetException:-void-"), 251);
            }
        };
        IRunnableContext context = this.fRunnableContext != null ? this.fRunnableContext : PlatformUI.getWorkbench().getProgressService();
        context.run(true, true, runnable);
    }

    private class TitleLabel
    implements TypeSelectionComponent.ITitleLabel {
        TitleLabel() {
        }

        public void setText(String text) {
            if (text == null || text.length() == 0) {
                TypeSelectionDialog2.this.getShell().setText(TypeSelectionDialog2.this.fTitle);
            } else {
                TypeSelectionDialog2.this.getShell().setText(Messages.format((String)JavaUIMessages.TypeSelectionDialog2_title_format, (Object[])new String[]{TypeSelectionDialog2.this.fTitle, text}));
            }
        }
    }
}

