/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;

public class AspectJEditorTitleImageUpdater {
    private ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
    private final Image baseImage = this.registry.get(AspectJImages.ASPECTJ_FILE.getImageDescriptor());
    private final ProblemsLabelDecorator problemsDecorator;
    private AspectJEditor editor;

    public AspectJEditorTitleImageUpdater(AspectJEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
        this.problemsDecorator = new ProblemsLabelDecorator(this.registry);
    }

    public boolean updateEditorImage(IJavaElement jelement) {
        Image titleImage = this.editor.getTitleImage();
        if (titleImage == null) {
            return false;
        }
        Image newImage = this.problemsDecorator.decorateImage(this.baseImage, (Object)jelement);
        if (titleImage != newImage) {
            this.editor.customUpdatedTitleImage(newImage);
            return true;
        }
        return false;
    }

    public void dispose() {
        this.problemsDecorator.dispose();
    }
}

