/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.pde.internal.build.tasks.AJAntScript;
import org.osgi.framework.Bundle;

public class AJCTask
extends JavacTask {
    public static final String TOOLS_PLUGIN_ID = "org.aspectj.ajde";
    public static final String WEAVER_PLUGIN_ID = "org.aspectj.weaver";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.runtime";
    private String baseLocation;
    private String buildConfig;
    private String toolsLocation;
    protected List aspectpath;
    protected List inpath;

    public AJCTask(String location, String config, String toolsLocation) {
        this.baseLocation = location;
        this.buildConfig = config;
        this.toolsLocation = toolsLocation;
    }

    public void print(AntScript script) {
        if (script instanceof AJAntScript) {
            String path;
            Iterator iter;
            AJAntScript ajScript = (AJAntScript)script;
            Bundle toolsBundle = Platform.getBundle((String)TOOLS_PLUGIN_ID);
            Bundle weaverBundle = Platform.getBundle((String)WEAVER_PLUGIN_ID);
            Bundle runtimeBundle = Platform.getBundle((String)RUNTIME_PLUGIN_ID);
            try {
                URL resolved = FileLocator.resolve((URL)toolsBundle.getEntry("/"));
                IPath ajdeLocation = Utils.makeRelative((IPath)new Path(resolved.getFile()), (IPath)new Path(this.baseLocation));
                resolved = FileLocator.resolve((URL)weaverBundle.getEntry("/"));
                IPath weaverLocation = Utils.makeRelative((IPath)new Path(resolved.getFile()), (IPath)new Path(this.baseLocation));
                resolved = FileLocator.resolve((URL)runtimeBundle.getEntry("/"));
                IPath runtimeLocation = Utils.makeRelative((IPath)new Path(resolved.getFile()), (IPath)new Path(this.baseLocation));
                IPath eqcomLocation = Utils.makeRelative((IPath)new Path(this.toolsLocation), (IPath)new Path(this.baseLocation));
                ajScript.printProperty("aspectj.plugin.home", ajdeLocation.toPortableString());
                ajScript.printProperty("aspectj.weaver.home", weaverLocation.toPortableString());
                ajScript.printProperty("aspectj.runtime.home", runtimeLocation.toPortableString());
                ajScript.printProperty("eclipse.tools.home", eqcomLocation.toPortableString());
            }
            catch (IOException iOException) {}
            boolean useBuildConfig = this.buildConfig != null && this.buildConfig.length() > 0;
            ajScript.println("<taskdef resource=\"org/aspectj/tools/ant/taskdefs/aspectjTaskdefs.properties\">");
            ++ajScript.indent;
            ajScript.printStartTag("classpath");
            ++ajScript.indent;
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${aspectj.plugin.home}/ajde.jar", true);
            ajScript.print("/>");
            ajScript.println();
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${aspectj.weaver.home}/aspectjweaver.jar", true);
            ajScript.print("/>");
            ajScript.println();
            --ajScript.indent;
            ajScript.printEndTag("classpath");
            --ajScript.indent;
            ajScript.printEndTag("taskdef");
            if (useBuildConfig) {
                ajScript.printTab();
                ajScript.print("<property");
                ajScript.printAttribute("file", this.buildConfig, false);
                ajScript.print("/>");
                ajScript.println();
            }
            ajScript.printProperty("ajcArgFile", "");
            ajScript.printTab();
            ajScript.print("<iajc");
            ajScript.printAttribute("destDir", this.destdir, false);
            ajScript.printAttribute("failonerror", "true", false);
            ajScript.printAttribute("argfiles", "${ajcArgFile}", false);
            ajScript.printAttribute("verbose", "true", false);
            ajScript.printAttribute("fork", "true", false);
            if (useBuildConfig) {
                ajScript.printAttribute("srcdir", ".", false);
                ajScript.printAttribute("includes", "${src.includes}", false);
                ajScript.printAttribute("excludes", "${src.excludes}", false);
            }
            ajScript.printAttribute("maxmem", "512m", false);
            ajScript.printAttribute("debug", this.debug, false);
            ajScript.printAttribute("bootclasspath", this.bootclasspath, false);
            ajScript.printAttribute("source", this.source, false);
            ajScript.printAttribute("target", this.target, false);
            ajScript.print(">");
            ajScript.println();
            ++ajScript.indent;
            ajScript.println("<forkclasspath refid=\"" + this.classpathId + "\" />");
            ajScript.printStartTag("forkclasspath");
            ++ajScript.indent;
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${aspectj.plugin.home}/ajde.jar", true);
            ajScript.print("/>");
            ajScript.println();
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${aspectj.weaver.home}/aspectjweaver.jar", true);
            ajScript.print("/>");
            ajScript.println();
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${aspectj.runtime.home}/aspectjrt.jar", true);
            ajScript.print("/>");
            ajScript.println();
            ajScript.printTab();
            ajScript.print("<pathelement");
            ajScript.printAttribute("path", "${eclipse.tools.home}", true);
            ajScript.print("/>");
            ajScript.println();
            --ajScript.indent;
            ajScript.printEndTag("forkclasspath");
            if (this.aspectpath != null) {
                ajScript.printStartTag("aspectpath");
                ++ajScript.indent;
                iter = this.aspectpath.iterator();
                while (iter.hasNext()) {
                    path = (String)iter.next();
                    ajScript.printTab();
                    ajScript.print("<pathelement");
                    ajScript.printAttribute("path", path, false);
                    ajScript.print("/>");
                    ajScript.println();
                }
                --ajScript.indent;
                ajScript.printEndTag("aspectpath");
            }
            if (this.inpath != null) {
                ajScript.printStartTag("inpath");
                ++ajScript.indent;
                iter = this.inpath.iterator();
                while (iter.hasNext()) {
                    path = (String)iter.next();
                    ajScript.printTab();
                    ajScript.print("<pathelement");
                    ajScript.printAttribute("path", path, false);
                    ajScript.print("/>");
                    ajScript.println();
                }
                --ajScript.indent;
                ajScript.printEndTag("inpath");
            }
            if (!useBuildConfig) {
                int i = 0;
                while (i < this.srcdir.length) {
                    ajScript.printTab();
                    ajScript.print("<src path=");
                    ajScript.printQuotes(this.srcdir[i]);
                    ajScript.println("/>");
                    ++i;
                }
            }
            --ajScript.indent;
            ajScript.printEndTag("iajc");
        }
    }

    public void setAspectpath(List aspectpath) {
        this.aspectpath = aspectpath;
    }

    public void setInpath(List inpath) {
        this.inpath = inpath;
    }
}

