/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;
    private boolean didResolve = false;

    public ParameterizedSingleTypeReference(char[] name, TypeReference[] typeArguments, int dim, long pos) {
        super(name, dim, pos);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeArguments;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding currentType = parameterizedType.type;
            TypeVariableBinding[] typeVariables = currentType.typeVariables();
            TypeBinding[] argTypes = parameterizedType.arguments;
            if (argTypes != null && typeVariables != null) {
                parameterizedType.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int dim) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, dim, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        StringBuffer buffer = new StringBuffer(5);
        buffer.append(this.token).append('<');
        int i = 0;
        int length = this.typeArguments.length;
        while (i < length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(CharOperation.concatWith(this.typeArguments[i].getParameterizedTypeName(), '.'));
            ++i;
        }
        buffer.append('>');
        int nameLength = buffer.length();
        char[] name = new char[nameLength];
        buffer.getChars(0, nameLength, name, 0);
        int dim = this.dimensions;
        if (dim > 0) {
            char[] dimChars = new char[dim * 2];
            int i2 = 0;
            while (i2 < dim) {
                int index = i2 * 2;
                dimChars[index] = 91;
                dimChars[index + 1] = 93;
                ++i2;
            }
            name = CharOperation.concat(name, dimChars);
        }
        return new char[][]{name};
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding enclosingType, boolean checkBounds) {
        TypeVariableBinding[] typeVariables;
        this.constant = ASTNode.NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        if (enclosingType == null) {
            ReferenceBinding currentType;
            this.resolvedType = scope.getType(this.token);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            enclosingType = this.resolvedType.enclosingType();
            if (enclosingType != null && ((currentType = (ReferenceBinding)this.resolvedType).isStatic() || enclosingType.isGenericType() && enclosingType.outermostEnclosingType() != scope.outerMostClassScope().referenceContext.binding)) {
                enclosingType = (ReferenceBinding)scope.environment().convertToRawType(enclosingType);
            }
        } else {
            this.resolvedType = scope.getMemberType(this.token, (ReferenceBinding)enclosingType.erasure());
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, this.resolvedType, enclosingType);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().deprecatedType(this.resolvedType, this);
            }
        }
        boolean isClassScope = scope.kind == 3;
        TypeReference keep = null;
        if (isClassScope) {
            keep = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        ReferenceBinding currentType = (ReferenceBinding)this.resolvedType;
        int argLength = this.typeArguments.length;
        TypeBinding[] argTypes = new TypeBinding[argLength];
        boolean argHasError = false;
        int i = 0;
        while (i < argLength) {
            TypeBinding argType;
            TypeReference typeArgument = this.typeArguments[i];
            TypeBinding typeBinding = argType = isClassScope ? typeArgument.resolveTypeArgument((ClassScope)scope, currentType, i) : typeArgument.resolveTypeArgument((BlockScope)scope, currentType, i);
            if (argType == null) {
                argHasError = true;
            } else {
                argTypes[i] = argType;
            }
            ++i;
        }
        if (argHasError) {
            return null;
        }
        if (isClassScope) {
            ((ClassScope)scope).superTypeReference = keep;
            if (((ClassScope)scope).detectHierarchyCycle(currentType, this, argTypes)) {
                return null;
            }
        }
        if ((typeVariables = currentType.typeVariables()) == TypeConstants.NoTypeVariables) {
            scope.problemReporter().nonGenericTypeCannotBeParameterized(this, currentType, argTypes);
            return null;
        }
        if (argLength != typeVariables.length) {
            scope.problemReporter().incorrectArityForParameterizedType(this, currentType, argTypes);
            return null;
        }
        if (!currentType.isStatic() && enclosingType != null && enclosingType.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)currentType.erasure(), enclosingType), argTypes);
            return null;
        }
        boolean isIdentical = true;
        if (isIdentical) {
            int i2 = 0;
            while (i2 < argLength) {
                if (typeVariables[i2] != argTypes[i2]) {
                    isIdentical = false;
                    break;
                }
                ++i2;
            }
        }
        if (!isIdentical) {
            ParameterizedTypeBinding parameterizedType = scope.environment().createParameterizedType((ReferenceBinding)currentType.erasure(), argTypes, enclosingType);
            if (checkBounds) {
                parameterizedType.boundCheck(scope, this.typeArguments);
            }
            this.resolvedType = parameterizedType;
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(scope);
            }
        } else {
            this.resolvedType = this.resolvedType.erasure();
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append(this.token);
        output.append("<");
        int max = this.typeArguments.length - 1;
        int i = 0;
        while (i < max) {
            this.typeArguments[i].print(0, output);
            output.append(", ");
            ++i;
        }
        this.typeArguments[max].print(0, output);
        output.append(">");
        if ((this.bits & 0x4000) != 0) {
            i = 0;
            while (i < this.dimensions - 1) {
                output.append("[]");
                ++i;
            }
            output.append("...");
        } else {
            i = 0;
            while (i < this.dimensions) {
                output.append("[]");
                ++i;
            }
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        return this.internalResolveType(scope, null, checkBounds);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope scope, ReferenceBinding enclosingType) {
        return this.internalResolveType(scope, enclosingType, true);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                this.typeArguments[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                this.typeArguments[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

