/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IElementHandleProvider;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.HandleProviderDelimiter;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.CharOperation;
import org.aspectj.util.NameConvertor;

public class JDTLikeHandleProvider
implements IElementHandleProvider {
    private int initializerCounter = 0;
    private char[] empty = new char[0];
    private char[] countDelim = new char[]{HandleProviderDelimiter.COUNT.getDelimiter()};
    private String backslash = "\\";
    private String emptyString = "";

    public String createHandleIdentifier(IProgramElement ipe) {
        if (ipe == null || ipe.getKind().equals(IProgramElement.Kind.FILE_JAVA) && ipe.getName().equals("<root>")) {
            return "";
        }
        if (ipe.getHandleIdentifier(false) != null) {
            return ipe.getHandleIdentifier();
        }
        if (ipe.getKind().equals(IProgramElement.Kind.FILE_LST)) {
            String configFile = AsmManager.getDefault().getHierarchy().getConfigFile();
            int start = configFile.lastIndexOf(File.separator);
            int end = configFile.lastIndexOf(".lst");
            configFile = end != -1 ? configFile.substring(start + 1, end) : configFile.substring(start + 1);
            ipe.setHandleIdentifier(configFile);
            return configFile;
        }
        IProgramElement parent = ipe.getParent();
        if (parent != null && parent.getKind().equals(IProgramElement.Kind.IMPORT_REFERENCE)) {
            parent = ipe.getParent().getParent();
        }
        StringBuffer handle = new StringBuffer();
        handle.append(this.createHandleIdentifier(parent));
        handle.append(HandleProviderDelimiter.getDelimiter(ipe));
        if (!ipe.getKind().equals(IProgramElement.Kind.INITIALIZER)) {
            handle.append(ipe.getName() + this.getParameters(ipe));
        }
        handle.append(this.getCount(ipe));
        ipe.setHandleIdentifier(handle.toString());
        return handle.toString();
    }

    private String getParameters(IProgramElement ipe) {
        if (ipe.getParameterSignatures() == null || ipe.getParameterSignatures().isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        List parameterTypes = ipe.getParameterSignatures();
        Iterator iter = parameterTypes.iterator();
        while (iter.hasNext()) {
            char[] element = (char[])iter.next();
            sb.append(HandleProviderDelimiter.getDelimiter(ipe));
            if (element[0] == HandleProviderDelimiter.TYPE.getDelimiter()) {
                sb.append(HandleProviderDelimiter.ESCAPE.getDelimiter());
                sb.append(HandleProviderDelimiter.TYPE.getDelimiter());
                sb.append(NameConvertor.getTypeName(CharOperation.subarray(element, 1, element.length)));
                continue;
            }
            if (element[0] == 'P') {
                sb.append(NameConvertor.createShortName(element));
                continue;
            }
            sb.append(NameConvertor.getTypeName(element));
        }
        return sb.toString();
    }

    private char[] getCount(IProgramElement ipe) {
        char[] byteCodeName = ipe.getBytecodeName().toCharArray();
        if (ipe.getKind().isDeclare()) {
            int index = CharOperation.lastIndexOf('_', byteCodeName);
            if (index != -1) {
                return this.convertCount(CharOperation.subarray(byteCodeName, index + 1, byteCodeName.length));
            }
        } else if (ipe.getKind().equals(IProgramElement.Kind.ADVICE)) {
            char[] upToDollar;
            int secondToLastDollar;
            int lastDollar = CharOperation.lastIndexOf('$', byteCodeName);
            if (lastDollar != -1 && (secondToLastDollar = CharOperation.lastIndexOf('$', upToDollar = CharOperation.subarray(byteCodeName, 0, lastDollar))) != -1) {
                return this.convertCount(CharOperation.subarray(upToDollar, secondToLastDollar + 1, upToDollar.length));
            }
        } else {
            int index;
            if (ipe.getKind().equals(IProgramElement.Kind.INITIALIZER)) {
                return String.valueOf(++this.initializerCounter).toCharArray();
            }
            if (ipe.getKind().equals(IProgramElement.Kind.CODE) && (index = CharOperation.lastIndexOf('!', byteCodeName)) != -1) {
                return this.convertCount(CharOperation.subarray(byteCodeName, index + 1, byteCodeName.length));
            }
        }
        return this.empty;
    }

    private char[] convertCount(char[] c) {
        if (c.length == 1 && c[0] != ' ' && c[0] != '1' || c.length > 1) {
            return CharOperation.concat(this.countDelim, c);
        }
        return this.empty;
    }

    public String getFileForHandle(String handle) {
        IProgramElement node = AsmManager.getDefault().getHierarchy().getElement(handle);
        if (node != null) {
            return AsmManager.getDefault().getCanonicalFilePath(node.getSourceLocation().getSourceFile());
        }
        if (handle.charAt(0) == HandleProviderDelimiter.ASPECT_CU.getDelimiter() || handle.charAt(0) == HandleProviderDelimiter.COMPILATIONUNIT.getDelimiter()) {
            return this.backslash + handle.substring(1);
        }
        return this.emptyString;
    }

    public int getLineNumberForHandle(String handle) {
        IProgramElement node = AsmManager.getDefault().getHierarchy().getElement(handle);
        if (node != null) {
            return node.getSourceLocation().getLine();
        }
        if (handle.charAt(0) == HandleProviderDelimiter.ASPECT_CU.getDelimiter() || handle.charAt(0) == HandleProviderDelimiter.COMPILATIONUNIT.getDelimiter()) {
            return 1;
        }
        return -1;
    }

    public int getOffSetForHandle(String handle) {
        IProgramElement node = AsmManager.getDefault().getHierarchy().getElement(handle);
        if (node != null) {
            return node.getSourceLocation().getOffset();
        }
        if (handle.charAt(0) == HandleProviderDelimiter.ASPECT_CU.getDelimiter() || handle.charAt(0) == HandleProviderDelimiter.COMPILATIONUNIT.getDelimiter()) {
            return 0;
        }
        return -1;
    }

    public String createHandleIdentifier(ISourceLocation location) {
        IProgramElement node = AsmManager.getDefault().getHierarchy().findElementForSourceLine(location);
        if (node != null) {
            return this.createHandleIdentifier(node);
        }
        return null;
    }

    public String createHandleIdentifier(File sourceFile, int line, int column, int offset) {
        IProgramElement node = AsmManager.getDefault().getHierarchy().findElementForOffSet(sourceFile.getAbsolutePath(), line, offset);
        if (node != null) {
            return this.createHandleIdentifier(node);
        }
        return null;
    }

    public boolean dependsOnLocation() {
        return false;
    }

    public void initialize() {
        this.initializerCounter = 0;
    }
}

