/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.problem;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.TypePattern;

public class AjProblemReporter
extends ProblemReporter {
    private static final boolean DUMP_STACK = false;
    public EclipseFactory factory;

    public AjProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        if (!this.factory.getWorld().getDeclareSoft().isEmpty()) {
            Shadow callSite = this.factory.makeShadow(location, this.referenceContext);
            Shadow enclosingExec = this.factory.makeShadow(this.referenceContext);
            if (callSite == null && enclosingExec.getKind() == Shadow.ConstructorExecution && location instanceof ExplicitConstructorCall) {
                super.unhandledException(exceptionType, location);
                return;
            }
            Iterator i = this.factory.getWorld().getDeclareSoft().iterator();
            while (i.hasNext()) {
                FuzzyBoolean match;
                DeclareSoft d = (DeclareSoft)i.next();
                ResolvedType throwException = this.factory.fromEclipse((ReferenceBinding)exceptionType);
                FuzzyBoolean isExceptionTypeOrSubtype = d.getException().matchesInstanceof(throwException);
                if (!isExceptionTypeOrSubtype.alwaysTrue()) continue;
                if (callSite != null) {
                    match = d.getPointcut().match(callSite);
                    if (match.alwaysTrue()) {
                        return;
                    }
                    if (!match.alwaysFalse()) {
                        // empty if block
                    }
                }
                if (enclosingExec == null) continue;
                match = d.getPointcut().match(enclosingExec);
                if (match.alwaysTrue()) {
                    return;
                }
                if (match.alwaysFalse()) continue;
            }
        }
        if (location instanceof Proceed) {
            return;
        }
        super.unhandledException(exceptionType, location);
    }

    private boolean isPointcutDeclaration(MethodBinding binding) {
        return CharOperation.prefixEquals(PointcutDeclaration.mangledPrefix, binding.selector);
    }

    private boolean isIntertypeDeclaration(MethodBinding binding) {
        return binding instanceof InterTypeMethodBinding;
    }

    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        if (this.isPointcutDeclaration(concreteMethod)) {
            return;
        }
        super.abstractMethodCannotBeOverridden(type, concreteMethod);
    }

    public void inheritedMethodReducesVisibility(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        ResolvedType onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        Iterator i = onTypeX.getInterTypeMungersIncludingSupers().iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember sig = m.getSignature();
            if (Modifier.isAbstract(sig.getModifiers()) || !ResolvedType.matches((Member)AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)sig.getDeclaringType().resolve(this.factory.getWorld()).isInterface()), (Member)this.factory.makeResolvedMember(concreteMethod))) continue;
            return;
        }
        super.inheritedMethodReducesVisibility(type, concreteMethod, abstractMethods);
    }

    public void staticAndInstanceConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod instanceof InterTypeMethodBinding) {
            return;
        }
        if (inheritedMethod instanceof InterTypeMethodBinding) {
            return;
        }
        super.staticAndInstanceConflict(currentMethod, inheritedMethod);
    }

    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        if (this.isPointcutDeclaration(abstractMethod)) {
            return;
        }
        if (this.isIntertypeDeclaration(abstractMethod)) {
            return;
        }
        if (CharOperation.prefixEquals("ajc$interField".toCharArray(), abstractMethod.selector)) {
            return;
        }
        ResolvedType onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        if (onTypeX.isRawType()) {
            onTypeX = onTypeX.getGenericType();
        }
        Iterator i = onTypeX.getInterTypeMungersIncludingSupers().iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember sig = m.getSignature();
            if (sig == null || Modifier.isAbstract(sig.getModifiers())) continue;
            ResolvedMember abstractMember = this.factory.makeResolvedMember(abstractMethod);
            if (abstractMember.getName().startsWith("ajc$interMethodDispatch")) {
                ResolvedType dType = this.factory.getWorld().resolve(sig.getDeclaringType(), false);
                if (!ResolvedType.matches((Member)AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)dType.isInterface()), (Member)abstractMember)) continue;
                return;
            }
            if (!ResolvedType.matches((Member)sig, (Member)this.factory.makeResolvedMember(abstractMethod))) continue;
            return;
        }
        super.abstractMethodMustBeImplemented(type, abstractMethod);
    }

    public void disallowedTargetForAnnotation(Annotation annotation) {
        if (annotation.recipient instanceof MethodBinding) {
            MethodBinding binding = (MethodBinding)annotation.recipient;
            String name = new String(binding.selector);
            if (name.startsWith("ajc$")) {
                long metaTagBits = annotation.resolvedType.getAnnotationTagBits();
                if (name.indexOf("interField") != -1 ? (metaTagBits & 0x2000000000L) != 0L : (name.indexOf("interConstructor") != -1 ? (metaTagBits & 0x10000000000L) != 0L : (name.indexOf("interMethod") != -1 ? (metaTagBits & 0x4000000000L) != 0L : (name.indexOf("declare_" + DeclareAnnotation.AT_TYPE + "_") != -1 ? (metaTagBits & 0x40000000000L) != 0L || (metaTagBits & 0x1000000000L) != 0L : (name.indexOf("declare_" + DeclareAnnotation.AT_FIELD + "_") != -1 ? (metaTagBits & 0x2000000000L) != 0L : (name.indexOf("declare_" + DeclareAnnotation.AT_CONSTRUCTOR + "_") != -1 ? (metaTagBits & 0x10000000000L) != 0L : name.indexOf("declare_eow") != -1 && (metaTagBits & 0x2000000000L) != 0L)))))) {
                    return;
                }
            }
        }
        super.disallowedTargetForAnnotation(annotation);
    }

    public void overridesPackageDefaultMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        if (new String(localMethod.selector).startsWith("ajc$")) {
            return;
        }
        super.overridesPackageDefaultMethod(localMethod, inheritedMethod);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        if (severity != -1) {
            // empty if block
        }
        super.handle(problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }

    public void javadocMissingParamTag(char[] name, int sourceStart, int sourceEnd, int modifiers) {
        boolean reportIt = true;
        String sName = new String(name);
        if (sName.startsWith("ajc$")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPoint")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("thisEnclosingJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("ajc_aroundClosure")) {
            reportIt = false;
        }
        if (reportIt) {
            super.javadocMissingParamTag(name, sourceStart, sourceEnd, modifiers);
        }
    }

    public void abstractMethodInAbstractClass(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String abstractMethodName = new String(methodDecl.selector);
        if (abstractMethodName.startsWith("ajc$pointcut")) {
            return;
        }
        String[] arguments = new String[]{new String(type.sourceName()), abstractMethodName};
        super.handle(67109227, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    public void itdMethodMustOverride(AbstractMethodDeclaration method, MethodBinding binding) {
        this.handle(67109487, new String[]{new String(binding.selector), this.typesAsString(binding.isVarargs(), binding.parameters, false), new String(binding.declaringClass.readableName())}, new String[]{new String(binding.selector), this.typesAsString(binding.isVarargs(), binding.parameters, true), new String(binding.declaringClass.shortReadableName())}, method.sourceStart, method.sourceEnd, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    public void methodMustOverride(AbstractMethodDeclaration method) {
        MethodBinding binding = method.binding;
        if (new String(method.selector).startsWith("ajc$")) {
            return;
        }
        ResolvedMember possiblyErroneousRm = this.factory.makeResolvedMember(method.binding);
        ResolvedType onTypeX = this.factory.fromEclipse(method.binding.declaringClass);
        for (ResolvedType supertypeToLookAt = onTypeX.getSuperclass(); supertypeToLookAt != null; supertypeToLookAt = supertypeToLookAt.getSuperclass()) {
            List itMungers = supertypeToLookAt.getInterTypeMungers();
            Iterator i = itMungers.iterator();
            while (i.hasNext()) {
                UnresolvedType dType;
                ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
                ResolvedMember sig = m.getSignature();
                if (sig == null || (dType = sig.getDeclaringType()) == null) continue;
                ResolvedType resolvedDeclaringType = dType.resolve(this.factory.getWorld());
                ResolvedMember rm = AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)resolvedDeclaringType.isInterface());
                if (!ResolvedType.matches((Member)rm, (Member)possiblyErroneousRm)) continue;
                return;
            }
        }
        super.methodMustOverride(method);
    }

    private String typesAsString(boolean isVarargs, TypeBinding[] types, boolean makeShort) {
        StringBuffer buffer = new StringBuffer(10);
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            boolean isVarargType;
            if (i != 0) {
                buffer.append(", ");
            }
            TypeBinding type = types[i];
            boolean bl = isVarargType = isVarargs && i == length - 1;
            if (isVarargType) {
                type = ((ArrayBinding)type).elementsType();
            }
            buffer.append(new String(makeShort ? type.shortReadableName() : type.readableName()));
            if (!isVarargType) continue;
            buffer.append("...");
        }
        return buffer.toString();
    }

    public void visibilityConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (this.isIntertypeDeclaration(currentMethod) && this.isIntertypeDeclaration(inheritedMethod) && Modifier.isPrivate(currentMethod.modifiers) && Modifier.isPrivate(inheritedMethod.modifiers)) {
            return;
        }
        super.visibilityConflict(currentMethod, inheritedMethod);
    }

    public void unusedPrivateType(TypeDeclaration typeDecl) {
        if (typeDecl instanceof AspectDeclaration) {
            return;
        }
        if (typeDecl.enclosingType != null && typeDecl.enclosingType instanceof AspectDeclaration) {
            AspectDeclaration ad = (AspectDeclaration)typeDecl.enclosingType;
            if (ad.concreteName != null) {
                List declares = ad.concreteName.declares;
                Iterator iter = declares.iterator();
                while (iter.hasNext()) {
                    Object dec = iter.next();
                    if (!(dec instanceof DeclareParents)) continue;
                    DeclareParents decp = (DeclareParents)dec;
                    TypePattern[] newparents = decp.getParents().getTypePatterns();
                    for (int i = 0; i < newparents.length; ++i) {
                        TypePattern pattern = newparents[i];
                        UnresolvedType ut = pattern.getExactType();
                        if (ut == null || CharOperation.compareWith(typeDecl.binding.signature(), ut.getSignature().toCharArray()) != 0) continue;
                        return;
                    }
                }
            }
        }
        super.unusedPrivateType(typeDecl);
    }

    public void unusedPrivateMethod(AbstractMethodDeclaration methodDecl) {
        if (!(methodDecl instanceof PointcutDeclaration)) {
            super.unusedPrivateMethod(methodDecl);
        }
    }

    public void caseExpressionMustBeConstant(Expression expression) {
        if (expression instanceof QualifiedNameReference) {
            QualifiedNameReference qnr = (QualifiedNameReference)expression;
            if (qnr.otherBindings != null && qnr.otherBindings.length > 0 && qnr.otherBindings[0] instanceof PrivilegedFieldBinding) {
                super.signalError(expression.sourceStart, expression.sourceEnd, "Fields accessible due to an aspect being privileged can not be used in switch statements");
                this.referenceContext.tagAsHavingErrors();
                return;
            }
        }
        super.caseExpressionMustBeConstant(expression);
    }

    public void unusedArgument(LocalDeclaration localDecl) {
        String argType = new String(localDecl.type.resolvedType.signature());
        if (argType.startsWith("Lorg/aspectj/runtime/internal")) {
            return;
        }
        if (localDecl != null && localDecl instanceof Argument) {
            ReferenceContext context;
            Argument arg = (Argument)localDecl;
            if (arg.binding != null && arg.binding.declaringScope != null && (context = arg.binding.declaringScope.referenceContext()) != null && context instanceof PointcutDeclaration) {
                return;
            }
        }
        super.unusedArgument(localDecl);
    }

    public void finalMethodCannotBeOverridden(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod == inheritedMethod) {
            return;
        }
        super.finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
    }

    public void duplicateInheritedMethods(SourceTypeBinding type, MethodBinding inheritedMethod1, MethodBinding inheritedMethod2) {
        if (!(inheritedMethod1 instanceof InterTypeMethodBinding) || !(inheritedMethod2 instanceof InterTypeMethodBinding)) {
            super.duplicateInheritedMethods(type, inheritedMethod1, inheritedMethod2);
        }
    }

    public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber) {
        IProblem problem = super.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, 0);
        if (this.factory.getWorld().isInPinpointMode()) {
            MessageIssued ex = new MessageIssued();
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            StringBuffer sb = new StringBuffer();
            sb.append(CompilationAndWeavingContext.getCurrentContext());
            sb.append(sw.toString());
            problem = new PinpointedProblem(problem, sb.toString());
        }
        return problem;
    }

    public void duplicateMethodInType(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        if (new String(methodDecl.selector).startsWith("ajc$interMethod")) {
            return;
        }
        super.duplicateMethodInType(type, methodDecl);
    }

    private static class PinpointedProblem
    implements IProblem {
        private IProblem delegate;
        private String message;

        public PinpointedProblem(IProblem aProblem, String pinpoint) {
            this.delegate = aProblem;
            this.message = this.delegate.getMessage().indexOf("message issued...") == -1 ? this.delegate.getMessage() + "\n" + pinpoint : this.delegate.getMessage();
        }

        public String[] getArguments() {
            return this.delegate.getArguments();
        }

        public int getID() {
            return this.delegate.getID();
        }

        public String getMessage() {
            return this.message;
        }

        public char[] getOriginatingFileName() {
            return this.delegate.getOriginatingFileName();
        }

        public int getSourceEnd() {
            return this.delegate.getSourceEnd();
        }

        public int getSourceLineNumber() {
            return this.delegate.getSourceLineNumber();
        }

        public int getSourceStart() {
            return this.delegate.getSourceStart();
        }

        public boolean isError() {
            return this.delegate.isError();
        }

        public boolean isWarning() {
            return this.delegate.isWarning();
        }

        public void setSourceEnd(int sourceEnd) {
            this.delegate.setSourceEnd(sourceEnd);
        }

        public void setSourceLineNumber(int lineNumber) {
            this.delegate.setSourceLineNumber(lineNumber);
        }

        public void setSourceStart(int sourceStart) {
            this.delegate.setSourceStart(sourceStart);
        }

        public void setSeeAlsoProblems(IProblem[] problems) {
            this.delegate.setSeeAlsoProblems(problems);
        }

        public IProblem[] seeAlso() {
            return this.delegate.seeAlso();
        }

        public void setSupplementaryMessageInfo(String msg) {
            this.delegate.setSupplementaryMessageInfo(msg);
        }

        public String getSupplementaryMessageInfo() {
            return this.delegate.getSupplementaryMessageInfo();
        }
    }

    private static class MessageIssued
    extends RuntimeException {
        private MessageIssued() {
        }

        public String getMessage() {
            return "message issued...";
        }
    }
}

