/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJarEntryResource;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.aspectj.org.eclipse.jdt.internal.core.JarEntryFile;
import org.aspectj.org.eclipse.jdt.internal.core.JarEntryResource;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.Openable;
import org.aspectj.org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class JarPackageFragment
extends PackageFragment
implements SuffixConstants {
    protected JarPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    protected boolean computeChildren(OpenableElementInfo info, ArrayList entryNames) {
        if (entryNames != null && entryNames.size() > 0) {
            ArrayList<IClassFile> vChildren = new ArrayList<IClassFile>();
            Iterator iter = entryNames.iterator();
            while (iter.hasNext()) {
                String child = (String)iter.next();
                IClassFile classFile = this.getClassFile(child);
                vChildren.add(classFile);
            }
            IJavaElement[] children = new IJavaElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(JavaElement.NO_ELEMENTS);
        }
        return true;
    }

    void computeNonJavaResources(String[] resNames, JarPackageFragment pkg, JarPackageFragmentInfo info, String zipName) {
        if (resNames == null) {
            info.setNonJavaResources(null);
            return;
        }
        int max = resNames.length;
        if (max == 0) {
            info.setNonJavaResources(JavaElementInfo.NO_NON_JAVA_RESOURCES);
        } else {
            HashMap<IPath, JarEntryResource> jarEntries = new HashMap<IPath, JarEntryResource>();
            HashMap<IPath, ArrayList<IPath>> childrenMap = new HashMap<IPath, ArrayList<IPath>>();
            ArrayList<JarEntryResource> topJarEntries = new ArrayList<JarEntryResource>();
            int i = 0;
            while (i < max) {
                String resName = resNames[i];
                if (!Util.isJavaLikeFileName(resName)) {
                    Path filePath = new Path(resName);
                    IPath childPath = filePath.removeFirstSegments(this.names.length);
                    JarEntryFile file = new JarEntryFile(filePath.lastSegment());
                    jarEntries.put(childPath, file);
                    if (childPath.segmentCount() == 1) {
                        file.setParent(pkg);
                        topJarEntries.add(file);
                    } else {
                        IPath parentPath = childPath.removeLastSegments(1);
                        while (parentPath.segmentCount() > 0) {
                            ArrayList<IPath> parentChildren = (ArrayList<IPath>)childrenMap.get(parentPath);
                            if (parentChildren == null) {
                                JarEntryDirectory dir = new JarEntryDirectory(parentPath.lastSegment());
                                jarEntries.put(parentPath, dir);
                                parentChildren = new ArrayList<IPath>();
                                childrenMap.put(parentPath, parentChildren);
                                parentChildren.add(childPath);
                                if (parentPath.segmentCount() == 1) {
                                    topJarEntries.add(dir);
                                    break;
                                }
                                childPath = parentPath;
                                parentPath = childPath.removeLastSegments(1);
                                continue;
                            }
                            parentChildren.add(childPath);
                            break;
                        }
                    }
                }
                ++i;
            }
            Iterator entries = childrenMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                IPath entryPath = (IPath)entry.getKey();
                ArrayList entryValue = (ArrayList)entry.getValue();
                JarEntryDirectory jarEntryDirectory = (JarEntryDirectory)jarEntries.get(entryPath);
                int size = entryValue.size();
                IJarEntryResource[] children = new IJarEntryResource[size];
                int i2 = 0;
                while (i2 < size) {
                    JarEntryResource child = (JarEntryResource)jarEntries.get(entryValue.get(i2));
                    child.setParent(jarEntryDirectory);
                    children[i2] = child;
                    ++i2;
                }
                jarEntryDirectory.setChildren(children);
                if (entryPath.segmentCount() != 1) continue;
                jarEntryDirectory.setParent(pkg);
            }
            Object[] res = topJarEntries.toArray(new Object[topJarEntries.size()]);
            info.setNonJavaResources(res);
        }
    }

    public boolean containsJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public ICompilationUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    protected Object createElementInfo() {
        return null;
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public ICompilationUnit[] getCompilationUnits() {
        return PackageFragment.NO_COMPILATION_UNITS;
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }
}

