/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.PaletteDefinition;
import org.eclipse.contribution.visualiser.core.PaletteManager;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.RendererDefinition;
import org.eclipse.contribution.visualiser.core.RendererManager;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserPalette;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserRenderer;
import org.eclipse.contribution.visualiser.internal.preference.TabFolderLayout;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.palettes.PatternVisualiserPalette;
import org.eclipse.contribution.visualiser.renderers.PatternVisualiserRenderer;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMember;
import org.eclipse.contribution.visualiser.text.VisualiserMessages;
import org.eclipse.contribution.visualiser.utils.ColorConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class VisualiserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;
    private org.eclipse.swt.widgets.List styleList;
    private org.eclipse.swt.widgets.List colourList;
    private Scale prefWidth;
    private Scale stripeHeight;
    private VisualiserPreview preview;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Control providerControl = this.createProviderControl(folder);
        Control drawingOptionsControl = this.createDrawingOptionsControl(folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(VisualiserMessages.VisualiserPreferencePage_providers);
        item.setControl(providerControl);
        item = new TabItem(folder, 0);
        item.setText(VisualiserMessages.VisualiserPreferencePage_drawingOptions);
        item.setControl(drawingOptionsControl);
        this.populateProviders();
        return composite;
    }

    private Control createDrawingOptionsControl(TabFolder parent) {
        GridLayout layout = new GridLayout();
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)layout);
        this.createDrawingStyleArea(composite);
        return composite;
    }

    private Control createProviderControl(TabFolder parent) {
        GridLayout layout = new GridLayout();
        Composite composite = new Composite((Composite)parent, 0);
        composite.setLayout((Layout)layout);
        this.createProvidersArea(composite);
        this.createDescriptionArea(composite);
        return composite;
    }

    private void createDrawingStyleArea(Composite mainComposite) {
        List renderers = RendererManager.getAllRendererDefinitions();
        ArrayList<String> rnames = new ArrayList<String>();
        Iterator iter = renderers.iterator();
        while (iter.hasNext()) {
            RendererDefinition rd = (RendererDefinition)iter.next();
            rnames.add(rd.getName());
        }
        List palettes = PaletteManager.getAllPaletteDefinitions();
        ArrayList<String> pnames = new ArrayList<String>();
        Iterator iter2 = palettes.iterator();
        while (iter2.hasNext()) {
            PaletteDefinition rd = (PaletteDefinition)iter2.next();
            pnames.add(rd.getName());
        }
        Composite drawingComposite = new Composite(mainComposite, 0);
        drawingComposite.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(784);
        drawingComposite.setLayoutData((Object)gd);
        Group styleGroup = new Group(drawingComposite, 0);
        styleGroup.setLayout((Layout)new GridLayout());
        styleGroup.setLayoutData((Object)new GridData(784));
        styleGroup.setText(VisualiserMessages.VisualiserPreferencePage_drawingStyle);
        this.styleList = new org.eclipse.swt.widgets.List((Composite)styleGroup, 2820);
        gd = new GridData(784);
        gd.heightHint = 65;
        this.styleList.setLayoutData((Object)gd);
        this.styleList.setItems(rnames.toArray(new String[0]));
        String rname = VisualiserPreferences.getRendererName();
        if (rname == null || rname.length() == 0) {
            rname = RendererManager.getDefaultRenderer().getName();
        }
        Group colourGroup = new Group(drawingComposite, 0);
        colourGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(784);
        colourGroup.setLayoutData((Object)gd);
        colourGroup.setText(VisualiserMessages.VisualiserPreferencePage_colorSet);
        this.colourList = new org.eclipse.swt.widgets.List((Composite)colourGroup, 2820);
        gd = new GridData(784);
        gd.heightHint = 65;
        this.colourList.setLayoutData((Object)gd);
        this.colourList.setItems(pnames.toArray(new String[0]));
        String pname = PaletteManager.getCurrentPalette().getName();
        Group stripeHGroup = new Group(drawingComposite, 0);
        stripeHGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(784);
        stripeHGroup.setLayoutData((Object)gd);
        stripeHGroup.setText(VisualiserMessages.VisualiserPreferencePage_stripeHeight);
        this.stripeHeight = new Scale((Composite)stripeHGroup, 256);
        this.stripeHeight.setMinimum(1);
        this.stripeHeight.setMaximum(20);
        this.stripeHeight.setIncrement(1);
        this.stripeHeight.setSelection(VisualiserPreferences.getStripeHeight());
        gd = new GridData(768);
        this.stripeHeight.setLayoutData((Object)gd);
        Group prefWidthGroup = new Group(drawingComposite, 0);
        prefWidthGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(784);
        prefWidthGroup.setLayoutData((Object)gd);
        prefWidthGroup.setText(VisualiserMessages.VisualiserPreferencePage_colWidth);
        this.prefWidth = new Scale((Composite)prefWidthGroup, 256);
        this.prefWidth.setMinimum(VisualiserPreferences.getMinBarSize());
        this.prefWidth.setMaximum(120);
        this.prefWidth.setIncrement(5);
        this.prefWidth.setSelection(VisualiserPreferences.getBarWidth());
        gd = new GridData(768);
        this.prefWidth.setLayoutData((Object)gd);
        Group canvasGroup = new Group(drawingComposite, 0);
        canvasGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(784);
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        canvasGroup.setLayoutData((Object)gd);
        canvasGroup.setText(VisualiserMessages.VisualiserPreferencePage_preview);
        this.preview = new VisualiserPreview((Composite)canvasGroup);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.preview.setLayoutData(gd);
        this.styleList.setSelection(new String[]{rname});
        this.styleList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualiserPreferencePage.this.preview.redraw();
            }
        });
        this.colourList.setSelection(new String[]{pname});
        this.colourList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pname = VisualiserPreferencePage.this.colourList.getSelection()[0];
                if (PaletteManager.getPaletteByName(pname).getPalette() instanceof PatternVisualiserPalette) {
                    VisualiserPreferencePage.this.preview.localUsePatterns = true;
                } else {
                    VisualiserPreferencePage.this.preview.localUsePatterns = false;
                }
                VisualiserPreferencePage.this.preview.redraw();
            }
        });
        this.stripeHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualiserPreferencePage.this.preview.redraw();
            }
        });
        this.prefWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualiserPreferencePage.this.preview.redraw();
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.preview != null) {
            this.preview.dispose();
        }
    }

    private void createProvidersArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite providersComposite = new Composite(mainComposite, 0);
        providersComposite.setLayoutData((Object)new GridData(1808));
        GridLayout providersLayout = new GridLayout();
        providersLayout.marginWidth = 0;
        providersLayout.marginHeight = 0;
        providersComposite.setLayout((Layout)providersLayout);
        providersComposite.setFont(mainFont);
        Label providersLabel = new Label(providersComposite, 0);
        providersLabel.setText(VisualiserMessages.VisualiserPreferencePage_providersLabel);
        providersLabel.setFont(mainFont);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)providersComposite, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(providersComposite.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProviderDefinition)element).getName();
            }
        });
        this.checkboxViewer.getTable().setFont(mainFont);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ProviderDefinition definition = (ProviderDefinition)sel.getFirstElement();
                    if (definition == null) {
                        VisualiserPreferencePage.this.clearDescription();
                    } else {
                        VisualiserPreferencePage.this.showDescription(definition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                VisualiserPreferencePage.this.checkboxViewer.setAllChecked(false);
                VisualiserPreferencePage.this.checkboxViewer.setChecked(event.getElement(), true);
                VisualiserPreferencePage.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(event.getElement()), true);
                ProviderDefinition definition = (ProviderDefinition)event.getElement();
                String pid = VisualiserPreferences.getPaletteIDForProvider(definition.getID());
                String pname = null;
                if (pid != null && pid.length() > 0) {
                    pname = PaletteManager.getPaletteByID(pid).getName();
                }
                if (pname == null || pname.length() == 0) {
                    pname = PaletteManager.getDefaultForProvider(definition).getName();
                }
                VisualiserPreferencePage.this.colourList.setSelection(new String[]{pname});
            }
        });
    }

    private void createDescriptionArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        textComposite.setFont(mainFont);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(VisualiserMessages.VisualiserPreferencePage_description);
        descriptionLabel.setFont(mainFont);
        this.descriptionText = new Text(textComposite, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(mainFont);
    }

    private void populateProviders() {
        ProviderDefinition[] definitions = this.getAllDefinitions();
        this.checkboxViewer.setInput((Object)definitions);
        int i = 0;
        while (i < definitions.length) {
            this.checkboxViewer.setChecked((Object)definitions[i], definitions[i].isEnabled());
            if (definitions[i].isEnabled()) {
                this.showDescription(definitions[i]);
            }
            ++i;
        }
    }

    private void showDescription(ProviderDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(VisualiserMessages.VisualiserPreferencePage_noDescription);
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        super.performDefaults();
        this.stripeHeight.setSelection(VisualiserPreferences.getDefaultStripeHeight());
        this.prefWidth.setSelection(VisualiserPreferences.getDefaultBarWidth());
        String rname = RendererManager.getDefaultRenderer().getName();
        this.styleList.setSelection(this.styleList.indexOf(rname));
        ProviderDefinition def = (ProviderDefinition)this.checkboxViewer.getCheckedElements()[0];
        String pname = PaletteManager.getDefaultForProvider(def).getName();
        this.colourList.setSelection(this.colourList.indexOf(pname));
        this.preview.redraw();
    }

    public boolean performOk() {
        if (super.performOk()) {
            String pid;
            ProviderDefinition[] definitions = ProviderManager.getAllProviderDefinitions();
            int i = 0;
            while (i < definitions.length) {
                boolean checked = this.checkboxViewer.getChecked((Object)definitions[i]);
                if (definitions[i].isEnabled() != checked) {
                    definitions[i].setEnabled(checked);
                }
                ++i;
            }
            String rname = this.styleList.getSelection()[0];
            VisualiserPreferences.setRendererName(rname);
            String pname = this.colourList.getSelection()[0];
            ProviderDefinition def = ProviderManager.getCurrent();
            String defp = PaletteManager.getDefaultForProvider(def).getName();
            if (PaletteManager.getPaletteByName(pname).getPalette() instanceof PatternVisualiserPalette) {
                if (this.stripeHeight.getSelection() < VisualiserPreferences.getDefaultPatternStripeHeight() && !VisualiserPreferences.getUsePatterns() && !VisualiserPreferences.getDontAutoIncreaseStripeHeight()) {
                    if (VisualiserPreferences.getDoAutoIncreaseStripeHeight()) {
                        VisualiserPreferences.setStripeHeight(VisualiserPreferences.getDefaultPatternStripeHeight());
                    } else {
                        MessageDialogWithToggle toggleDialog = new MessageDialogWithToggle(null, VisualiserMessages.VisualiserPreferencePage_stripeSizeDialog_title, null, VisualiserMessages.VisualiserPreferencePage_stripeSizeDialog_message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, VisualiserMessages.VisualiserPreferencePage_stripeSizeDialog_togglemessage, VisualiserPreferences.getDoAutoIncreaseStripeHeight());
                        if (toggleDialog.getReturnCode() == 0) {
                            VisualiserPreferences.setDoIncreaseStripeHeight(toggleDialog.getToggleState());
                            VisualiserPreferences.setStripeHeight(VisualiserPreferences.getDefaultPatternStripeHeight());
                        } else {
                            VisualiserPreferences.setDontIncreaseStripeHeight(toggleDialog.getToggleState());
                        }
                    }
                } else {
                    VisualiserPreferences.setStripeHeight(this.stripeHeight.getSelection());
                }
                VisualiserPreferences.setBarWidth(this.prefWidth.getSelection());
                VisualiserPreferences.setUsePatterns(true);
                pid = PaletteManager.getPaletteByName(pname).getID();
                VisualiserPreferences.setPaletteIDForProvider(def, pid);
            } else {
                VisualiserPreferences.setStripeHeight(this.stripeHeight.getSelection());
                VisualiserPreferences.setBarWidth(this.prefWidth.getSelection());
                VisualiserPreferences.setUsePatterns(false);
                if (defp.equals(pname)) {
                    VisualiserPreferences.setPaletteIDForProvider(def, "");
                } else {
                    pid = PaletteManager.getPaletteByName(pname).getID();
                    VisualiserPreferences.setPaletteIDForProvider(def, pid);
                }
            }
            PaletteManager.resetCurrent();
            IMarkupProvider markupP = ProviderManager.getMarkupProvider();
            if (markupP instanceof SimpleMarkupProvider) {
                ((SimpleMarkupProvider)markupP).resetColours();
            }
            if (VisualiserPlugin.visualiser != null) {
                if (VisualiserPlugin.menu != null) {
                    VisualiserPlugin.menu.setVisMarkupProvider(markupP);
                }
                VisualiserPlugin.visualiser.updateDisplay(true);
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }

    private ProviderDefinition[] getAllDefinitions() {
        return ProviderManager.getAllProviderDefinitions();
    }

    class VisualiserPreview
    extends Canvas {
        private SimpleMember m = new SimpleMember(VisualiserMessages.VisualiserPreferencePage_preview_col1);
        private SimpleMember m2 = new SimpleMember(VisualiserMessages.VisualiserPreferencePage_preview_col2);
        private IVisualiserPalette ivp;
        private Color[] cols;
        private RGB[] colsForPatterns;
        private boolean localUsePatterns = VisualiserPreferences.getUsePatterns();

        VisualiserPreview(Composite parent) {
            super(parent, 262144);
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ VisualiserPreview this$1;
                {
                    this.this$1 = visualiserPreview;
                }

                public void paintControl(PaintEvent e) {
                    VisualiserPreview.access$0(this.this$1, e.gc);
                }
            });
            this.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ VisualiserPreview this$1;
                {
                    this.this$1 = visualiserPreview;
                }

                public void focusGained(FocusEvent e) {
                    this.this$1.redraw();
                }

                public void focusLost(FocusEvent e) {
                    this.this$1.redraw();
                }
            });
            this.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ VisualiserPreview this$1;
                {
                    this.this$1 = visualiserPreview;
                }
            });
            this.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ VisualiserPreview this$1;
                {
                    this.this$1 = visualiserPreview;
                }

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 256: 
                        case 512: {
                            e.doit = true;
                        }
                    }
                }
            });
            this.setToolTipText(VisualiserMessages.VisualiserPreferencePage_preview);
        }

        private void paint(GC gc) {
            String rname = VisualiserPreferencePage.this.styleList.getSelection()[0];
            RendererDefinition rd = RendererManager.getRendererByName(rname);
            String pname = VisualiserPreferencePage.this.colourList.getSelection()[0];
            PaletteDefinition pd = PaletteManager.getPaletteByName(pname);
            if (rd != null && pd != null) {
                Rectangle clientRect = this.getClientArea();
                Image buffer = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
                GC sgc = new GC((Drawable)buffer);
                sgc.setBackground(ColorConstants.menuBackground);
                sgc.fillRectangle(clientRect);
                IVisualiserRenderer r = rd.getRenderer();
                int x = r.getMarginSize();
                int y = r.getColumnHeaderHeight() + r.getMarginSize();
                int width = VisualiserPreferencePage.this.prefWidth.getSelection();
                int height = 70;
                r.paintColumnHeader(sgc, this.m, x, width);
                r.paintColumn(sgc, this.m, x, y, width, height, true);
                if (pd.getPalette() != this.ivp) {
                    this.disposeCols();
                }
                if (this.cols == null) {
                    RGB[] rgb = pd.getPalette().getRGBValues();
                    this.colsForPatterns = new RGB[]{rgb[0], rgb[1], rgb[2], rgb[3]};
                    this.cols = new Color[]{new Color((Device)Display.getDefault(), rgb[0]), new Color((Device)Display.getDefault(), rgb[1]), new Color((Device)Display.getDefault(), rgb[2]), new Color((Device)Display.getDefault(), rgb[3])};
                }
                int h = VisualiserPreferencePage.this.stripeHeight.getSelection();
                if (this.localUsePatterns) {
                    PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(sgc, this.colsForPatterns[0]);
                } else {
                    sgc.setBackground(this.cols[0]);
                }
                sgc.fillRectangle(x + 1, y + 10, width - 1, h);
                if (this.localUsePatterns) {
                    PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(sgc, this.colsForPatterns[1]);
                } else {
                    sgc.setBackground(this.cols[1]);
                }
                sgc.fillRectangle(x + 1, y + 32, width / 2 - 1, h);
                if (this.localUsePatterns) {
                    PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(sgc, this.colsForPatterns[2]);
                } else {
                    sgc.setBackground(this.cols[2]);
                }
                sgc.fillRectangle(x + 1 + width / 2, y + 32, width / 2 - 1, h);
                if (this.localUsePatterns) {
                    PatternVisualiserRenderer.getPatternRenderer().setDitherPattern(sgc, this.colsForPatterns[3]);
                } else {
                    sgc.setBackground(this.cols[3]);
                }
                int sy = y + 54;
                if (h > y + height - sy) {
                    h = y + height - sy;
                }
                sgc.fillRectangle(x + 1, sy, width - 1, h);
                r.paintColumnHeader(sgc, this.m2, x += r.getSpacing() + width, width);
                r.paintColumn(sgc, this.m2, x, y, width, height, false);
                if (this.isFocusControl()) {
                    sgc.setForeground(ColorConstants.menuForeground);
                    sgc.setBackground(ColorConstants.menuBackground);
                    sgc.drawFocus(clientRect.x, clientRect.y, clientRect.width, clientRect.height);
                }
                gc.drawImage(buffer, 0, 0);
                sgc.dispose();
                buffer.dispose();
            }
        }

        private void disposeCols() {
            if (this.cols != null) {
                int i = 0;
                while (i < this.cols.length) {
                    this.cols[i].dispose();
                    ++i;
                }
                this.cols = null;
            }
        }

        public void dispose() {
            super.dispose();
            this.disposeCols();
        }

        public boolean getLocalUsePatterns() {
            return this.localUsePatterns;
        }

        static /* synthetic */ void access$0(VisualiserPreview visualiserPreview, GC gC) {
            visualiserPreview.paint(gC);
        }
    }
}

