/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.net.MalformedURLException;
import java.net.URL;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AJDTErrorDialog
extends IconAndMessageDialog {
    public static boolean AUTOMATED_MODE = false;
    private static final int LIST_ITEM_COUNT = 9;
    private Button detailsButton;
    private String title;
    private Text list;
    private boolean listCreated = false;
    private Clipboard clipboard;
    private String longMessage;
    protected Link messageLabel;

    public AJDTErrorDialog(Shell parentShell, String dialogTitle, String shortMessage, String longMessage) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = shortMessage;
        this.longMessage = longMessage;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            this.imageLabel.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            this.messageLabel = new Link(composite, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            this.messageLabel.addListener(13, new Listener(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

                public void handleEvent(Event event) {
                    try {
                        URL url = new URL(event.text);
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                    }
                    catch (MalformedURLException malformedURLException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(malformedURLException, this, ajc$tjp_0, ajc$tjp_1);
                    }
                    catch (PartInitException partInitException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(partInitException, this, ajc$tjp_2, ajc$tjp_1);
                    }
                }

                static {
                    Factory factory = new Factory("AJDTErrorDialog.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog$1"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog$1-java.net.MalformedURLException-<missing>-"), 197);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-handleEvent-org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog$1-org.eclipse.swt.widgets.Event:-event:--void-"), 193);
                    ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog$1-org.eclipse.ui.PartInitException-<missing>-"), 198);
                }
            });
            GridData data = new GridData(770);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            this.messageLabel.setLayoutData((Object)data);
        }
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        return this.getErrorImage();
    }

    protected Text createDropDownList(Composite parent) {
        this.list = new Text(parent, 2818);
        this.list.setEditable(false);
        this.populateList(this.list);
        GridData data = new GridData(1808);
        data.heightHint = this.list.getLineHeight() * 9;
        data.horizontalSpan = 2;
        this.list.setLayoutData((Object)data);
        this.list.setFont(parent.getFont());
        Menu copyMenu = new Menu((Control)this.list);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AJDTErrorDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AJDTErrorDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.list.setMenu(copyMenu);
        this.listCreated = true;
        return this.list;
    }

    public int open() {
        if (!AUTOMATED_MODE) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell parent, String dialogTitle, String message, String longMessage) {
        AJDTErrorDialog dialog = new AJDTErrorDialog(parent, dialogTitle, message, longMessage);
        return dialog.open();
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.listCreated) {
            this.list.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.list = this.createDropDownList((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    private void populateList(Text list) {
        list.setText(this.longMessage);
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = new Clipboard(this.list.getDisplay());
        this.clipboard.setContents(new Object[]{this.longMessage}, new Transfer[]{TextTransfer.getInstance()});
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return true;
    }
}

