/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.IAJLogger;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.builder.UIBuildListener;
import org.eclipse.ajdt.internal.core.ajde.ICompilerFactory;
import org.eclipse.ajdt.internal.javamodel.ResourceChangeListener;
import org.eclipse.ajdt.internal.ui.ajde.UICompilerFactory;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.tracing.EventTraceLogger;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class AspectJUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_OUTLINE = "org.eclipse.ajdt.ui.ajoutlineview";
    private static final String AJDE_VERSION_KEY_PREVIOUS = "ajde.version.at.previous.startup";
    public static final String VISUALISER_ID = "org.eclipse.contribution.visualiser";
    private static final String XREF_CORE_ID = "org.eclipse.contribution.xref.core";
    private static final String XREF_UI_ID = "org.eclipse.contribution.xref.ui";
    public static boolean usingVisualiser;
    public static boolean usingXref;
    private static AspectJUIPlugin plugin;
    private AspectJTextTools aspectJTextTools;
    private Display display;
    public static final String SOURCE_LOCATION_ATTRIBUTE = "sourceLocationOfAdvice";
    public static final String RELATED_LOCATIONS_ATTRIBUTE_PREFIX = "relatedLocations-";
    public static final String ACCKIND_ATTRIBUTE = "acckind";
    public static final int PROGRESS_MONITOR_MAX = 100;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("AspectJUIPlugin.java", Class.forName("org.eclipse.ajdt.ui.AspectJUIPlugin"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-java.io.IOException-<missing>-"), 258);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkTemplatesInstalled-org.eclipse.ajdt.ui.AspectJUIPlugin----void-"), 236);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.jdt.core.JavaModelException-<missing>-"), 396);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-addAjrtToBuildPath-org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.core.resources.IProject:-project:--void-"), 384);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.jdt.core.JavaModelException-<missing>-"), 439);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-removeAjrtFromBuildPath-org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.core.resources.IProject:-project:--void-"), 406);
        usingVisualiser = true;
        usingXref = true;
    }

    public static AspectJUIPlugin getDefault() {
        return plugin;
    }

    public static void convertToAspectJProject(IProject project) throws CoreException {
        AJDTUtils.addAspectJNature(project, false);
    }

    public static void convertFromAspectJProject(IProject project) throws CoreException {
        AJDTUtils.removeAspectJNature(project);
    }

    public AspectJUIPlugin() {
        plugin = this;
    }

    private void checkAspectJVersion() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String currentAjdeVersion = UIMessages.ajde_version;
        String previousAjdeVersion = store.getString(AJDE_VERSION_KEY_PREVIOUS);
        if (previousAjdeVersion == null || !currentAjdeVersion.equals(previousAjdeVersion)) {
            AJLog.log((String)("New version of AJDE detected (now:" + currentAjdeVersion + ") - checking aspectjrt.jar for each project."));
            IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject current;
                if (projects[i].isOpen() && AspectJPlugin.isAJProject((IProject)(current = projects[i]))) {
                    AJDTUtils.verifyAjrtVersion(current);
                }
                ++i;
            }
            this.checkTemplatesInstalled();
            this.checkProblemMarkersVisible();
            store.putValue(AJDE_VERSION_KEY_PREVIOUS, currentAjdeVersion);
        }
    }

    private void checkProblemMarkersVisible() {
        String enabledMarkers;
        IDialogSettings filterSettings;
        String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
        String problemMarker = "org.eclipse.ajdt.ui.problemmarker:";
        UIPlugin plugin = UIPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null && (filterSettings = settings.getSection("filter")) != null && (enabledMarkers = filterSettings.get("selectedType")) != null && enabledMarkers.indexOf(problemMarker) == -1) {
            enabledMarkers = String.valueOf(enabledMarkers) + problemMarker;
            filterSettings.put("selectedType", enabledMarkers);
        }
    }

    private void checkTemplatesInstalled() {
        TemplateStore codeTemplates = JavaPlugin.getDefault().getTemplateStore();
        if (codeTemplates.findTemplate("pertypewithin") == null) {
            try {
                URL loc = this.getBundle().getEntry("/aspectj_code_templates.xml");
                TemplateReaderWriter trw = new TemplateReaderWriter();
                TemplatePersistenceData[] templates = trw.read(loc.openStream(), null);
                if (templates == null || templates.length == 0) {
                    AJLog.log((String)UIMessages.codeTemplates_couldNotLoad);
                } else {
                    int i = 0;
                    while (i < templates.length) {
                        if (codeTemplates.findTemplate(templates[i].getTemplate().getName()) == null) {
                            codeTemplates.add(templates[i]);
                        }
                        ++i;
                    }
                    codeTemplates.save();
                }
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                AJLog.log((String)UIMessages.codeTemplates_couldNotLoad);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        AJBuilder.addAJBuildListener((IAJBuildListener)new UIBuildListener());
        this.display = Display.getDefault();
        if (!AspectJPlugin.usingCUprovider) {
            AspectJPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 15);
        }
        AspectJPlugin.getDefault().setAJLogger((IAJLogger)new EventTraceLogger());
        this.setCompilerFactory(new UICompilerFactory());
        this.checkEclipseVersion();
        if (Platform.getBundle((String)VISUALISER_ID) == null) {
            usingVisualiser = false;
        }
        if (Platform.getBundle((String)XREF_CORE_ID) == null || Platform.getBundle((String)XREF_UI_ID) == null) {
            usingXref = false;
        }
        this.checkAspectJVersion();
        if (!AspectJPlugin.usingCUprovider) {
            AJCompilationUnitManager.INSTANCE.initCompilationUnits(AspectJPlugin.getWorkspace());
            AJDTUtils.refreshPackageExplorer();
        }
    }

    private void checkEclipseVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        String versionStr = (String)bundle.getHeaders().get("Bundle-Version");
        Version version = new Version(versionStr);
        if (version.getMajor() != 3 || version.getMinor() != 3) {
            MessageDialog.openError(null, (String)UIMessages.ajdtErrorDialogTitle, (String)NLS.bind((String)UIMessages.wrong_eclipse_version, (Object[])new String[]{"3.3", String.valueOf(version.getMajor()) + "." + version.getMinor()}));
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return plugin.getWorkbench().getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        return this.display;
    }

    public AspectJTextTools getAspectJTextTools() {
        if (this.aspectJTextTools == null) {
            IPreferenceStore textToolPreferences = JavaPlugin.getDefault().getPreferenceStore();
            this.aspectJTextTools = new AspectJTextTools(textToolPreferences);
        }
        return this.aspectJTextTools;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        AspectJPreferences.initDefaults(store);
        AJCompilerPreferencePage.initDefaults(store);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    public static void addAjrtToBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            IClasspathEntry ajrtLIB = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.ajdt.core.ASPECTJRT_CONTAINER"), (boolean)false);
            int originalCPLength = originalCP.length;
            IClasspathEntry[] newCP = new IClasspathEntry[originalCPLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCPLength);
            newCP[originalCPLength] = ajrtLIB;
            javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_2, ajc$tjp_3);
        }
    }

    public static void removeAjrtFromBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                boolean keep = true;
                if (path.toOSString().endsWith("ASPECTJRT_LIB") || path.toOSString().endsWith("aspectjrt.jar")) {
                    keep = false;
                }
                if (originalCP[i].getEntryKind() == 5 && path.segment(0).equals("org.eclipse.ajdt.core.ASPECTJRT_CONTAINER")) {
                    keep = false;
                }
                if (keep) {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (originalCP.length != tempCP.size()) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public ICompilerFactory getCompilerFactory() {
        return AspectJPlugin.getDefault().getCompilerFactory();
    }

    public void setCompilerFactory(ICompilerFactory compilerFactory) {
        AspectJPlugin.getDefault().setCompilerFactory(compilerFactory);
    }
}

