/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.UnresolvedType;

public class AnnotationAJ {
    private String type;
    private boolean isRuntimeVisible;
    private List nvPairs = null;

    public AnnotationAJ(String type, boolean isRuntimeVisible) {
        this.type = type;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public String getTypeSignature() {
        return this.type;
    }

    public List getNameValuePairs() {
        return this.nvPairs;
    }

    public boolean hasNameValuePairs() {
        return this.nvPairs != null && this.nvPairs.size() != 0;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public String stringify() {
        StringBuffer sb = new StringBuffer();
        sb.append("@").append(UnresolvedType.forSignature(this.type).getClassName());
        if (this.hasNameValuePairs()) {
            sb.append("(");
            Iterator iter = this.nvPairs.iterator();
            while (iter.hasNext()) {
                AnnotationNameValuePair element = (AnnotationNameValuePair)iter.next();
                sb.append(element.stringify());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getStringValueOf(Object name) {
        if (!this.hasNameValuePairs()) {
            return null;
        }
        Iterator iter = this.nvPairs.iterator();
        while (iter.hasNext()) {
            AnnotationNameValuePair nvpair = (AnnotationNameValuePair)iter.next();
            if (!nvpair.getName().equals(name)) continue;
            return nvpair.getValue().stringify();
        }
        return null;
    }

    public void addNameValuePair(AnnotationNameValuePair pair) {
        if (this.nvPairs == null) {
            this.nvPairs = new ArrayList();
        }
        this.nvPairs.add(pair);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ANNOTATION [" + this.getTypeSignature() + "] [" + (this.isRuntimeVisible ? "runtimeVisible" : "runtimeInvisible") + "] [");
        if (this.nvPairs != null) {
            Iterator iter = this.nvPairs.iterator();
            while (iter.hasNext()) {
                AnnotationNameValuePair element = (AnnotationNameValuePair)iter.next();
                sb.append(element.toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasNamedValue(String n) {
        if (this.nvPairs == null) {
            return false;
        }
        for (int i = 0; i < this.nvPairs.size(); ++i) {
            AnnotationNameValuePair pair = (AnnotationNameValuePair)this.nvPairs.get(i);
            if (!pair.getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameValuePair(String n, String v) {
        if (this.nvPairs == null) {
            return false;
        }
        for (int i = 0; i < this.nvPairs.size(); ++i) {
            AnnotationNameValuePair pair = (AnnotationNameValuePair)this.nvPairs.get(i);
            if (!pair.getName().equals(n) || !pair.getValue().stringify().equals(v)) continue;
            return true;
        }
        return false;
    }
}

