/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorDialog;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class ErrorHandler
implements org.aspectj.ajde.ErrorHandler {
    private static final int MSG_LIMIT = 600;
    private static boolean showDialogs = true;

    public static void setShowErrorDialogs(boolean show) {
        showDialogs = show;
    }

    public void handleWarning(final String message) {
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public void run() {
                try {
                    IWorkspaceRunnable r = new IWorkspaceRunnable(this, message){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ String val$message;
                        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
                        {
                            this.this$1 = var1_1;
                            this.val$message = string;
                        }

                        public void run(IProgressMonitor monitor) {
                            IProject project = AspectJPlugin.getDefault().getCurrentProject();
                            if (project != null) {
                                try {
                                    IMarker marker = project.createMarker("org.eclipse.jdt.core.problem");
                                    marker.setAttribute("severity", (Object)new Integer(2));
                                    marker.setAttribute("message", (Object)ErrorHandler.access$0(this.val$message, 600));
                                }
                                catch (CoreException coreException) {
                                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
                                }
                            }
                        }

                        static {
                            Factory factory = new Factory("ErrorHandler.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$2"));
                            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$2-org.eclipse.core.runtime.CoreException-<missing>-"), 71);
                            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$2-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 56);
                        }
                    };
                    AspectJPlugin.getWorkspace().run(r, null);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("ErrorHandler.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$1-org.eclipse.core.runtime.CoreException-<missing>-"), 77);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$1----void-"), 53);
            }
        });
    }

    public void handleError(final String message) {
        if (!showDialogs) {
            throw new RuntimeException(message);
        }
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public void run() {
                try {
                    IWorkbenchWindow iww = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow();
                    if (iww != null) {
                        Shell shell = iww.getShell();
                        MessageDialog.openError((Shell)shell, (String)UIMessages.ajErrorDialogTitle, (String)ErrorHandler.limitMessageLength(message, 600));
                    }
                }
                catch (Exception exception) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_0, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("ErrorHandler.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$3"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$3-java.lang.Exception-<missing>-"), 104);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.ErrorHandler$3----void-"), 93);
            }
        });
    }

    public void handleError(String message, Throwable t) {
        ErrorHandler.handleInternalError(UIMessages.ajErrorDialogTitle, message, t);
    }

    public static void handleAJDTError(String title, String message, CoreException t) {
        ErrorHandler.handleInternalError(title, message, t);
    }

    public static void handleAJDTError(String message, CoreException t) {
        ErrorHandler.handleInternalError(UIMessages.ajdtErrorDialogTitle, message, t);
    }

    private static String limitMessageLength(String msg, int length) {
        if (msg.length() > length) {
            int endLength = 150;
            String gap = " ... ";
            return String.valueOf(msg.substring(0, length - endLength - gap.length())) + " ... " + msg.substring(msg.length() - endLength);
        }
        return msg;
    }

    private static void handleInternalError(final String title, String message, Throwable t) {
        String shortMessage;
        String longMessage;
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            longMessage = message;
            shortMessage = message;
        } else {
            String newline = System.getProperty("line.separator");
            shortMessage = UIMessages.ajErrorText;
            StringBuffer sb = new StringBuffer();
            if (t != null) {
                StackTraceElement[] ste = t.getStackTrace();
                sb.append(t.getClass().getName());
                sb.append(newline);
                int i = 0;
                while (i < ste.length) {
                    sb.append("at ");
                    sb.append(ste[i].toString());
                    sb.append(newline);
                    ++i;
                }
            }
            longMessage = String.valueOf(sb.toString()) + newline + message;
            status = new Status(4, "org.eclipse.ajdt.ui", 0, message, t);
        }
        AspectJUIPlugin.getDefault().getLog().log(status);
        if (!showDialogs) {
            throw new RuntimeException(t);
        }
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iww = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow();
                if (iww != null) {
                    Shell shell = iww.getShell();
                    AJDTErrorDialog.openError(shell, title, shortMessage, ErrorHandler.limitMessageLength(longMessage, 600));
                }
            }
        });
    }
}

