/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class AspectJPreferences {
    public static final String COMPILER_OPTIONS = "org.eclipse.ajdt.core.compiler.nonStandardOptions";
    public static final String AJDE_JAR = "ajde.jar";
    public static final String JAVA_OR_AJ_EXT = "aspectjPreferences.fileExt";
    public static final String AUTOBUILD_SUPPRESSED = "org.eclipse.ajdt.ui.preferences.autobuildSuppressed";
    public static final String AJDT_PREF_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone";
    public static final String PERFORM_AUTO_BUILDER_MIGRATION = "org.eclipse.ajdt.ui.preferences.perform.auto.migration";
    public static final String AUTO_BUILDER_MIGRATION_SETTING = "org.eclipse.ajdt.ui.preferences.auto.migration.setting";
    public static final String PDE_AUTO_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoImportConfigDone";
    public static final String PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoRemoveImportConfigDone";
    public static final String ASK_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoImport";
    public static final String DO_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoImport";
    public static final String ASK_PDE_AUTO_REMOVE_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoRemoveImport";
    public static final String DO_PDE_AUTO_REMOVE_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoRemoveImport";
    public static final String VALUE_ERROR = "error";
    public static final String VALUE_WARNING = "warning";
    public static final String VALUE_IGNORE = "ignore";
    public static final String VALUE_ENABLED = "enabled";
    public static final String VALUE_DISABLED = "disabled";
    public static final String OPTION_UseProjectSettings = "org.eclipse.ajdt.core.compiler.useProjectSettings";
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_ReportNoInterfaceCtorJoinpoint = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String OPTION_runtimeExceptionNotSoftened = "org.aspectj.ajdt.core.compiler.lint.runtimeExceptionNotSoftened";
    public static final String OPTION_multipleAdviceStoppingLazyTJP = "org.aspectj.ajdt.core.compiler.lint.multipleAdviceStoppingLazyTjp";
    public static final String OPTION_noGuardForLazyTjp = "org.aspectj.ajdt.core.compiler.lint.noGuardForLazyTjp";
    public static final String OPTION_noExplicitConstructorCall = "org.aspectj.ajdt.core.compiler.lint.noExplicitConstructorCall";
    public static final String OPTION_aspectExcludedByConfiguration = "org.aspectj.ajdt.core.complier.lint.aspectExcludedByConfiguration";
    public static final String OPTION_unorderedAdviceAtShadow = "org.aspectj.ajdt.core.compiler.lint.unorderedAdviceAtShadow";
    public static final String OPTION_cantFindType = "org.aspectj.ajdt.core.compiler.lint.cantFindType";
    public static final String OPTION_calculatingSerialVersionUID = "org.aspectj.ajdt.core.compiler.lint.calculatingSerialVersionUID";
    public static final String OPTION_cantFindTypeAffectingJPMatch = "org.aspectj.ajdt.core.compiler.lint.cantFindTypeAffectingJPMatch";
    public static final String OPTION_noJoinpointsForBridgeMethods = "org.aspectj.ajdt.core.compiler.lint.noJoinpointsForBridgeMethods";
    public static final String OPTION_cantMatchArrayTypeOnVarargs = "org.aspectj.ajdt.core.compiler.lint.cantMatchArrayTypeOnVarargs";
    public static final String OPTION_enumAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.enumAsTargetForDecpIgnored";
    public static final String OPTION_annotationAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.annotationAsTargetForDecpIgnored";
    public static final String OPTION_adviceDidNotMatch = "org.aspectj.ajdt.core.compiler.lint.adviceDidNotMatch";
    public static final String OPTION_invalidTargetForAnnotation = "org.aspectj.ajdt.core.compiler.lint.invalidTargetForAnnotation";
    public static final String OPTION_elementAlreadyAnnotated = "org.aspectj.ajdt.core.compiler.lint.elementAlreadyAnnotated";
    public static final String OPTION_unmatchedTargetKind = "org.aspectj.ajdt.core.compiler.lint.unmatchedTargetKind";
    public static final String OPTION_uncheckedArgument = "org.aspectj.ajdt.core.compiler.lint.uncheckedArgument";
    public static final String OPTION_uncheckedAdviceConversion = "org.aspectj.ajdt.core.compiler.lint.uncheckedAdviceConversion";
    public static final String OPTION_swallowedExceptionInCatchBlock = "org.aspectj.ajdt.core.compiler.lint.swallowedExceptionInCatchBlock";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XNotReweavable = "org.aspectj.ajdt.core.compiler.weaver.XNotReweavable";
    public static final String OPTION_XHasMember = "org.aspectj.ajdt.core.compiler.weaver.XHasMember";
    public static final String OPTION_Outxml = "org.aspectj.ajdt.core.compiler.weaver.outxml";
    public static final String OPTION_Incremental = "org.aspectj.ajdt.core.compiler.BuildOptions.incrementalMode";
    public static final String OPTION_BuildASM = "org.aspectj.ajdt.core.compiler.BuildOptions.buildAsm";
    public static final String OPTION_WeaveMessages = "org.aspectj.ajdt.core.compiler.BuildOptions.showweavemessages";
    private static String[][] lintKeysName;
    private static String XlintProperties;
    public static final String AJDOC_COMMAND = "ajdocCommand";
    public static final String XREF_CHECKED_FILTERS = "org.eclipse.ajdt.internal.ui.xref.checked.filters";
    public static final String XREF_CHECKED_FILTERS_INPLACE = "org.eclipse.ajdt.internal.ui.xref.checked.filters.inplace";
    public static final String DONE_AUTO_OPEN_XREF_VIEW = "doneAutoOpenXRefView";
    public static final String EVENT_CHECKED_FILTERS = "org.eclipse.ajdt.internal.ui.tracing.checked.filters";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("AspectJPreferences.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 304);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setUsingProjectSettings-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:boolean:boolean:-project:isUsingProjectSettings:overwriteExistingProjectSettings:--void-"), 285);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 326);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setSavedIcon-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:java.lang.String:-project:aspect:iconLocation:--void-"), 315);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.io.IOException-<missing>-"), 344);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-writeLintOptionsFile-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.io.File:-thisProject:optsFile:--void-"), 330);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.osgi.service.prefs.BackingStoreException-<missing>-"), 486);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setCompilerOptions-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:java.lang.String:-project:value:--void-"), 475);
        lintKeysName = new String[][]{{OPTION_ReportInvalidAbsoluteTypeName, "invalidAbsoluteTypeName"}, {OPTION_ReportInvalidWildcardTypeName, "invalidWildcardTypeName"}, {OPTION_ReportUnresolvableMember, "unresolvableMember"}, {OPTION_ReportTypeNotExposedToWeaver, "typeNotExposedToWeaver"}, {OPTION_ReportShadowNotInStructure, "shadowNotInStructure"}, {OPTION_ReportUnmatchedSuperTypeInCall, "unmatchedSuperTypeInCall"}, {OPTION_ReportCannotImplementLazyTJP, "canNotImplementLazyTjp"}, {OPTION_ReportNeedSerialVersionUIDField, "needsSerialVersionUIDField"}, {OPTION_ReportIncompatibleSerialVersion, "brokeSerialVersionCompatibility"}, {OPTION_ReportNoInterfaceCtorJoinpoint, "noInterfaceCtorJoinpoint"}, {OPTION_runtimeExceptionNotSoftened, "runtimeExceptionNotSoftened"}, {OPTION_multipleAdviceStoppingLazyTJP, "multipleAdviceStoppingLazyTjp"}, {OPTION_noGuardForLazyTjp, "noGuardForLazyTjp"}, {OPTION_noExplicitConstructorCall, "noExplicitConstructorCall"}, {OPTION_aspectExcludedByConfiguration, "aspectExcludedByConfiguration"}, {OPTION_unorderedAdviceAtShadow, "unorderedAdviceAtShadow"}, {OPTION_cantFindType, "cantFindType"}, {OPTION_calculatingSerialVersionUID, "calculatingSerialVersionUID"}, {OPTION_cantFindTypeAffectingJPMatch, "cantFindTypeAffectingJPMatch"}, {OPTION_noJoinpointsForBridgeMethods, "noJoinpointsForBridgeMethods"}, {OPTION_cantMatchArrayTypeOnVarargs, "cantMatchArrayTypeOnVarargs"}, {OPTION_enumAsTargetForDecpIgnored, "enumAsTargetForDecpIgnored"}, {OPTION_annotationAsTargetForDecpIgnored, "annotationAsTargetForDecpIgnored"}, {OPTION_adviceDidNotMatch, "adviceDidNotMatch"}, {OPTION_invalidTargetForAnnotation, "invalidTargetForAnnotation"}, {OPTION_elementAlreadyAnnotated, "elementAlreadyAnnotated"}, {OPTION_unmatchedTargetKind, "unmatchedTargetKind"}, {OPTION_uncheckedArgument, "uncheckedArgument"}, {OPTION_uncheckedAdviceConversion, "uncheckedAdviceConversion"}, {OPTION_swallowedExceptionInCatchBlock, "swallowedExceptionInCatchBlock"}};
        XlintProperties = "Xlint.properties";
    }

    public static String getFileExt() {
        return ".aj";
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(JAVA_OR_AJ_EXT, false);
        store.setDefault(AUTOBUILD_SUPPRESSED, true);
        store.setDefault(PDE_AUTO_IMPORT_CONFIG_DONE, false);
        store.setDefault(ASK_PDE_AUTO_IMPORT, true);
        store.setDefault(DO_PDE_AUTO_IMPORT, false);
        store.setDefault(PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE, false);
        store.setDefault(ASK_PDE_AUTO_REMOVE_IMPORT, true);
        store.setDefault(DO_PDE_AUTO_REMOVE_IMPORT, false);
    }

    public static String getLintOptions(IProject thisProject) {
        File optsFile = AspectJUIPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        AspectJPreferences.writeLintOptionsFile(thisProject, optsFile);
        return " -Xlintfile \"" + optsFile + "\" ";
    }

    public static boolean getShowWeaveMessagesOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_WeaveMessages);
    }

    public static boolean getBuildASMOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_BuildASM);
    }

    public static boolean getIncrementalOption(IProject thisProject) {
        return AspectJPreferences.getBooleanPrefValue(thisProject, OPTION_Incremental);
    }

    public static boolean isUsingProjectSettings(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
        if (projectNode == null) {
            return false;
        }
        return projectNode.getBoolean(OPTION_UseProjectSettings, false);
    }

    public static void setUsingProjectSettings(IProject project, boolean isUsingProjectSettings) {
        AspectJPreferences.setUsingProjectSettings(project, isUsingProjectSettings, true);
    }

    public static void setUsingProjectSettings(IProject project, boolean isUsingProjectSettings, boolean overwriteExistingProjectSettings) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
        if (isUsingProjectSettings) {
            projectNode.putBoolean(OPTION_UseProjectSettings, true);
            if (overwriteExistingProjectSettings) {
                AJCompilerPreferencePage.setProjectDefaults(projectNode);
            } else {
                AJCompilerPreferencePage.setProjectDefaultsIfValueNotAlreadySet(projectNode);
            }
        } else {
            projectNode.remove(OPTION_UseProjectSettings);
            AJCompilerPreferencePage.removeProjectValues(projectNode);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static String getSavedIcon(IProject project, String aspect) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        return projectNode.get(aspect, null);
    }

    public static void setSavedIcon(IProject project, String aspect, String iconLocation) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.ui");
        if (iconLocation == null || iconLocation.trim().equals("")) {
            projectNode.remove(aspect);
        } else {
            projectNode.put(aspect, iconLocation);
        }
        try {
            projectNode.flush();
        }
        catch (BackingStoreException backingStoreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_2, ajc$tjp_3);
        }
    }

    private static void writeLintOptionsFile(IProject thisProject, File optsFile) {
        try {
            FileWriter writer = new FileWriter(optsFile);
            int i = 0;
            while (i < lintKeysName.length) {
                String value = AspectJPreferences.getStringPrefValue(thisProject, lintKeysName[i][0]);
                if (value.equals("")) {
                    value = VALUE_WARNING;
                }
                writer.write(String.valueOf(lintKeysName[i][1]) + " = " + value);
                writer.write(System.getProperty("line.separator"));
                ++i;
            }
            writer.close();
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public static String getAdvancedOptions(IProject project) {
        String opts = " ";
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XSerializableAspects)) {
            opts = String.valueOf(opts) + "-XserializableAspects ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XNoInline)) {
            opts = String.valueOf(opts) + "-XnoInline ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XNotReweavable)) {
            opts = String.valueOf(opts) + "-XnotReweavable ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_XHasMember)) {
            opts = String.valueOf(opts) + "-XhasMember ";
        }
        if (AspectJPreferences.getBooleanPrefValue(project, OPTION_Outxml)) {
            opts = String.valueOf(opts) + "-outxml ";
        }
        return opts;
    }

    public static boolean isAutobuildSuppressed() {
        return false;
    }

    public static void setAskPDEAutoImport(boolean ask) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_IMPORT, ask);
    }

    public static boolean askPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_IMPORT);
    }

    public static void setPDEAutoImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoImportConfigDone() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoImport(boolean doImport) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_IMPORT, doImport);
    }

    public static boolean doPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_IMPORT);
    }

    public static void setAskPDEAutoRemoveImport(boolean ask) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_REMOVE_IMPORT, ask);
    }

    public static boolean askPDEAutoRemoveImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_REMOVE_IMPORT);
    }

    public static void setPDEAutoRemoveImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoRemoveImportConfigDone() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_REMOVE_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoRemoveImport(boolean doImport) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_REMOVE_IMPORT, doImport);
    }

    public static boolean doPDEAutoRemoveImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_REMOVE_IMPORT);
    }

    public static void setCompilerOptions(IProject project, String value) {
        if (AspectJPreferences.isUsingProjectSettings(project)) {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
            projectNode.put(COMPILER_OPTIONS, value);
            if (value.length() == 0) {
                projectNode.remove(COMPILER_OPTIONS);
            }
            try {
                projectNode.flush();
            }
            catch (BackingStoreException backingStoreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(backingStoreException, ajc$tjp_6, ajc$tjp_7);
            }
        } else {
            IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
            store.setValue(COMPILER_OPTIONS, value);
        }
    }

    public static String getCompilerOptions(IProject project) {
        String compilerOptions = AspectJPreferences.getStringPrefValue(project, COMPILER_OPTIONS);
        return compilerOptions;
    }

    public static String getStringPrefValue(IProject project, String key) {
        if (AspectJPreferences.isUsingProjectSettings(project)) {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
            String v = projectNode.get(key, "");
            return v;
        }
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getString(key);
    }

    private static boolean getBooleanPrefValue(IProject project, String key) {
        if (AspectJPreferences.isUsingProjectSettings(project)) {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.ajdt.core");
            boolean v = projectNode.getBoolean(key, false);
            return v;
        }
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(key);
    }

    public static void setCheckedFilters(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("set: ");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append(name);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        pstore.setValue(XREF_CHECKED_FILTERS, sb.toString());
    }

    public static List getFilterCheckedList() {
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        String xRefCheckedFilters = pstore.getString(XREF_CHECKED_FILTERS);
        if (!xRefCheckedFilters.startsWith("set: ")) {
            return null;
        }
        xRefCheckedFilters = xRefCheckedFilters.substring("set: ".length());
        ArrayList<Object> checkedList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(xRefCheckedFilters, ",");
        while (tokenizer.hasMoreTokens()) {
            checkedList.add(tokenizer.nextElement());
        }
        return checkedList;
    }

    public static void setEventTraceList(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("set: ");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append(name);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        pstore.setValue(EVENT_CHECKED_FILTERS, sb.toString());
    }

    public static List getEventTraceCheckedList() {
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        String eventTraceCheckedFilters = pstore.getString(EVENT_CHECKED_FILTERS);
        if (!eventTraceCheckedFilters.startsWith("set: ")) {
            return null;
        }
        eventTraceCheckedFilters = eventTraceCheckedFilters.substring("set: ".length());
        ArrayList<Object> checkedList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(eventTraceCheckedFilters, ",");
        while (tokenizer.hasMoreTokens()) {
            checkedList.add(tokenizer.nextElement());
        }
        return checkedList;
    }

    public static void setCheckedInplaceFilters(List l) {
        StringBuffer sb = new StringBuffer();
        sb.append("set: ");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append(name);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        IPreferenceStore pstoreInplace = AspectJUIPlugin.getDefault().getPreferenceStore();
        pstoreInplace.setValue(XREF_CHECKED_FILTERS_INPLACE, sb.toString());
    }

    public static List getFilterCheckedInplaceList() {
        IPreferenceStore pstoreInplace = AspectJUIPlugin.getDefault().getPreferenceStore();
        String xRefCheckedFilters = pstoreInplace.getString(XREF_CHECKED_FILTERS_INPLACE);
        if (!xRefCheckedFilters.startsWith("set: ")) {
            return null;
        }
        xRefCheckedFilters = xRefCheckedFilters.substring("set: ".length());
        ArrayList<Object> checkedList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(xRefCheckedFilters, ",");
        while (tokenizer.hasMoreTokens()) {
            checkedList.add(tokenizer.nextElement());
        }
        return checkedList;
    }
}

