/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.internal.ui.editor.AspectJLabelProvider;
import org.eclipse.ajdt.internal.utils.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.part.ViewPart;

public class StructureModelView
extends ViewPart
implements ISelectionListener,
StructureViewRenderer {
    private TreeViewer viewer;
    private Action fLinkWithEditor;
    private boolean fDoLinkWithEditor = true;
    private StructureViewManager svManager;
    private StructureView view;
    private StructureViewProperties viewProperties;
    protected IFile input;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public void createPartControl(Composite parent) {
        this.svManager = Ajde.getDefault().getStructureViewManager();
        this.viewProperties = this.svManager.getDefaultViewProperties();
        this.viewProperties.setGranularity(StructureViewProperties.Granularity.DECLARED_ELEMENTS);
        this.viewer = new TreeViewer(parent, 770);
        this.makeActions();
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.hookDoubleClickAction();
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AspectJLabelProvider(parent));
        this.expandTreeView();
    }

    public void init(IViewSite site) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        ISelectionService service = site.getWorkbenchWindow().getSelectionService();
        service.addPostSelectionListener((ISelectionListener)this);
    }

    private void makeActions() {
        this.fLinkWithEditor = new Action(){

            public void run() {
                StructureModelView.this.fDoLinkWithEditor = StructureModelView.this.fLinkWithEditor.isChecked();
            }
        };
        this.fLinkWithEditor.setChecked(this.fDoLinkWithEditor);
        this.fLinkWithEditor.setText("&Link with Editor");
        this.fLinkWithEditor.setToolTipText("Link With Editor");
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fLinkWithEditor, (String)"synced.gif");
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructureModelView.this.handleDoubleClick();
            }
        });
    }

    private void handleDoubleClick() {
        Object target;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (target = ((IStructuredSelection)selection).getFirstElement()) instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode ajdtNode = (AJDTStructureViewNode)target;
            IMarker marker = ajdtNode.getMarker(this.input.getProject());
            if (ajdtNode.getStructureNode() != null) {
                AJLog.log((String)this.getLogMessage(ajdtNode.getStructureNode().getName(), marker));
                if (marker != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)false);
                    }
                    catch (PartInitException partInitException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(partInitException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                    }
                }
            } else {
                AJLog.log((String)"Problem in outline view: Editor input is not a file");
            }
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fLinkWithEditor);
    }

    private String getLogMessage(String label, IMarker marker) {
        StringBuffer buff = new StringBuffer();
        buff.append("Tree node selected: ");
        buff.append(label);
        buff.append(". Navigation target: ");
        if (marker != null) {
            buff.append(marker.getResource().getName());
            buff.append(" line ");
            try {
                Integer lineNo = (Integer)marker.getAttribute("lineNumber");
                buff.append(lineNo);
            }
            catch (Exception exception) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_2, ajc$tjp_3);
                buff.append("ERR");
            }
        } else {
            buff.append("<None>");
        }
        return buff.toString();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorInput editorInput;
        if (!this.fDoLinkWithEditor || !(selection instanceof ITextSelection)) {
            return;
        }
        if (part instanceof IEditorPart && (editorInput = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fe = (IFileEditorInput)editorInput;
            this.input = fe.getFile();
            IAdaptable outline = this.getContentOutline(this.input, true);
            this.viewer.setInput((Object)outline);
        }
    }

    private IAdaptable getContentOutline(IFile input, boolean registerForUpdates) {
        String filePath = AJDTUtils.getResourcePath((IResource)input);
        AJLog.log((String)("Structure view requested for " + input.getName()));
        if (this.view != null) {
            this.svManager.deleteView(this.view);
        }
        FileStructureView structureView = this.svManager.createViewForSourceFile(filePath, this.viewProperties);
        structureView.setRenderer((StructureViewRenderer)this);
        this.view = structureView;
        return (AJDTStructureViewNode)this.view.getRootNode();
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setActiveNode(IStructureViewNode activeNode, int lineOffset) {
        this.setActiveNode(activeNode);
    }

    public void setActiveNode(IStructureViewNode node) {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setInput((Object)node);
    }

    public void updateView(StructureView view) {
        AJLog.log((String)("outline updateview called (file:" + this.input.getName() + "): " + view.toString()));
        final StructureView fView = view;
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

            public void run() {
                try {
                    StructureModelView.this.update(fView);
                }
                catch (Exception exception) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_0, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("StructureModelView.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.StructureModelView$3"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.StructureModelView$3-java.lang.Exception-<missing>-"), 256);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.StructureModelView$3----void-"), 253);
            }
        });
    }

    public void update() {
        AJLog.log((String)("Editor Update called: " + this.input.getName()));
        this.getControl().setRedraw(false);
        IAdaptable outline = this.getContentOutline(this.input, true);
        this.getTreeViewer().setInput((Object)outline);
        this.expandTreeView();
        this.getControl().setRedraw(true);
    }

    public void update(StructureView view) {
        if (view != null && this.view != null && !view.toString().equals(this.view.toString())) {
            AJLog.log((String)("Assumption Not True: Old view object:" + view.toString() + "  New view object:" + view.toString()));
        }
        if (this.input.getProject().equals((Object)AJBuilder.getLastBuildTarget())) {
            AJLog.log((String)("Model update notification for " + this.input.getName()));
            this.view = view;
            this.getControl().setRedraw(false);
            AJDTStructureViewNode toDisplay = (AJDTStructureViewNode)view.getRootNode();
            this.getTreeViewer().setInput((Object)toDisplay);
            this.expandTreeView();
            this.getControl().setRedraw(true);
        }
    }

    public Control getControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getControl();
    }

    private void expandTreeView() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.collapseAll();
        Tree t = viewer.getTree();
        TreeItem[] tItems = t.getItems();
        int i = 0;
        while (i < tItems.length) {
            TreeItem item = tItems[i];
            AJDTStructureViewNode node = (AJDTStructureViewNode)item.getData();
            if (node.getStructureNode() instanceof IProgramElement) {
                viewer.expandToLevel((Object)node, 1);
            }
            ++i;
        }
    }

    public void setFocus() {
    }

    static {
        Factory factory = new Factory("StructureModelView.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.StructureModelView"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.StructureModelView-org.eclipse.ui.PartInitException-<missing>-"), 151);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-handleDoubleClick-org.eclipse.ajdt.internal.ui.ajde.StructureModelView----void-"), 135);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.StructureModelView-java.lang.Exception-<missing>-"), 176);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLogMessage-org.eclipse.ajdt.internal.ui.ajde.StructureModelView-java.lang.String:org.eclipse.core.resources.IMarker:-label:marker:--java.lang.String-"), 165);
    }
}

