/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationManagementUtils;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.wizards.AspectPathLibrariesWorkbookPage;
import org.eclipse.ajdt.internal.ui.wizards.TabFolderLayout;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;

public class AspectPathBlock
implements PreferencePageBuilder.AJDTPathBlockPage {
    private IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    private ListDialogField fAspectPathList;
    private StatusInfo fAspectPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private int fPageIndex;
    private AspectPathLibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;
    private List existingAspectPath;
    private Control fSWTControl;
    private final int IDX_ADDJAR = 3;
    private final int IDX_ADDEXT = 4;
    private final int IDX_ADDVAR = 5;
    private final int IDX_ADDFOL = 6;
    private final int IDX_REMOVE = 8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public AspectPathBlock(IStatusChangeListener context, int pageToShow) {
        this.fContext = context;
        this.fPageIndex = pageToShow;
        this.fLibrariesPage = null;
        this.fCurrPage = null;
        LibrariesAdapter adapter = new LibrariesAdapter();
        String[] stringArray = new String[9];
        stringArray[0] = UIMessages.InPathBlock_order_up_button;
        stringArray[1] = UIMessages.InPathBlock_order_down_button;
        stringArray[3] = UIMessages.InPathLibrariesWorkbookPage_libraries_addjar_button;
        stringArray[4] = UIMessages.InPathLibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[5] = UIMessages.InPathLibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[6] = UIMessages.InPathLibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[8] = UIMessages.InPathLibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = stringArray;
        this.fAspectPathList = new ListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fAspectPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fAspectPathList.setLabelText(UIMessages.AspectPathBlock_aspectpath_label);
        this.fAspectPathList.setUpButtonIndex(0);
        this.fAspectPathList.setDownButtonIndex(1);
        this.fAspectPathList.setRemoveButtonIndex(8);
        this.fAspectPathList.enableButton(8, false);
        this.fBuildPathStatus = new StatusInfo();
        this.fAspectPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 3: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 4: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 5: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 6: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 8: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fAspectPathList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", (Object)BuildPathSupport.guessSourceAttachment((CPListElement)curr));
                    curr.setAttribute("javadoc_location", (Object)JavaUI.getLibraryJavadocLocation((IPath)curr.getPath()));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 6) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fAspectPathList.addElements(elementsToAdd);
            this.fAspectPathList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fAspectPathList.getSelectedElements();
        this.fAspectPathList.enableButton(8, this.canRemove(selElements));
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        if (!modified.isEmpty()) {
            String title = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_title;
            String message = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageKeyPressed(ListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fAspectPathList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((CPListElementAttribute)elem).getValue() == null : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateAspectpathList();
        }
    }

    private void removeEntry() {
        List selElements = this.fAspectPathList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fAspectPathList.refresh();
            this.fAspectPathList.dialogFieldChanged();
        } else {
            this.fAspectPathList.removeElements(selElements);
        }
    }

    private void updateAspectpathList() {
        int nEntries;
        List projelements = this.fAspectPathList.getElements();
        List cpelements = this.fAspectPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            List list = cpelements;
            ListDialogField listDialogField = this.fAspectPathList;
            PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$6$5dca5dc3(listDialogField, list, this);
            listDialogField.setElements((Collection)list);
        }
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(existing))) != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = this.fWorkspaceRoot.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = this.fWorkspaceRoot.findMember(curr);
                    String outJar = AspectJCorePreferences.getProjectOutJar((IProject)this.fCurrJProject.getProject());
                    StringBuffer projectOutJar = new StringBuffer();
                    projectOutJar.append(this.fCurrJProject.getPath().toString());
                    projectOutJar.append("/" + outJar);
                    if (resource.getFullPath().toString().equals(projectOutJar.toString())) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)UIMessages.buildpathwarning_title, (String)UIMessages.addtoaspectpathwarning);
                    } else if (resource instanceof IFile) {
                        res.add(this.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])this.getUsedJARFiles(existing));
            if (configured != null && (resource = this.fWorkspaceRoot.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
            }
        }
        List cplist = this.fAspectPathList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fAspectPathList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry((Shell)this.getShell(), (IPath)existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List existingElements = this.fAspectPathList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i2], null);
                    IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i2]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])existingPathsArray);
            if (path != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries((Shell)this.getShell(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPListElement(this.fCurrJProject, 5, created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IClasspathEntry created = BuildPathDialogAccess.configureContainerEntry((Shell)this.getShell(), (IClasspathEntry)existing.getClasspathEntry(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 5, created.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fAspectPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fAspectPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fAspectPathList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fAspectPathList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public void setSelection(List selection, boolean expand) {
        this.fAspectPathList.selectElements((ISelection)new StructuredSelection(selection));
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fAspectPathList) {
            this.updateAspectPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public void init(IJavaProject jproject, IPath outputLocation, IClasspathEntry[] aspectpathEntries) {
        this.fCurrJProject = jproject;
        this.existingAspectPath = null;
        if (outputLocation == null) {
            outputLocation = this.getDefaultBuildPath(jproject);
        }
        if (aspectpathEntries != null) {
            this.existingAspectPath = this.getExistingEntries(aspectpathEntries);
        }
        if (this.existingAspectPath == null) {
            this.existingAspectPath = new ArrayList();
        }
        this.fOutputLocationPath = new Path(outputLocation.makeRelative().toString()).makeAbsolute();
        List list = this.existingAspectPath;
        ListDialogField listDialogField = this.fAspectPathList;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$6$5dca5dc3(listDialogField, list, this);
        listDialogField.setElements((Collection)list);
        if (this.fLibrariesPage != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.doStatusLineUpdate();
    }

    public void updateAspectPathStatus() {
        this.fAspectPathStatus.setOK();
        List elements = this.fAspectPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fAspectPathStatus.setWarning(UIMessages.AspectPathBlock_warning_EntryMissing);
            } else {
                this.fAspectPathStatus.setWarning(UIMessages.AspectBlock_warning_EntriesMissing);
            }
        }
        this.updateBuildPathStatus();
    }

    private void doStatusLineUpdate() {
        IStatus res = this.findMostSevereStatus();
        this.fContext.statusChanged(res);
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    private IPath getDefaultBuildPath(IJavaProject jproj) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String outputLocationName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return jproj.getProject().getFullPath().append(outputLocationName);
        }
        return jproj.getProject().getFullPath();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] aspectpathEntries) {
        ArrayList<CPListElement> newAspectPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < aspectpathEntries.length) {
            IClasspathEntry curr = aspectpathEntries[i];
            newAspectPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newAspectPath;
    }

    private void updateBuildPathStatus() {
        List elements = this.fAspectPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fAspectPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(UIMessages.AspectPathBlock_operationdesc_java);
        monitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fAspectPathList.getElements(), monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    protected void internalConfigureJavaProject(List aspectPathEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int nEntries = aspectPathEntries.size();
        IClasspathEntry[] aspectpath = new IClasspathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            CPListElement entry = (CPListElement)aspectPathEntries.get(i);
            aspectpath[i] = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry.getClasspathEntry());
            ++i;
        }
        monitor.worked(2);
        StringBuffer aspectpathBuffer = new StringBuffer();
        StringBuffer contentKindBuffer = new StringBuffer();
        StringBuffer entryKindBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < aspectpath.length) {
            aspectpathBuffer.append(aspectpath[i2].getPath());
            aspectpathBuffer.append(File.pathSeparator);
            contentKindBuffer.append(aspectpath[i2].getContentKind());
            contentKindBuffer.append(File.pathSeparator);
            entryKindBuffer.append(aspectpath[i2].getEntryKind());
            entryKindBuffer.append(File.pathSeparator);
            ++i2;
        }
        aspectpathBuffer = this.removeFinalPathSeparatorChar(aspectpathBuffer);
        contentKindBuffer = this.removeFinalPathSeparatorChar(contentKindBuffer);
        entryKindBuffer = this.removeFinalPathSeparatorChar(entryKindBuffer);
        AspectJCorePreferences.setProjectAspectPath((IProject)this.fCurrJProject.getProject(), (String)aspectpathBuffer.toString(), (String)contentKindBuffer.toString(), (String)entryKindBuffer.toString());
        LaunchConfigurationManagementUtils.updateAspectPaths(this.fCurrJProject, this.existingAspectPath, aspectPathEntries);
    }

    private StringBuffer removeFinalPathSeparatorChar(StringBuffer buffer) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == File.pathSeparatorChar) {
            buffer = buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        IWorkbench workbench = AspectJUIPlugin.getDefault().getWorkbench();
        this.fLibrariesPage = new AspectPathLibrariesWorkbookPage(this.fWorkspaceRoot, this.fAspectPathList);
        TabItem item = new TabItem(folder, 0);
        item.setText(UIMessages.AspectPathBlock_tab_libraries);
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fAspectPathList);
        item = new TabItem(folder, 0);
        item.setText(UIMessages.InPathBlock_tab_inpath_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AspectPathBlock.this.tabChanged(e.item);
            }
        });
        workbench.getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.build_paths_context");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public TabItem tabContent(TabFolder folder) {
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fAspectPathList);
        TabItem item = new TabItem(folder, 0);
        item.setText(UIMessages.AspectPathBlock_tab_libraries);
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        Control control = item.getControl();
        if (control instanceof Composite) {
            Label label = new Label((Composite)control, 16448);
            label.setText(UIMessages.AspectPathBlock_note);
        }
        return item;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    static {
        Factory factory = new Factory("AspectPathBlock.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.AspectPathBlock"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.AspectPathBlock-org.eclipse.jdt.core.JavaModelException-<missing>-"), 394);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getUsedContainers-org.eclipse.ajdt.internal.ui.wizards.AspectPathBlock-org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement:-existing:--[Lorg.eclipse.core.runtime.IPath;-"), 386);
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        LibrariesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            AspectPathBlock.this.libaryPageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(ListDialogField field) {
            AspectPathBlock.this.libaryPageSelectionChanged((DialogField)field);
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void keyPressed(ListDialogField field, KeyEvent event) {
            AspectPathBlock.this.libaryPageKeyPressed(field, event);
        }

        public void dialogFieldChanged(DialogField field) {
            AspectPathBlock.this.libaryPageDialogFieldChanged(field);
        }
    }
}

