/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareAnnotationDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseSourceLocation;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.bridge.IMessage;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.EnumAnnotationValue;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.Pointcut;

public class EclipseSourceType
extends AbstractReferenceTypeDelegate {
    private static final char[] pointcutSig = "Lorg/aspectj/lang/annotation/Pointcut;".toCharArray();
    private static final char[] aspectSig = "Lorg/aspectj/lang/annotation/Aspect;".toCharArray();
    protected ResolvedPointcutDefinition[] declaredPointcuts = null;
    protected ResolvedMember[] declaredMethods = null;
    protected ResolvedMember[] declaredFields = null;
    public List declares = new ArrayList();
    public List typeMungers = new ArrayList();
    private EclipseFactory factory;
    private SourceTypeBinding binding;
    private TypeDeclaration declaration;
    private CompilationUnitDeclaration unit;
    private boolean annotationsResolved = false;
    private ResolvedType[] resolvedAnnotations = null;
    private boolean discoveredAnnotationTargetKinds = false;
    private AnnotationTargetKind[] annotationTargetKinds;
    private AnnotationX[] annotations = null;
    private static final ResolvedType[] NO_ANNOTATION_TYPES = new ResolvedType[0];
    private static final AnnotationX[] NO_ANNOTATIONS = new AnnotationX[0];
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;

    protected EclipseFactory eclipseWorld() {
        return this.factory;
    }

    public EclipseSourceType(ReferenceType resolvedTypeX, EclipseFactory factory, SourceTypeBinding binding, TypeDeclaration declaration, CompilationUnitDeclaration unit) {
        super(resolvedTypeX, true);
        this.factory = factory;
        this.binding = binding;
        this.declaration = declaration;
        this.unit = unit;
        this.setSourceContext((ISourceContext)new EclipseSourceContext(declaration.compilationResult));
        resolvedTypeX.setStartPos(declaration.sourceStart);
        resolvedTypeX.setEndPos(declaration.sourceEnd);
    }

    public boolean isAspect() {
        boolean isCodeStyle = this.declaration instanceof AspectDeclaration;
        return isCodeStyle ? isCodeStyle : this.isAnnotationStyleAspect();
    }

    public boolean isAnonymous() {
        return (this.declaration.modifiers & 0x300) != 0;
    }

    public boolean isNested() {
        if (this.declaration.binding != null) {
            return this.declaration.binding.isMemberType();
        }
        return (this.declaration.modifiers & 0x400) != 0;
    }

    public ResolvedType getOuterClass() {
        if (this.declaration.enclosingType == null) {
            return null;
        }
        return this.eclipseWorld().fromEclipse(this.declaration.enclosingType.binding);
    }

    public boolean isAnnotationStyleAspect() {
        if (this.declaration.annotations == null) {
            return false;
        }
        ResolvedType[] annotations = this.getAnnotationTypes();
        for (int i = 0; i < annotations.length; ++i) {
            if (!"org.aspectj.lang.annotation.Aspect".equals(annotations[i].getName())) continue;
            return true;
        }
        return false;
    }

    private String getPointcutStringFromAnnotationStylePointcut(AbstractMethodDeclaration amd) {
        Annotation[] ans = amd.annotations;
        if (ans == null) {
            return "";
        }
        for (int i = 0; i < ans.length; ++i) {
            char[] sig;
            if (ans[i].resolvedType == null || !CharOperation.equals(pointcutSig, sig = ans[i].resolvedType.signature())) continue;
            if (ans[i].memberValuePairs().length == 0) {
                return "";
            }
            StringLiteral sLit = (StringLiteral)ans[i].memberValuePairs()[0].value;
            return new String(sLit.source());
        }
        return "";
    }

    private boolean isAnnotationStylePointcut(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        for (int i = 0; i < annotations.length; ++i) {
            char[] sig;
            if (annotations[i].resolvedType == null || !CharOperation.equals(pointcutSig, sig = annotations[i].resolvedType.signature())) continue;
            return true;
        }
        return false;
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ResolvedType getSuperclass() {
        if (this.binding.isInterface()) {
            return this.getResolvedTypeX().getWorld().getCoreType(UnresolvedType.OBJECT);
        }
        return this.eclipseWorld().fromEclipse(this.binding.superclass());
    }

    public ResolvedType[] getDeclaredInterfaces() {
        return this.eclipseWorld().fromEclipse(this.binding.superInterfaces());
    }

    protected void fillDeclaredMembers() {
        ArrayList<ResolvedPointcutDefinition> declaredPointcuts = new ArrayList<ResolvedPointcutDefinition>();
        ArrayList<ResolvedMember> declaredMethods = new ArrayList<ResolvedMember>();
        ArrayList<ResolvedMember> declaredFields = new ArrayList<ResolvedMember>();
        this.binding.methods();
        AbstractMethodDeclaration[] methods = this.declaration.methods;
        if (methods != null) {
            int len = methods.length;
            for (int i = 0; i < len; ++i) {
                AbstractMethodDeclaration amd = methods[i];
                if (amd == null || amd.ignoreFurtherInvestigation) continue;
                if (amd instanceof PointcutDeclaration) {
                    PointcutDeclaration d = (PointcutDeclaration)amd;
                    ResolvedPointcutDefinition df = d.makeResolvedPointcutDefinition(this.factory);
                    declaredPointcuts.add(df);
                    continue;
                }
                if (amd instanceof InterTypeDeclaration || amd instanceof DeclareDeclaration && !(amd instanceof DeclareAnnotationDeclaration) || amd instanceof AdviceDeclaration) continue;
                if (amd.annotations != null && this.isAnnotationStylePointcut(amd.annotations)) {
                    ResolvedPointcutDefinition df = this.makeResolvedPointcutDefinition(amd);
                    if (df == null) continue;
                    declaredPointcuts.add(df);
                    continue;
                }
                if (amd.binding == null || !amd.binding.isValidBinding()) continue;
                ResolvedMember member = this.factory.makeResolvedMember(amd.binding);
                if (this.unit != null) {
                    member.setSourceContext((ISourceContext)new EclipseSourceContext(this.unit.compilationResult, amd.binding.sourceStart()));
                    member.setPosition(amd.binding.sourceStart(), amd.binding.sourceEnd());
                }
                declaredMethods.add(member);
            }
        }
        FieldBinding[] fields = this.binding.fields();
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            FieldBinding f = fields[i];
            declaredFields.add(this.factory.makeResolvedMember(f));
        }
        this.declaredPointcuts = declaredPointcuts.toArray(new ResolvedPointcutDefinition[declaredPointcuts.size()]);
        this.declaredMethods = declaredMethods.toArray(new ResolvedMember[declaredMethods.size()]);
        this.declaredFields = declaredFields.toArray(new ResolvedMember[declaredFields.size()]);
    }

    private ResolvedPointcutDefinition makeResolvedPointcutDefinition(AbstractMethodDeclaration md) {
        if (md.binding == null) {
            return null;
        }
        EclipseSourceContext eSourceContext = new EclipseSourceContext(md.compilationResult);
        Pointcut pc = null;
        if (!md.isAbstract()) {
            String expression = this.getPointcutStringFromAnnotationStylePointcut(md);
            try {
                pc = new PatternParser(expression, (ISourceContext)eSourceContext).parsePointcut();
            }
            catch (ParserException pe) {
                pc = Pointcut.makeMatchesNothing((Pointcut.State)Pointcut.SYMBOLIC);
            }
        }
        ResolvedPointcutDefinition resolvedPointcutDeclaration = new ResolvedPointcutDefinition(this.factory.fromBinding(md.binding.declaringClass), md.modifiers, new String(md.selector), this.factory.fromBindings(md.binding.parameters), pc);
        resolvedPointcutDeclaration.setPosition(md.sourceStart, md.sourceEnd);
        resolvedPointcutDeclaration.setSourceContext((ISourceContext)eSourceContext);
        return resolvedPointcutDeclaration;
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.declaredFields == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredFields;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.declaredMethods == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredMethods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.declaredPointcuts == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredPointcuts;
    }

    public int getModifiers() {
        return this.binding.modifiers & 0xFFFF;
    }

    public String toString() {
        return "EclipseSourceType(" + new String(this.binding.sourceName()) + ")";
    }

    public void checkPointcutDeclarations() {
        ResolvedMember[] pointcuts = this.getDeclaredPointcuts();
        boolean sawError = false;
        int len = pointcuts.length;
        for (int i = 0; i < len; ++i) {
            if (pointcuts[i].isAbstract()) {
                if (!this.isAspect()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut only allowed in aspect" + pointcuts[i].getName(), pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                } else if (!this.binding.isAbstract()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut in concrete aspect" + pointcuts[i], pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                }
            }
            for (int j = i + 1; j < len; ++j) {
                if (!pointcuts[i].getName().equals(pointcuts[j].getName())) continue;
                this.eclipseWorld().showMessage(IMessage.ERROR, "duplicate pointcut name: " + pointcuts[j].getName(), pointcuts[i].getSourceLocation(), pointcuts[j].getSourceLocation());
                sawError = true;
            }
        }
        if (sawError || !this.isAspect()) {
            return;
        }
        this.getResolvedTypeX().getExposedPointcuts();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public boolean isEnum() {
        return (this.binding.getAccessFlags() & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.binding.getAccessFlags() & 0x2000) != 0;
    }

    public void addAnnotation(AnnotationX annotationX) {
        throw new RuntimeException("EclipseSourceType.addAnnotation() not implemented");
    }

    public boolean isAnnotationWithRuntimeRetention() {
        if (!this.isAnnotation()) {
            return false;
        }
        return (this.binding.getAnnotationTagBits() & 0x180000000000L) == 0x180000000000L;
    }

    public String getRetentionPolicy() {
        if (this.isAnnotation()) {
            if ((this.binding.getAnnotationTagBits() & 0x180000000000L) == 0x180000000000L) {
                return "RUNTIME";
            }
            if ((this.binding.getAnnotationTagBits() & 0x180000000000L) == 0x80000000000L) {
                return "SOURCE";
            }
            if ((this.binding.getAnnotationTagBits() & 0x180000000000L) == 0x100000000000L) {
                return "CLASS";
            }
        }
        return null;
    }

    public boolean canAnnotationTargetType() {
        if (this.isAnnotation()) {
            return (this.binding.getAnnotationTagBits() & 0x800000000L) != 0L;
        }
        return false;
    }

    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        if (this.discoveredAnnotationTargetKinds) {
            return this.annotationTargetKinds;
        }
        this.discoveredAnnotationTargetKinds = true;
        this.annotationTargetKinds = null;
        if (this.isAnnotation()) {
            ArrayList<AnnotationTargetKind> targetKinds = new ArrayList<AnnotationTargetKind>();
            if ((this.binding.getAnnotationTagBits() & 0x20000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.ANNOTATION_TYPE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x8000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.CONSTRUCTOR);
            }
            if ((this.binding.getAnnotationTagBits() & 0x1000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.FIELD);
            }
            if ((this.binding.getAnnotationTagBits() & 0x10000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.LOCAL_VARIABLE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x2000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.METHOD);
            }
            if ((this.binding.getAnnotationTagBits() & 0x40000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.PACKAGE);
            }
            if ((this.binding.getAnnotationTagBits() & 0x4000000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.PARAMETER);
            }
            if ((this.binding.getAnnotationTagBits() & 0x800000000L) != 0L) {
                targetKinds.add(AnnotationTargetKind.TYPE);
            }
            if (!targetKinds.isEmpty()) {
                this.annotationTargetKinds = new AnnotationTargetKind[targetKinds.size()];
                return targetKinds.toArray(this.annotationTargetKinds);
            }
        }
        return this.annotationTargetKinds;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        Annotation[] as;
        if (!this.annotationsResolved) {
            ASTNode.resolveAnnotations(this.declaration.staticInitializerScope, this.declaration.annotations, this.binding);
            this.annotationsResolved = true;
        }
        if ((as = this.declaration.annotations) == null) {
            return false;
        }
        for (int i = 0; i < as.length; ++i) {
            Annotation annotation = as[i];
            if (annotation.resolvedType == null) {
                return false;
            }
            String tname = CharOperation.charToString(annotation.resolvedType.constantPoolName());
            if (!UnresolvedType.forName((String)tname).equals((Object)ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationX[] getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        this.getAnnotationTypes();
        Annotation[] as = this.declaration.annotations;
        if (as == null || as.length == 0) {
            this.annotations = NO_ANNOTATIONS;
        } else {
            this.annotations = new AnnotationX[as.length];
            for (int i = 0; i < as.length; ++i) {
                this.annotations[i] = this.convertEclipseAnnotation(as[i], this.factory.getWorld());
            }
        }
        return this.annotations;
    }

    public AnnotationX convertEclipseAnnotation(Annotation eclipseAnnotation, World w) {
        ResolvedType annotationType = this.factory.fromTypeBindingToRTX(eclipseAnnotation.type.resolvedType);
        long bs = (long)eclipseAnnotation.bits & 0x180000000000L;
        boolean isRuntimeVisible = ((long)eclipseAnnotation.bits & 0x180000000000L) == 0x180000000000L;
        AnnotationAJ annotationAJ = new AnnotationAJ(annotationType.getSignature(), isRuntimeVisible);
        this.generateAnnotation(eclipseAnnotation, annotationAJ);
        return new AnnotationX(annotationAJ, w);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateAnnotation(Annotation annotation, AnnotationAJ annotationAJ) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            if (memberValuePairs == null) throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            int memberValuePairsLength = memberValuePairs.length;
            for (int i = 0; i < memberValuePairsLength; ++i) {
                MemberValuePair memberValuePair = memberValuePairs[i];
                MethodBinding methodBinding = memberValuePair.binding;
                if (methodBinding == null) {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
                }
                AnnotationValue av = this.generateElementValue(memberValuePair.value, methodBinding.returnType);
                AnnotationNameValuePair anvp = new AnnotationNameValuePair(new String(memberValuePair.name), av);
                annotationAJ.addNameValuePair(anvp);
            }
            return;
        } else {
            if (!(annotation instanceof SingleMemberAnnotation)) throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            }
            AnnotationValue av = this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType);
            annotationAJ.addNameValuePair(new AnnotationNameValuePair(new String(singleMemberAnnotation.memberValuePairs()[0].name), av));
        }
    }

    private AnnotationValue generateElementValue(Expression defaultValue, TypeBinding memberValuePairReturnType) {
        Constant constant = defaultValue.constant;
        TypeBinding defaultValueBinding = defaultValue.resolvedType;
        if (defaultValueBinding == null) {
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        if (memberValuePairReturnType.isArrayType() && !defaultValueBinding.isArrayType()) {
            if (constant != null && constant != Constant.NotAConstant) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            AnnotationValue av = this.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
            return new ArrayAnnotationValue(new AnnotationValue[]{av});
        }
        if (constant != null && constant != Constant.NotAConstant) {
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        AnnotationValue av = this.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
        return av;
    }

    private AnnotationValue generateElementValueForNonConstantExpression(Expression defaultValue, TypeBinding defaultValueBinding) {
        if (defaultValueBinding != null) {
            if (defaultValueBinding.isEnum()) {
                NameReference nameReference;
                FieldBinding fieldBinding = null;
                if (defaultValue instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (defaultValue instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
                }
                if (fieldBinding != null) {
                    String sig = new String(fieldBinding.type.signature());
                    EnumAnnotationValue enumValue = new EnumAnnotationValue(sig, new String(fieldBinding.name));
                    return enumValue;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValueBinding.isAnnotationType()) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValueBinding.isArrayType()) {
                if (defaultValue instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)defaultValue;
                    int arrayLength = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    AnnotationValue[] values = new AnnotationValue[arrayLength];
                    for (int i = 0; i < arrayLength; ++i) {
                        values[i] = this.generateElementValue(arrayInitializer.expressions[i], defaultValueBinding.leafComponentType());
                    }
                    ArrayAnnotationValue aav = new ArrayAnnotationValue(values);
                    return aav;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.resolvedAnnotations != null) {
            return this.resolvedAnnotations;
        }
        if (!this.annotationsResolved) {
            ASTNode.resolveAnnotations(this.declaration.staticInitializerScope, this.declaration.annotations, this.binding);
            this.annotationsResolved = true;
        }
        if (this.declaration.annotations == null) {
            this.resolvedAnnotations = NO_ANNOTATION_TYPES;
        } else {
            this.resolvedAnnotations = new ResolvedType[this.declaration.annotations.length];
            Annotation[] as = this.declaration.annotations;
            for (int i = 0; i < as.length; ++i) {
                Annotation annotation = as[i];
                this.resolvedAnnotations[i] = this.factory.fromTypeBindingToRTX(annotation.type.resolvedType);
            }
        }
        return this.resolvedAnnotations;
    }

    public PerClause getPerClause() {
        if (!this.isAnnotationStyleAspect()) {
            PerClause pc;
            if (this.declaration instanceof AspectDeclaration && (pc = ((AspectDeclaration)this.declaration).perClause) != null) {
                return pc;
            }
            return new PerSingleton();
        }
        PerClause pc = null;
        if (this.declaration instanceof AspectDeclaration) {
            pc = ((AspectDeclaration)this.declaration).perClause;
        }
        if (pc == null) {
            PerClause.Kind kind = this.getPerClauseForTypeDeclaration(this.declaration);
            return new PerFromSuper(kind);
        }
        return pc;
    }

    PerClause.Kind getPerClauseForTypeDeclaration(TypeDeclaration typeDeclaration) {
        Annotation[] annotations = typeDeclaration.annotations;
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            if (!CharOperation.equals(aspectSig, annotation.resolvedType.signature())) continue;
            if (annotation.memberValuePairs() == null || annotation.memberValuePairs().length == 0) {
                PerClause.Kind kind = this.lookupPerClauseKind(typeDeclaration.binding.superclass);
                if (kind == null) {
                    return PerClause.SINGLETON;
                }
                return kind;
            }
            if (annotation instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation theAnnotation = (SingleMemberAnnotation)annotation;
                String clause = new String(((StringLiteral)theAnnotation.memberValue).source());
                return this.determinePerClause(typeDeclaration, clause);
            }
            if (annotation instanceof NormalAnnotation) {
                NormalAnnotation theAnnotation = (NormalAnnotation)annotation;
                if (theAnnotation.memberValuePairs == null || theAnnotation.memberValuePairs.length < 1) {
                    return PerClause.SINGLETON;
                }
                String clause = new String(((StringLiteral)theAnnotation.memberValuePairs[0].value).source());
                return this.determinePerClause(typeDeclaration, clause);
            }
            this.eclipseWorld().showMessage(IMessage.ABORT, "@Aspect annotation is expected to be SingleMemberAnnotation with 'String value()' as unique element", new EclipseSourceLocation(typeDeclaration.compilationResult, typeDeclaration.sourceStart, typeDeclaration.sourceEnd), null);
            return PerClause.SINGLETON;
        }
        return null;
    }

    private PerClause.Kind determinePerClause(TypeDeclaration typeDeclaration, String clause) {
        if (clause.startsWith("perthis(")) {
            return PerClause.PEROBJECT;
        }
        if (clause.startsWith("pertarget(")) {
            return PerClause.PEROBJECT;
        }
        if (clause.startsWith("percflow(")) {
            return PerClause.PERCFLOW;
        }
        if (clause.startsWith("percflowbelow(")) {
            return PerClause.PERCFLOW;
        }
        if (clause.startsWith("pertypewithin(")) {
            return PerClause.PERTYPEWITHIN;
        }
        if (clause.startsWith("issingleton(")) {
            return PerClause.SINGLETON;
        }
        this.eclipseWorld().showMessage(IMessage.ABORT, "cannot determine perClause '" + clause + "'", new EclipseSourceLocation(typeDeclaration.compilationResult, typeDeclaration.sourceStart, typeDeclaration.sourceEnd), null);
        return PerClause.SINGLETON;
    }

    private PerClause.Kind lookupPerClauseKind(ReferenceBinding binding) {
        Object kind;
        if (binding instanceof BinaryTypeBinding) {
            ResolvedType superTypeX = this.factory.fromEclipse(binding);
            PerClause perClause = superTypeX.getPerClause();
            kind = perClause != null ? superTypeX.getPerClause().getKind() : null;
        } else if (binding instanceof SourceTypeBinding) {
            SourceTypeBinding sourceSc = (SourceTypeBinding)binding;
            kind = sourceSc.scope.referenceContext instanceof AspectDeclaration ? ((AspectDeclaration)sourceSc.scope.referenceContext).perClause.getKind() : (sourceSc.scope.referenceContext instanceof TypeDeclaration ? this.getPerClauseForTypeDeclaration(sourceSc.scope.referenceContext) : null);
        } else {
            kind = null;
        }
        return kind;
    }

    public Collection getDeclares() {
        return this.declares;
    }

    public Collection getPrivilegedAccesses() {
        return Collections.EMPTY_LIST;
    }

    public Collection getTypeMungers() {
        return this.typeMungers;
    }

    public boolean doesNotExposeShadowMungers() {
        return true;
    }

    public String getDeclaredGenericSignature() {
        return CharOperation.charToString(this.binding.genericSignature());
    }

    public boolean isGeneric() {
        return this.binding.isGenericType();
    }

    public TypeVariable[] getTypeVariables() {
        if (this.declaration.typeParameters == null) {
            return new TypeVariable[0];
        }
        TypeVariable[] typeVariables = new TypeVariable[this.declaration.typeParameters.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            typeVariables[i] = this.typeParameter2TypeVariable(this.declaration.typeParameters[i]);
        }
        return typeVariables;
    }

    private TypeVariable typeParameter2TypeVariable(TypeParameter aTypeParameter) {
        String name = new String(aTypeParameter.name);
        ReferenceBinding superclassBinding = aTypeParameter.binding.superclass;
        UnresolvedType superclass = UnresolvedType.forSignature((String)new String(superclassBinding.signature()));
        UnresolvedType[] superinterfaces = null;
        ReferenceBinding[] superInterfaceBindings = aTypeParameter.binding.superInterfaces;
        if (superInterfaceBindings != null) {
            superinterfaces = new UnresolvedType[superInterfaceBindings.length];
            for (int i = 0; i < superInterfaceBindings.length; ++i) {
                superinterfaces[i] = UnresolvedType.forSignature((String)new String(superInterfaceBindings[i].signature()));
            }
        }
        TypeVariable tv = new TypeVariable(name, superclass, superinterfaces);
        tv.setDeclaringElement(this.factory.fromBinding(aTypeParameter.binding.declaringElement));
        tv.setRank(aTypeParameter.binding.rank);
        return tv;
    }

    public void ensureDelegateConsistent() {
    }

    static class MissingImplementationException
    extends RuntimeException {
        MissingImplementationException(String reason) {
            super(reason);
        }
    }
}

