/**********************************************************************
Copyright (c) 2002 2006 IBM Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
Contributors:
Adrian Colyer, Andy Clement, Tracy Gardner - initial version
...
**********************************************************************/
package org.eclipse.ajdt.internal.ui.ajde;

import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaModelMarker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * ErrorHandler handles warnings and errors produced from the AJ Tools plugin
 */
public class ErrorHandler implements org.aspectj.ajde.ErrorHandler {

	/**
	 * Handle warnings reported by AspectJ
	 */
	public void handleWarning(final String message) {
		// 154483 instead of displaying a dialog we create a problem marker
		AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkspaceRunnable r = new IWorkspaceRunnable() {
						public void run(IProgressMonitor monitor) {
							IProject project = AspectJPlugin.getDefault()
									.getCurrentProject();
							if (project != null) {
								try {
									IMarker marker = project
											.createMarker(IJavaModelMarker.JAVA_MODEL_PROBLEM_MARKER);
									marker
											.setAttribute(
													IMarker.SEVERITY,
													new Integer(
															IMarker.SEVERITY_ERROR));
									marker.setAttribute(IMarker.MESSAGE,
											AJDTErrorHandler.limitMessageLength(message,
													AJDTErrorHandler.MSG_LIMIT));
								} catch (CoreException e) {
								}
							}
						}
					};
					AspectJPlugin.getWorkspace().run(r, null);
				} catch (CoreException t) {
				}
			}
		});
	}

	/**
	 * Display an error dialog - only called by AspectJ
	 */
	public void handleError(final String message) {
		if (!AJDTErrorHandler.showDialogs) {
			// rethrow exception instead of showing dialog
			throw new RuntimeException(message);
		}

		AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable() {
			public void run() {
				try {
					IWorkbenchWindow iww = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow();
					// This really should not be null ...
					if (iww != null) {
						Shell shell = iww.getShell();
						MessageDialog.openError(
							shell,
							UIMessages.ajErrorDialogTitle,
							AJDTErrorHandler.limitMessageLength(message,AJDTErrorHandler.MSG_LIMIT));
					}
				} catch (Exception t) {
				}
			}
		});
	}

	/**
	 * Display an error dialog with exception - only called by AspectJ
	 */
	public void handleError(String message, Throwable t) {
		AJDTErrorHandler.handleInternalError(UIMessages.ajErrorDialogTitle,
				message, t);
	}

}