/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.core.model.ModelComparison;
import org.eclipse.ajdt.internal.ui.diff.ChangesViewFilterAction;
import org.eclipse.ajdt.internal.ui.help.AspectJUIHelp;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ChangesView
extends ViewPart {
    private ChangesViewFilterAction filterAction;
    private Action propagateToggleAction;
    public static final String CROSSCUTTING_VIEW_ID = "org.eclipse.ajdt.ui.diff.ChangesView";
    public static final String MAP_FILE_EXT = "ajmap";
    public static final String DOT_MAP_FILE_EXT = ".ajmap";
    public static final String CURRENT_BUILD;
    private Table table;
    private TableCursor cursor;
    private int selectedRow;
    private int selectedColumn;
    private IJavaElement[] sourceElements;
    private IJavaElement[] targetElements;
    private int lastMouseDownTime;
    private IProject currFromProject;
    private IProject currToProject;
    private IJavaElement currFromEl;
    private IJavaElement currToEl;
    private String currFromName;
    private String currToName;
    private static Image incomingImage;
    private static Image outgoingImage;
    private boolean propagateUp = false;
    private static final int EMPTY = 0;
    private static final int COMPARING_FILES = 1;
    private static final int COMPARING_ELEMENTS = 2;
    private int compareMode = 0;
    private ILabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(), AspectJUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("ChangesView.java", Class.forName("org.eclipse.ajdt.internal.ui.diff.ChangesView"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.ChangesView-java.lang.ClassNotFoundException-<missing>-"), 643);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAdapter-org.eclipse.ajdt.internal.ui.diff.ChangesView-java.lang.Class:-key:--java.lang.Object-"), 642);
        CURRENT_BUILD = UIMessages.changesView_currentBuild;
        incomingImage = null;
        outgoingImage = null;
    }

    public static void refresh(boolean force) {
        IWorkbenchWindow w = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return;
        }
        IViewPart view = w.getActivePage().findView(CROSSCUTTING_VIEW_ID);
        if (view instanceof ChangesView) {
            ChangesView changesView = (ChangesView)view;
            if (changesView.compareMode == 1) {
                changesView.refreshIfCurrentBuild(force);
            } else if (changesView.compareMode == 2) {
                changesView.refresh();
            }
        }
    }

    private void refresh() {
        this.compareElements(this.currFromEl, this.currToEl);
    }

    private void refreshIfCurrentBuild(boolean force) {
        if (this.currFromName != null && this.currToName != null && (force || this.currFromName.equals(CURRENT_BUILD) || this.currToName.equals(CURRENT_BUILD))) {
            this.compareProjects(this.currFromProject, this.currFromName, this.currToProject, this.currToName);
        }
    }

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 67586);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        String[] titles = new String[]{UIMessages.changesView_table_column1, UIMessages.changesView_table_column2, UIMessages.changesView_table_column3, UIMessages.changesView_table_column4};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            ++i;
        }
        int c = 0;
        while (c < titles.length) {
            this.table.getColumn(c).pack();
            final int col = c;
            this.table.getColumn(c).addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableItem[] items = ChangesView.this.table.getItems();
                    Collator collator = Collator.getInstance((Locale)Locale.getDefault());
                    int i = 1;
                    while (i < items.length) {
                        String value1 = items[i].getText(col);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(col);
                            if (collator.compare(value1, value2) < 0) {
                                String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3)};
                                Image[] icons = new Image[]{items[i].getImage(0), items[i].getImage(1), items[i].getImage(2), items[i].getImage(3)};
                                items[i].dispose();
                                TableItem item = new TableItem(ChangesView.this.table, 0, j);
                                item.setText(values);
                                item.setImage(icons);
                                items = ChangesView.this.table.getItems();
                                IJavaElement temp = ChangesView.this.sourceElements[i];
                                System.arraycopy(ChangesView.this.sourceElements, j, ChangesView.this.sourceElements, j + 1, i - j);
                                ((ChangesView)ChangesView.this).sourceElements[j] = temp;
                                temp = ChangesView.this.targetElements[i];
                                System.arraycopy(ChangesView.this.targetElements, j, ChangesView.this.targetElements, j + 1, i - j);
                                ((ChangesView)ChangesView.this).targetElements[j] = temp;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            ++c;
        }
        this.cursor = new TableCursor(this.table, 4);
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangesView.this.table.setSelection(new TableItem[]{ChangesView.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChangesView.this.navigateTo(ChangesView.this.table.indexOf(ChangesView.this.cursor.getRow()), ChangesView.this.cursor.getColumn());
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangesView.this.lastMouseDownTime = e.time;
            }
        });
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.time - ChangesView.this.lastMouseDownTime < Display.getDefault().getDoubleClickTime()) {
                    this.mouseDoubleClick(event);
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                Rectangle b = ChangesView.this.cursor.getBounds();
                Point pt = new Point(b.x + event.x, b.y + event.y);
                TableItem row = ChangesView.this.table.getItem(pt);
                if (row == null) {
                    return;
                }
                int i = 0;
                while (i < ChangesView.this.table.getColumnCount()) {
                    Rectangle rect = row.getBounds(i);
                    if (rect.contains(pt)) {
                        ChangesView.this.navigateTo(ChangesView.this.table.indexOf(row), i);
                    }
                    ++i;
                }
            }
        });
        this.restorePersistedSettings();
        this.makeActions();
        this.contributeToActionBars();
        this.table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ChangesView.this.cursor.setVisible(true);
                ChangesView.this.cursor.setFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.cursor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ChangesView.this.cursor.getRow() != null) {
                    ChangesView.this.selectedColumn = ChangesView.this.cursor.getColumn();
                    ChangesView.this.selectedRow = ChangesView.this.table.indexOf(ChangesView.this.cursor.getRow());
                }
                ChangesView.this.cursor.setVisible(false);
                ChangesView.this.table.setSelection(-1);
            }
        });
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ChangesView.this.resizeColumns();
            }
        });
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void navigateTo(int row, int column) {
        if (column == 1 && this.sourceElements != null && row < this.sourceElements.length) {
            XRefUIUtils.revealInEditor((IJavaElement)this.sourceElements[row]);
        } else if (column == 3 && this.targetElements != null && row < this.targetElements.length) {
            XRefUIUtils.revealInEditor((IJavaElement)this.targetElements[row]);
        }
    }

    public void dispose() {
        super.dispose();
        this.persistSettings();
        this.sourceElements = null;
        this.targetElements = null;
        this.currFromProject = null;
        this.currFromName = null;
        this.currToProject = null;
        this.currToName = null;
        if (incomingImage != null) {
            incomingImage.dispose();
            incomingImage = null;
        }
        if (outgoingImage != null) {
            outgoingImage.dispose();
            outgoingImage = null;
        }
    }

    private void persistSettings() {
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        if (!pstore.contains("org.eclipse.ajdt.ui.preferences.propagateup")) {
            pstore.setDefault("org.eclipse.ajdt.ui.preferences.propagateup", false);
        }
        pstore.setValue("org.eclipse.ajdt.ui.preferences.propagateup", this.propagateUp);
        AspectJUIPlugin.getDefault().savePluginPreferences();
    }

    private void restorePersistedSettings() {
        IPreferenceStore pstore = AspectJUIPlugin.getDefault().getPreferenceStore();
        if (pstore.contains("org.eclipse.ajdt.ui.preferences.propagateup")) {
            this.propagateUp = pstore.getBoolean("org.eclipse.ajdt.ui.preferences.propagateup");
        }
    }

    public void setFocus() {
        if (this.table.getItemCount() > 0) {
            this.cursor.setVisible(true);
            if (this.selectedColumn >= 0 && this.selectedColumn < this.table.getColumnCount() && this.selectedRow >= 0 && this.selectedRow < this.table.getItemCount()) {
                this.cursor.setSelection(this.selectedRow, this.selectedColumn);
            } else {
                this.cursor.setSelection(0, 0);
            }
            this.cursor.setFocus();
        }
    }

    private void updateDescription(String fromName, String toName, int remove, int total) {
        if (remove == total) {
            this.setContentDescription(NLS.bind((String)UIMessages.changesView_description, (Object)fromName, (Object)toName));
        } else {
            this.setContentDescription(String.valueOf(NLS.bind((String)UIMessages.changesView_description, (Object)fromName, (Object)toName)) + " " + NLS.bind((String)UIMessages.changesView_filter_dialog_showingXofY, (Object)new Integer(remove).toString(), (Object)new Integer(total).toString()));
        }
    }

    private AJProjectModel getModelFromName(IProject project, String name) {
        if (name.equals(CURRENT_BUILD)) {
            return AJModel.getInstance().getModelForProject(project);
        }
        AJProjectModel model = new AJProjectModel(project);
        IPath mapFile = project.getFile(name).getLocation();
        boolean success = model.loadModel(mapFile);
        if (!success) {
            return null;
        }
        return model;
    }

    private static Image getIncomingImage() {
        if (incomingImage == null) {
            incomingImage = AspectJImages.CHANGES_ADDED.getImageDescriptor().createImage();
        }
        return incomingImage;
    }

    private static Image getOutgoingImage() {
        if (outgoingImage == null) {
            outgoingImage = AspectJImages.CHANGES_REMOVED.getImageDescriptor().createImage();
        }
        return outgoingImage;
    }

    private List filterRelationshipList(List relationshipList) {
        ArrayList<AJRelationship> filteredList = new ArrayList<AJRelationship>();
        Iterator iter = relationshipList.iterator();
        while (iter.hasNext()) {
            AJRelationship element = (AJRelationship)iter.next();
            if (this.filterAction.getCheckedList().contains(element.getRelationship().getDisplayName())) continue;
            filteredList.add(element);
        }
        return filteredList;
    }

    public void compareProjects(IProject fromProject, String fromName, IProject toProject, String toName) {
        this.compareMode = 1;
        this.currFromProject = fromProject;
        this.currFromName = fromName;
        this.currToProject = toProject;
        this.currToName = toName;
        AJProjectModel fromModel = this.getModelFromName(fromProject, fromName);
        AJProjectModel toModel = this.getModelFromName(toProject, toName);
        if (fromModel == null || toModel == null) {
            return;
        }
        List[] ret = new ModelComparison(this.propagateUp).compareProjects(fromModel, toModel);
        boolean filterAdded = this.filterAction.getCheckedList().contains(UIMessages.changesView_filter_added_rels);
        boolean filterRemoved = this.filterAction.getCheckedList().contains(UIMessages.changesView_filter_removed_rels);
        ArrayList addedList = filterAdded ? new ArrayList() : this.filterRelationshipList(ret[0]);
        ArrayList removedList = filterRemoved ? new ArrayList() : this.filterRelationshipList(ret[1]);
        int totalNoRelationships = ret[0].size() + ret[1].size();
        this.updateDescription(fromName, toName, addedList.size() + removedList.size(), totalNoRelationships);
        this.updateTable(addedList, removedList, fromModel, toModel);
    }

    public void compareElements(IJavaElement fromEl, IJavaElement toEl) {
        this.compareMode = 2;
        this.currFromEl = fromEl;
        this.currToEl = toEl;
        IProject fromProject = fromEl.getResource().getProject();
        IProject toProject = toEl.getResource().getProject();
        AJProjectModel fromModel = AJModel.getInstance().getModelForProject(fromProject);
        AJProjectModel toModel = AJModel.getInstance().getModelForProject(toProject);
        List[] ret = new ModelComparison(this.propagateUp).compareElements(fromModel, toModel, fromEl, toEl);
        boolean filterAdded = this.filterAction.getCheckedList().contains(UIMessages.changesView_filter_added_rels);
        boolean filterRemoved = this.filterAction.getCheckedList().contains(UIMessages.changesView_filter_removed_rels);
        ArrayList addedList = filterAdded ? new ArrayList() : this.filterRelationshipList(ret[0]);
        ArrayList removedList = filterRemoved ? new ArrayList() : this.filterRelationshipList(ret[1]);
        int totalNoRelationships = ret[0].size() + ret[1].size();
        this.updateDescription(fromEl.getElementName(), toEl.getElementName(), addedList.size() + removedList.size(), totalNoRelationships);
        this.updateTable(addedList, removedList, fromModel, toModel);
    }

    private void updateTable(List addedList, List removedList, AJProjectModel fromModel, AJProjectModel toModel) {
        TableItem item;
        String targetName;
        String sourceName;
        AJRelationship rel;
        int numEntries = addedList.size() + removedList.size();
        this.sourceElements = new IJavaElement[numEntries];
        this.targetElements = new IJavaElement[numEntries];
        this.table.removeAll();
        int rowCount = 0;
        Iterator iter = addedList.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            sourceName = toModel.getJavaElementLinkName(rel.getSource());
            targetName = toModel.getJavaElementLinkName(rel.getTarget());
            item = new TableItem(this.table, 0);
            item.setText(0, UIMessages.changesView_table_added);
            item.setImage(0, ChangesView.getIncomingImage());
            item.setText(1, sourceName);
            item.setImage(1, this.labelProvider.getImage((Object)rel.getSource()));
            item.setText(2, rel.getRelationship().getDisplayName());
            item.setImage(2, XReferenceUIPlugin.getDefault().getXReferenceImage());
            item.setText(3, targetName);
            item.setImage(3, this.labelProvider.getImage((Object)rel.getTarget()));
            this.sourceElements[rowCount] = rel.getSource();
            this.targetElements[rowCount] = rel.getTarget();
            ++rowCount;
        }
        iter = removedList.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            sourceName = fromModel.getJavaElementLinkName(rel.getSource());
            targetName = fromModel.getJavaElementLinkName(rel.getTarget());
            item = new TableItem(this.table, 0);
            item.setText(0, UIMessages.changesView_table_removed);
            item.setImage(0, ChangesView.getOutgoingImage());
            item.setText(1, sourceName);
            item.setImage(1, this.labelProvider.getImage((Object)rel.getSource()));
            item.setText(2, rel.getRelationship().getDisplayName());
            item.setImage(2, XReferenceUIPlugin.getDefault().getXReferenceImage());
            item.setText(3, targetName);
            item.setImage(3, this.labelProvider.getImage((Object)rel.getTarget()));
            this.sourceElements[rowCount] = rel.getSource();
            this.targetElements[rowCount] = rel.getTarget();
            ++rowCount;
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.resizeColumns();
    }

    private void resizeColumns() {
        if (this.table == null) {
            return;
        }
        if (this.table.getColumnCount() < 4) {
            return;
        }
        int w = this.table.getClientArea().width - this.table.getColumn(0).getWidth() - this.table.getColumn(2).getWidth();
        this.table.getColumn(1).setWidth(w / 2);
        this.table.getColumn(3).setWidth(w - w / 2);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.filterAction.fillActionBars(this.getViewSite().getActionBars());
        manager.add((IAction)this.propagateToggleAction);
    }

    private void makeActions() {
        this.propagateToggleAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                ChangesView.this.propagateUp = !ChangesView.this.propagateUp;
                ChangesView.refresh(true);
            }
        };
        this.propagateToggleAction.setText(UIMessages.changesView_propagate_message);
        this.propagateToggleAction.setToolTipText(UIMessages.changesView_propagate_tooltip);
        this.propagateToggleAction.setImageDescriptor(AspectJImages.PROPAGATE_UP.getImageDescriptor());
        this.propagateToggleAction.setChecked(this.propagateUp);
        AJRelationshipType[] relationshipTypes = AJRelationshipManager.getAllRelationshipTypes();
        ArrayList<String> populatingList = new ArrayList<String>();
        int i = 0;
        while (i < relationshipTypes.length) {
            populatingList.add(relationshipTypes[i].getDisplayName());
            ++i;
        }
        populatingList.add(UIMessages.changesView_filter_added_rels);
        populatingList.add(UIMessages.changesView_filter_removed_rels);
        ArrayList<String> defaultFilterList = new ArrayList<String>();
        defaultFilterList.add(AJRelationshipManager.ADVISED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.ASPECT_DECLARATIONS.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.MATCHES_DECLARE.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.ANNOTATED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.SOFTENED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.USES_POINTCUT.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.POINTCUT_USED_BY.getDisplayName());
        ArrayList checkedList = new ArrayList();
        if (checkedList.size() == 0) {
            checkedList = new ArrayList(defaultFilterList);
        }
        String dlogTitle = UIMessages.changesView_filter_dialog_title;
        String dlogMessage = UIMessages.changesView_filter_dialog_message;
        this.filterAction = new ChangesViewFilterAction(this.getSite().getShell(), populatingList, checkedList, defaultFilterList, dlogTitle, dlogMessage, UIMessages.changesView_filter_action_tooltip);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(classNotFoundException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return AspectJUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.ajdt.ui.crosscutting_comparison_view_context");
        }
        return super.getAdapter(key);
    }
}

