/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import org.eclipse.ajdt.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class BaseExportWizard
extends Wizard
implements IExportWizard,
IPreferenceConstants {
    protected IStructuredSelection fSelection;

    public BaseExportWizard() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(PDEUIMessages.BaseExportWizard_wtitle);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        String name = this.getSettingsSectionName();
        IDialogSettings settings = master.getSection(name);
        if (settings == null) {
            settings = master.addNewSection(name);
        }
        return settings;
    }

    protected abstract String getSettingsSectionName();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public boolean performFinish() {
        this.saveSettings();
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return false;
        }
        if (!this.performPreliminaryChecks()) {
            return false;
        }
        if (!this.confirmDelete()) {
            return false;
        }
        this.scheduleExportJob();
        return true;
    }

    protected void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ((AbstractExportWizardPage)pages[i]).saveSettings(settings);
            ++i;
        }
    }

    protected abstract boolean performPreliminaryChecks();

    protected abstract boolean confirmDelete();

    protected abstract void scheduleExportJob();
}

