/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.core;

import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.internal.AjdeCoreBuildManager;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AjCompiler {
    private ICompilerConfiguration compilerConfig;
    private IBuildProgressMonitor monitor;
    private IBuildMessageHandler handler;
    private String compilerId;
    private AjdeCoreBuildManager buildManager;

    public AjCompiler(String compilerId, ICompilerConfiguration compilerConfig, IBuildProgressMonitor buildProgressMonitor, IBuildMessageHandler buildMessageHandler) {
        this.compilerConfig = compilerConfig;
        this.monitor = buildProgressMonitor;
        this.handler = buildMessageHandler;
        this.compilerId = compilerId;
        this.buildManager = new AjdeCoreBuildManager(this);
    }

    public String getId() {
        return this.compilerId;
    }

    public ICompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfig;
    }

    public IBuildProgressMonitor getBuildProgressMonitor() {
        return this.monitor;
    }

    public IBuildMessageHandler getMessageHandler() {
        return this.handler;
    }

    public void build() {
        if (this.hasValidId()) {
            this.buildManager.doBuild(false);
        }
    }

    public void buildFresh() {
        if (this.hasValidId()) {
            this.buildManager.doBuild(true);
        }
    }

    public void clearLastState() {
        IncrementalStateManager.removeIncrementalStateInformationFor(this.compilerId);
    }

    public boolean isJava6Compatible() {
        return CompilerOptions.versionToJdkLevel("1.6") != 0L;
    }

    private boolean hasValidId() {
        if (this.compilerId == null) {
            Message msg = new Message("compiler didn't have an id associated with it", IMessage.ABORT, null, null);
            this.handler.handleMessage((IMessage)msg);
            return false;
        }
        return true;
    }
}

