/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.IClasspathContainer;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.Assert;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibrary;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibraryClasspathContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.aspectj.org.eclipse.jdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static Map userLibraries;
    private static final boolean logProblems = false;
    private static IEclipsePreferences.IPreferenceChangeListener listener;

    static {
        listener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String key = event.getKey();
                if (key.startsWith(UserLibraryManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    try {
                        UserLibraryManager.recreatePersistedUserLibraryEntry(key, (String)event.getNewValue(), false, true);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private UserLibraryManager() {
    }

    public static String[] getUserLibraryNames() {
        Set set = UserLibraryManager.getLibraryMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static UserLibrary getUserLibrary(String name) {
        return (UserLibrary)UserLibraryManager.getLibraryMap().get(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setUserLibraries(String[] newNames, UserLibrary[] newLibs, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue(newNames.length == newLibs.length, "names and libraries should have the same length");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Configure user libraries...", newNames.length);
        try {
            int last = newNames.length - 1;
            int i = 0;
            while (i < newLibs.length) {
                UserLibraryManager.internalSetUserLibrary(newNames[i], newLibs[i], i == last, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public static void setUserLibrary(String name, UserLibrary library, IProgressMonitor monitor) throws JavaModelException {
        UserLibraryManager.internalSetUserLibrary(name, library, true, true, monitor);
    }

    static Map getLibraryMap() {
        if (userLibraries == null) {
            userLibraries = new HashMap();
            IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
            instancePreferences.addPreferenceChangeListener(listener);
            try {
                String[] propertyNames = instancePreferences.keys();
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    if (propertyName.startsWith(CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                        try {
                            String propertyValue = instancePreferences.get(propertyName, null);
                            if (propertyValue != null) {
                                UserLibraryManager.recreatePersistedUserLibraryEntry(propertyName, propertyValue, false, false);
                            }
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return userLibraries;
    }

    static void recreatePersistedUserLibraryEntry(String propertyName, String savedString, boolean save, boolean rebind) throws JavaModelException {
        String libName = propertyName.substring(CP_USERLIBRARY_PREFERENCES_PREFIX.length());
        if (savedString == null || savedString.equals(CP_ENTRY_IGNORE)) {
            UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
        } else {
            try {
                StringReader reader = new StringReader(savedString);
                UserLibrary library = UserLibrary.createFromString(reader);
                UserLibraryManager.internalSetUserLibrary(libName, library, save, rebind, null);
            }
            catch (IOException e) {
                UserLibraryManager.internalSetUserLibrary(libName, null, save, rebind, null);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void internalSetUserLibrary(String name, UserLibrary library, boolean save, boolean rebind, IProgressMonitor monitor) throws JavaModelException {
        Object previous;
        if (library == null ? (previous = UserLibraryManager.getLibraryMap().remove(name)) == null : library.equals(previous = UserLibraryManager.getLibraryMap().put(name, library))) {
            return;
        }
        IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
        String containerKey = CP_USERLIBRARY_PREFERENCES_PREFIX + name;
        String containerString = CP_ENTRY_IGNORE;
        if (library != null) {
            try {
                containerString = library.serialize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        instancePreferences.removePreferenceChangeListener(listener);
        try {
            instancePreferences.put(containerKey, containerString);
            if (save) {
                try {
                    instancePreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            if (rebind) {
                UserLibraryManager.rebindClasspathEntries(name, library == null, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            instancePreferences.addPreferenceChangeListener(listener);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        instancePreferences.addPreferenceChangeListener(listener);
    }

    private static void rebindClasspathEntries(String name, boolean remove, IProgressMonitor monitor) throws JavaModelException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create(root).getJavaProjects();
        IPath containerPath = new Path("org.aspectj.org.eclipse.jdt.USER_LIBRARY").append(name);
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IClasspathEntry[] entries = project.getRawClasspath();
            int k = 0;
            while (k < entries.length) {
                IClasspathEntry curr = entries[k];
                if (curr.getEntryKind() == 5 && containerPath.equals((Object)curr.getPath())) {
                    affectedProjects.add(project);
                    break;
                }
                ++k;
            }
            ++i;
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            if (!remove) {
                UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(name);
                containers[0] = container;
            }
            JavaCore.setClasspathContainer(containerPath, affected, containers, monitor);
        } else if (monitor != null) {
            monitor.done();
        }
    }
}

