/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageContext;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.MessageWriter;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.ISupportsMessageContext;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingClassLoader;

public class WeavingAdaptor
implements IMessageContext {
    public static final String WEAVING_ADAPTOR_VERBOSE = "aj.weaving.verbose";
    public static final String SHOW_WEAVE_INFO_PROPERTY = "org.aspectj.weaver.showWeaveInfo";
    public static final String TRACE_MESSAGES_PROPERTY = "org.aspectj.tracing.messages";
    private boolean enabled = false;
    protected boolean verbose = WeavingAdaptor.getVerbose();
    protected BcelWorld bcelWorld;
    protected BcelWeaver weaver;
    private IMessageHandler messageHandler;
    private WeavingAdaptorMessageHolder messageHolder;
    private boolean abortOnError = false;
    protected GeneratedClassHandler generatedClassHandler;
    protected Map generatedClasses = new HashMap();
    protected BcelObjectType delegateForCurrentClass;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$tools$WeavingAdaptor == null ? (class$org$aspectj$weaver$tools$WeavingAdaptor = WeavingAdaptor.class$("org.aspectj.weaver.tools.WeavingAdaptor")) : class$org$aspectj$weaver$tools$WeavingAdaptor);
    static /* synthetic */ Class class$org$aspectj$weaver$tools$WeavingAdaptor;

    protected WeavingAdaptor() {
    }

    public WeavingAdaptor(WeavingClassLoader loader) {
        this.generatedClassHandler = loader;
        this.init(this.getFullClassPath((ClassLoader)((Object)loader)), this.getFullAspectPath((ClassLoader)((Object)loader)));
    }

    public WeavingAdaptor(GeneratedClassHandler handler, URL[] classURLs, URL[] aspectURLs) {
        this.generatedClassHandler = handler;
        this.init(FileUtil.makeClasspath(classURLs), FileUtil.makeClasspath(aspectURLs));
    }

    private List getFullClassPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            } else {
                this.warn("cannot determine classpath");
            }
            loader = loader.getParent();
        }
        list.addAll(0, WeavingAdaptor.makeClasspath(System.getProperty("sun.boot.class.path")));
        return list;
    }

    private List getFullAspectPath(ClassLoader loader) {
        LinkedList list = new LinkedList();
        while (loader != null) {
            if (loader instanceof WeavingClassLoader) {
                URL[] urls = ((WeavingClassLoader)((Object)loader)).getAspectURLs();
                list.addAll(0, FileUtil.makeClasspath(urls));
            }
            loader = loader.getParent();
        }
        return list;
    }

    private static boolean getVerbose() {
        return Boolean.getBoolean(WEAVING_ADAPTOR_VERBOSE);
    }

    private void init(List classPath, List aspectPath) {
        this.abortOnError = true;
        this.createMessageHandler();
        this.info("using classpath: " + classPath);
        this.info("using aspectpath: " + aspectPath);
        this.bcelWorld = new BcelWorld(classPath, this.messageHandler, null);
        this.bcelWorld.setXnoInline(false);
        this.bcelWorld.getLint().loadDefaultProperties();
        if (LangUtil.is15VMOrGreater()) {
            this.bcelWorld.setBehaveInJava5Way(true);
        }
        this.weaver = new BcelWeaver(this.bcelWorld);
        this.registerAspectLibraries(aspectPath);
        this.enabled = true;
    }

    protected void createMessageHandler() {
        this.messageHolder = new WeavingAdaptorMessageHolder(new PrintWriter(System.err));
        this.messageHandler = this.messageHolder;
        if (this.verbose) {
            this.messageHandler.dontIgnore(IMessage.INFO);
        }
        if (Boolean.getBoolean(SHOW_WEAVE_INFO_PROPERTY)) {
            this.messageHandler.dontIgnore(IMessage.WEAVEINFO);
        }
        this.info("AspectJ Weaver Version DEVELOPMENT built on Monday Jan 15, 2007 at 13:24:11 GMT");
    }

    protected IMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public IMessageHolder getMessageHolder() {
        return this.messageHolder;
    }

    protected void setMessageHandler(IMessageHandler mh) {
        if (mh instanceof ISupportsMessageContext) {
            ISupportsMessageContext smc = (ISupportsMessageContext)((Object)mh);
            smc.setMessageContext(this);
        }
        if (mh != this.messageHolder) {
            this.messageHolder.setDelegate(mh);
        }
        this.messageHolder.flushMessages();
    }

    protected void disable() {
        if (trace.isTraceEnabled()) {
            trace.enter("disable", this);
        }
        this.enabled = false;
        this.messageHolder.flushMessages();
        if (trace.isTraceEnabled()) {
            trace.exit("disable");
        }
    }

    protected void enable() {
        this.enabled = true;
        this.messageHolder.flushMessages();
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public void addURL(URL url) {
        File libFile = new File(url.getPath());
        try {
            this.weaver.addLibraryJarFile(libFile);
        }
        catch (IOException ex) {
            this.warn("bad library: '" + libFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] weaveClass(String name, byte[] bytes) throws IOException {
        if (trace.isTraceEnabled()) {
            trace.enter("weaveClass", (Object)this, new Object[]{name, bytes});
        }
        if (!this.enabled) {
            if (trace.isTraceEnabled()) {
                trace.exit("weaveClass", false);
            }
            return bytes;
        }
        try {
            this.delegateForCurrentClass = null;
            name = name.replace('/', '.');
            if (this.couldWeave(name, bytes)) {
                if (this.accept(name, bytes)) {
                    this.debug("weaving '" + name + "'");
                    bytes = this.getWovenBytes(name, bytes);
                } else if (this.shouldWeaveAnnotationStyleAspect(name, bytes)) {
                    this.debug("weaving '" + name + "'");
                    bytes = this.getAtAspectJAspectBytes(name, bytes);
                } else {
                    this.debug("not weaving '" + name + "'");
                }
            } else {
                this.debug("cannot weave '" + name + "'");
            }
        }
        finally {
            this.delegateForCurrentClass = null;
        }
        if (trace.isTraceEnabled()) {
            trace.exit("weaveClass", bytes);
        }
        return bytes;
    }

    private boolean couldWeave(String name, byte[] bytes) {
        return !this.generatedClasses.containsKey(name) && this.shouldWeaveName(name);
    }

    protected boolean accept(String name, byte[] bytes) {
        return true;
    }

    protected boolean shouldDump(String name, boolean before) {
        return false;
    }

    private boolean shouldWeaveName(String name) {
        boolean should = !name.startsWith("org.aspectj.") && !name.startsWith("java.") && !name.startsWith("javax.") && !name.startsWith("sun.reflect.");
        return should;
    }

    private boolean shouldWeaveAnnotationStyleAspect(String name, byte[] bytes) {
        if (this.delegateForCurrentClass == null) {
            this.ensureDelegateInitialized(name, bytes);
        }
        return this.delegateForCurrentClass.isAnnotationStyleAspect();
    }

    protected void ensureDelegateInitialized(String name, byte[] bytes) {
        if (this.delegateForCurrentClass == null) {
            this.delegateForCurrentClass = ((BcelWorld)this.weaver.getWorld()).addSourceObjectType(Utility.makeJavaClass(name, bytes));
        }
    }

    private byte[] getWovenBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private byte[] getAtAspectJAspectBytes(String name, byte[] bytes) throws IOException {
        WeavingClassFileProvider wcp = new WeavingClassFileProvider(name, bytes);
        wcp.setApplyAtAspectJMungersOnly();
        this.weaver.weave(wcp);
        return wcp.getBytes();
    }

    private void registerAspectLibraries(List aspectPath) {
        Iterator i = aspectPath.iterator();
        while (i.hasNext()) {
            String libName = (String)i.next();
            this.addAspectLibrary(libName);
        }
        this.weaver.prepareForWeave();
    }

    private void addAspectLibrary(String aspectLibraryName) {
        File aspectLibrary = new File(aspectLibraryName);
        if (aspectLibrary.isDirectory() || FileUtil.isZipFile(aspectLibrary)) {
            try {
                this.info("adding aspect library: '" + aspectLibrary + "'");
                this.weaver.addLibraryJarFile(aspectLibrary);
            }
            catch (IOException ex) {
                this.error("exception adding aspect library: '" + ex + "'");
            }
        } else {
            this.error("bad aspect library: '" + aspectLibrary + "'");
        }
    }

    private static List makeClasspath(String cp) {
        ArrayList<String> ret = new ArrayList<String>();
        if (cp != null) {
            StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                ret.add(tok.nextToken());
            }
        }
        return ret;
    }

    protected boolean debug(String message) {
        return MessageUtil.debug(this.messageHandler, message);
    }

    protected boolean info(String message) {
        return MessageUtil.info(this.messageHandler, message);
    }

    protected boolean warn(String message) {
        return MessageUtil.warn(this.messageHandler, message);
    }

    protected boolean warn(String message, Throwable th) {
        return this.messageHandler.handleMessage(new Message(message, IMessage.WARNING, th, null));
    }

    protected boolean error(String message) {
        return MessageUtil.error(this.messageHandler, message);
    }

    protected boolean error(String message, Throwable th) {
        return this.messageHandler.handleMessage(new Message(message, IMessage.ERROR, th, null));
    }

    public String getContextId() {
        return "WeavingAdaptor";
    }

    protected void dump(String name, byte[] b, boolean before) {
        String className;
        String dirName = "_ajdump";
        if (before) {
            dirName = dirName + File.separator + "_before";
        }
        File dir = (className = name.replace('.', '/')).indexOf(47) > 0 ? new File(dirName + File.separator + className.substring(0, className.lastIndexOf(47))) : new File(dirName);
        dir.mkdirs();
        String fileName = dirName + File.separator + className + ".class";
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(b);
            os.close();
        }
        catch (IOException ex) {
            this.warn("unable to dump class " + name + " in directory " + dirName, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WeavingClassFileProvider
    implements IClassFileProvider {
        private UnwovenClassFile unwovenClass;
        private List unwovenClasses = new ArrayList();
        private UnwovenClassFile wovenClass;
        private boolean isApplyAtAspectJMungersOnly = false;

        public WeavingClassFileProvider(String name, byte[] bytes) {
            WeavingAdaptor.this.ensureDelegateInitialized(name, bytes);
            this.unwovenClass = new UnwovenClassFile(name, WeavingAdaptor.this.delegateForCurrentClass.getResolvedTypeX().getName(), bytes);
            this.unwovenClasses.add(this.unwovenClass);
            if (WeavingAdaptor.this.shouldDump(name.replace('/', '.'), true)) {
                WeavingAdaptor.this.dump(name, bytes, true);
            }
        }

        public void setApplyAtAspectJMungersOnly() {
            this.isApplyAtAspectJMungersOnly = true;
        }

        public boolean isApplyAtAspectJMungersOnly() {
            return this.isApplyAtAspectJMungersOnly;
        }

        public byte[] getBytes() {
            if (this.wovenClass != null) {
                return this.wovenClass.getBytes();
            }
            return this.unwovenClass.getBytes();
        }

        public Iterator getClassFileIterator() {
            return this.unwovenClasses.iterator();
        }

        public IWeaveRequestor getRequestor() {
            return new IWeaveRequestor(){

                public void acceptResult(UnwovenClassFile result) {
                    if (WeavingClassFileProvider.this.wovenClass == null) {
                        WeavingClassFileProvider.this.wovenClass = result;
                        String name = result.getClassName();
                        if (WeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                            WeavingAdaptor.this.dump(name, result.getBytes(), false);
                        }
                    } else {
                        String className = result.getClassName();
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClasses.put(className, result);
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClasses.put(WeavingClassFileProvider.this.wovenClass.getClassName(), result);
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.generatedClassHandler.acceptClass(className, result.getBytes());
                    }
                }

                public void processingReweavableState() {
                }

                public void addingTypeMungers() {
                }

                public void weavingAspects() {
                }

                public void weavingClasses() {
                }

                public void weaveCompleted() {
                    ResolvedType.resetPrimitives();
                    if (((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.delegateForCurrentClass != null) {
                        ((WeavingClassFileProvider)WeavingClassFileProvider.this).WeavingAdaptor.this.delegateForCurrentClass.weavingCompleted();
                    }
                    ResolvedType.resetPrimitives();
                }
            };
        }
    }

    protected class WeavingAdaptorMessageWriter
    extends MessageWriter {
        private Set ignoring = new HashSet();
        private IMessage.Kind failKind;

        public WeavingAdaptorMessageWriter(PrintWriter writer) {
            super(writer, true);
            this.ignore(IMessage.WEAVEINFO);
            this.ignore(IMessage.DEBUG);
            this.ignore(IMessage.INFO);
            this.failKind = IMessage.ERROR;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            boolean result = super.handleMessage(message);
            if (WeavingAdaptor.this.abortOnError && 0 <= message.getKind().compareTo(this.failKind)) {
                throw new AbortException(message);
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return null != kind && this.ignoring.contains(kind);
        }

        public void ignore(IMessage.Kind kind) {
            if (null != kind && !this.ignoring.contains(kind)) {
                this.ignoring.add(kind);
            }
        }

        public void dontIgnore(IMessage.Kind kind) {
            if (null != kind) {
                this.ignoring.remove(kind);
            }
        }

        protected String render(IMessage message) {
            return "[" + WeavingAdaptor.this.getContextId() + "] " + super.render(message);
        }
    }

    protected class WeavingAdaptorMessageHolder
    extends MessageHandler {
        private IMessageHandler delegate;
        private List savedMessages;
        protected boolean traceMessages = Boolean.getBoolean("org.aspectj.tracing.messages");

        public WeavingAdaptorMessageHolder(PrintWriter writer) {
            this.delegate = new WeavingAdaptorMessageWriter(writer);
            super.dontIgnore(IMessage.WEAVEINFO);
        }

        private void traceMessage(IMessage message) {
            if (message instanceof WeaveMessage) {
                trace.debug(this.render(message));
            } else if (message.isDebug()) {
                trace.debug(this.render(message));
            } else if (message.isInfo()) {
                trace.info(this.render(message));
            } else if (message.isWarning()) {
                trace.warn(this.render(message), message.getThrown());
            } else if (message.isError()) {
                trace.error(this.render(message), message.getThrown());
            } else if (message.isFailed()) {
                trace.fatal(this.render(message), message.getThrown());
            } else if (message.isAbort()) {
                trace.fatal(this.render(message), message.getThrown());
            } else {
                trace.error(this.render(message), message.getThrown());
            }
        }

        protected String render(IMessage message) {
            return "[" + WeavingAdaptor.this.getContextId() + "] " + message.toString();
        }

        public void flushMessages() {
            if (this.savedMessages == null) {
                this.savedMessages = new ArrayList();
                this.savedMessages.addAll(super.getUnmodifiableListView());
                this.clearMessages();
                Iterator iter = this.savedMessages.iterator();
                while (iter.hasNext()) {
                    IMessage message = (IMessage)iter.next();
                    this.delegate.handleMessage(message);
                }
            }
        }

        public void setDelegate(IMessageHandler messageHandler) {
            this.delegate = messageHandler;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            if (this.traceMessages) {
                this.traceMessage(message);
            }
            super.handleMessage(message);
            if (WeavingAdaptor.this.abortOnError && 0 <= message.getKind().compareTo(IMessage.ERROR)) {
                throw new AbortException(message);
            }
            if (this.savedMessages != null) {
                this.delegate.handleMessage(message);
            }
            return true;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return this.delegate.isIgnoring(kind);
        }

        public void dontIgnore(IMessage.Kind kind) {
            if (null != kind && this.delegate != null) {
                this.delegate.dontIgnore(kind);
            }
        }

        public void ignore(IMessage.Kind kind) {
            if (null != kind && this.delegate != null) {
                this.delegate.ignore(kind);
            }
        }

        public List getUnmodifiableListView() {
            ArrayList allMessages = new ArrayList();
            allMessages.addAll(this.savedMessages);
            allMessages.addAll(super.getUnmodifiableListView());
            return allMessages;
        }
    }
}

