/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.util.FileUtil;

public class StatefulNameEnvironment
implements INameEnvironment {
    private Map classesFromName;
    private Map inflatedClassFilesCache;
    private Set packageNames;
    private AjState state;
    private INameEnvironment baseEnvironment;

    public StatefulNameEnvironment(INameEnvironment baseEnvironment, Map classesFromName, AjState state) {
        this.classesFromName = classesFromName;
        this.inflatedClassFilesCache = new HashMap();
        this.baseEnvironment = baseEnvironment;
        this.state = state;
        this.packageNames = new HashSet();
        Iterator i = classesFromName.keySet().iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            this.addAllPackageNames(className);
        }
    }

    private void addAllPackageNames(String className) {
        int dot = className.indexOf(46);
        while (dot != -1) {
            this.packageNames.add(className.substring(0, dot));
            dot = className.indexOf(46, dot + 1);
        }
    }

    public void cleanup() {
        this.baseEnvironment.cleanup();
        this.classesFromName = Collections.EMPTY_MAP;
        this.packageNames = Collections.EMPTY_SET;
    }

    private NameEnvironmentAnswer findType(String name) {
        IBinaryType seenOnPreviousBuild = this.state.checkPreviousBuild(name);
        if (seenOnPreviousBuild != null) {
            return new NameEnvironmentAnswer(seenOnPreviousBuild, null);
        }
        if (this.inflatedClassFilesCache.containsKey(name)) {
            return (NameEnvironmentAnswer)this.inflatedClassFilesCache.get(name);
        }
        File fileOnDisk = (File)this.classesFromName.get(name);
        if (fileOnDisk == null) {
            return null;
        }
        try {
            byte[] bytes = FileUtil.readAsByteArray((File)fileOnDisk);
            NameEnvironmentAnswer ret = new NameEnvironmentAnswer(new ClassFileReader(bytes, fileOnDisk.getAbsolutePath().toCharArray()), null);
            this.inflatedClassFilesCache.put(name, ret);
            return ret;
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        NameEnvironmentAnswer ret = this.findType(new String(CharOperation.concatWith(packageName, typeName, '.')));
        if (ret != null) {
            return ret;
        }
        return this.baseEnvironment.findType(typeName, packageName);
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        NameEnvironmentAnswer ret = this.findType(new String(CharOperation.concatWith(compoundName, '.')));
        if (ret != null) {
            return ret;
        }
        return this.baseEnvironment.findType(compoundName);
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        if (this.baseEnvironment.isPackage(parentPackageName, packageName)) {
            return true;
        }
        String fullPackageName = new String(CharOperation.concatWith(parentPackageName, packageName, '.'));
        return this.packageNames.contains(fullPackageName);
    }
}

