/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public ReferenceBinding sourceType;
    public int position;

    public CaptureBinding(WildcardBinding wildcard, ReferenceBinding sourceType, int position) {
        super(TypeConstants.WILDCARD_CAPTURE_NAME, null, 0);
        this.wildcard = wildcard;
        this.modifiers = 0x40000001;
        this.fPackage = wildcard.fPackage;
        this.sourceType = sourceType;
        this.position = position;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        if (isLeaf) {
            buffer.append(this.sourceType.computeUniqueKey(false));
            buffer.append('&');
        }
        buffer.append(TypeConstants.WILDCARD_CAPTURE);
        buffer.append(this.wildcard.computeUniqueKey(false));
        buffer.append(this.position);
        buffer.append(';');
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    public String debugName() {
        if (this.wildcard != null) {
            return String.valueOf(String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME)) + this.wildcard.debugName();
        }
        return super.debugName();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(TypeConstants.WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(ParameterizedTypeBinding capturedParameterizedType) {
        int length;
        ReferenceBinding[] originalVariableInterfaces;
        ReferenceBinding[] substitutedVariableInterfaces;
        TypeVariableBinding wildcardVariable = this.wildcard.typeVariable();
        ReferenceBinding originalVariableSuperclass = wildcardVariable.superclass;
        ReferenceBinding substitutedVariableSuperclass = (ReferenceBinding)Scope.substitute((Substitution)capturedParameterizedType, originalVariableSuperclass);
        if (substitutedVariableSuperclass == this) {
            substitutedVariableSuperclass = originalVariableSuperclass;
        }
        if ((substitutedVariableInterfaces = Scope.substitute((Substitution)capturedParameterizedType, originalVariableInterfaces = wildcardVariable.superInterfaces())) != originalVariableInterfaces) {
            int i = 0;
            length = substitutedVariableInterfaces.length;
            while (i < length) {
                if (substitutedVariableInterfaces[i] == this) {
                    substitutedVariableInterfaces[i] = originalVariableInterfaces[i];
                }
                ++i;
            }
        }
        TypeBinding originalWildcardBound = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                if (this.wildcard.bound.isInterface()) {
                    this.superclass = substitutedVariableSuperclass;
                    if (substitutedVariableInterfaces == TypeConstants.NoSuperInterfaces) {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)originalWildcardBound};
                    } else {
                        length = substitutedVariableInterfaces.length;
                        ReferenceBinding[] referenceBindingArray = substitutedVariableInterfaces;
                        substitutedVariableInterfaces = new ReferenceBinding[length + 1];
                        System.arraycopy(referenceBindingArray, 0, substitutedVariableInterfaces, 1, length);
                        substitutedVariableInterfaces[0] = (ReferenceBinding)originalWildcardBound;
                        this.superInterfaces = Scope.greaterLowerBound(substitutedVariableInterfaces);
                    }
                } else {
                    this.superclass = this.wildcard.bound.isArrayType() ? substitutedVariableSuperclass : (ReferenceBinding)originalWildcardBound;
                    this.superInterfaces = substitutedVariableInterfaces;
                }
                this.firstBound = originalWildcardBound;
                if ((originalWildcardBound.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.superclass = substitutedVariableSuperclass;
                this.superInterfaces = substitutedVariableInterfaces;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.superclass = substitutedVariableSuperclass;
                if (wildcardVariable.firstBound == substitutedVariableSuperclass || originalWildcardBound == substitutedVariableSuperclass) {
                    this.firstBound = substitutedVariableSuperclass;
                }
                this.superInterfaces = substitutedVariableInterfaces;
                this.lowerBound = originalWildcardBound;
                if ((originalWildcardBound.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
    }

    public boolean isCapture() {
        return true;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(otherType)) {
            return true;
        }
        if (otherType.isWildcard()) {
            return ((WildcardBinding)otherType).boundCheck(this);
        }
        return false;
    }

    public char[] readableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.readableName());
        }
        return super.readableName();
    }

    public char[] shortReadableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.shortReadableName());
        }
        return super.shortReadableName();
    }

    public String toString() {
        if (this.wildcard != null) {
            return String.valueOf(String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME)) + this.wildcard.toString();
        }
        return super.toString();
    }
}

