/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.exports.AJBuildScriptGenerator;
import org.eclipse.ajdt.internal.ui.ajde.UIComplierConfiguration;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;

public class BuildPluginAction
extends BaseBuildAction {
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AJBuildScriptGenerator generator = new AJBuildScriptGenerator();
        AJBuildScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        AJBuildScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        AJBuildScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        IProject project = this.fManifestFile.getProject();
        List inpath = this.getInpath(project);
        List aspectpath = this.getAspectpath(project);
        generator.setInpath(inpath);
        generator.setAspectpath(aspectpath);
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(project.getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(url);
        generator.setPDEState(TargetPlatformHelper.getState());
        generator.setNextId(TargetPlatformHelper.getPDEState().getNextId());
        generator.setStateExtraData(TargetPlatformHelper.getBundleClasspaths((PDEState)TargetPlatformHelper.getPDEState()), TargetPlatformHelper.getPatchMap((PDEState)TargetPlatformHelper.getPDEState()));
        generator.setBuildingOSGi(true);
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
        generator.setElements(new String[]{"plugin@" + model.getPluginBase().getId()});
        generator.generate();
    }

    private List getAspectpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectAspectPath((IProject)project);
        UIComplierConfiguration adapter = (UIComplierConfiguration)AspectJUIPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
        String aspectPath = adapter.expandVariables(v[0], v[2]);
        if ((aspectPath = adapter.fullyQualifyPathEntries(aspectPath)).length() > 0) {
            String[] entries = aspectPath.split(File.pathSeparator);
            ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
            return entryList;
        }
        return null;
    }

    private List getInpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectInPath((IProject)project);
        UIComplierConfiguration adapter = (UIComplierConfiguration)AspectJUIPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
        String inPath = adapter.expandVariables(v[0], v[2]);
        if ((inPath = adapter.fullyQualifyPathEntries(inPath)).length() > 0) {
            String[] entries = inPath.split(File.pathSeparator);
            ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
            return entryList;
        }
        return null;
    }
}

