/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    int mergedInitStateIndex = -1;

    public DoStatement(Expression condition, Statement action, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.condition = condition;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, currentScope);
        Constant cst = this.condition.constant;
        boolean isConditionTrue = cst != ASTNode.NotAConstant && cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != ASTNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != ASTNode.NotAConstant && !cst.booleanValue();
        int previousMode = flowInfo.reachMode();
        FlowInfo actionInfo = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        if (!(this.action == null || this.action.isEmptyBlock() || (actionInfo = this.action.analyseCode(currentScope, loopingContext, actionInfo)).isReachable() || loopingContext.initsOnContinue.isReachable())) {
            this.continueLabel = null;
        }
        actionInfo.setReachMode(previousMode);
        actionInfo = this.condition.analyseCode(currentScope, loopingContext, this.action == null ? actionInfo : actionInfo.mergedWith(loopingContext.initsOnContinue));
        if (!isConditionOptimizedFalse && this.continueLabel != null) {
            loopingContext.complainOnDeferredChecks(currentScope, actionInfo);
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, isConditionOptimizedTrue, actionInfo.initsWhenFalse().addInitializationsFrom(flowInfo), false, !isConditionTrue);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        Label actionLabel = new Label(codeStream);
        actionLabel.place();
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.action != null) {
            this.action.generateCode(currentScope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(currentScope, codeStream, actionLabel, null, true);
        }
        this.breakLabel.place();
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output).append("do");
        if (this.action == null) {
            output.append(" ;\n");
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output).append('\n');
        }
        output.append("while (");
        return this.condition.printExpression(0, output).append(");");
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BaseTypes.BooleanBinding);
        this.condition.computeConversion(scope, type, type);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.action != null) {
                this.action.traverse(visitor, scope);
            }
            this.condition.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

