/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.diff.ChangesView;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ComparisonReferenceDropDownAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public ComparisonReferenceDropDownAction() {
        this.setText(UIMessages.changesView_ComparisonReference);
        this.setToolTipText(UIMessages.changesView_ComparisonReference);
        this.setImageDescriptor(AspectJImages.COMPARISON.getImageDescriptor());
        this.setMenuCreator(this);
    }

    public void dispose() {
        this.disposeMenu();
    }

    void disposeMenu() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        this.fMenu = new Menu(parent);
        IProject project = this.getProjectForActiveEditor();
        if (project != null) {
            SetComparisonReferenceAction action = new SetComparisonReferenceAction(project, UIMessages.changesView_ComparisonReference_last_inc);
            this.addActionToMenu(this.fMenu, action, project);
            action = new SetComparisonReferenceAction(project, UIMessages.changesView_ComparisonReference_last_full);
            this.addActionToMenu(this.fMenu, action, project);
            new MenuItem(this.fMenu, 2);
            String[] maps = this.getMapFileNames();
            int i = 0;
            while (i < maps.length) {
                action = new SetComparisonReferenceAction(project, maps[i]);
                this.addActionToMenu(this.fMenu, action, project);
                ++i;
            }
        } else {
            MenuItem m = new MenuItem(this.fMenu, 16);
            m.setText(UIMessages.changesView_ComparisonReference_no_project);
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action, IProject project) {
        String txt = action.getText();
        if (txt.equals(UIMessages.changesView_ComparisonReference_last_full)) {
            txt = "last full build";
        } else if (txt.equals(UIMessages.changesView_ComparisonReference_last_inc)) {
            txt = "last build";
        }
        action.setChecked(txt.equals(ChangesView.getReferencePoint(project)));
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private IProject getProjectForActiveEditor() {
        IResource resource;
        IWorkbenchWindow window = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(classNotFoundException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return resource.getProject();
    }

    private String[] getMapFileNames() {
        ArrayList<String> mapNames = new ArrayList<String>();
        IProject project = this.getProjectForActiveEditor();
        if (project != null) {
            try {
                IResource[] files = project.members();
                int i = 0;
                while (i < files.length) {
                    if (files[i].getType() == 1 && "ajmap".equals(files[i].getFileExtension()) && files[i].exists()) {
                        mapNames.add(files[i].getName());
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, ajc$tjp_3);
            }
        }
        return mapNames.toArray(new String[0]);
    }

    static {
        Factory factory = new Factory("ComparisonReferenceDropDownAction.java", Class.forName("org.eclipse.ajdt.internal.ui.diff.ComparisonReferenceDropDownAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.ComparisonReferenceDropDownAction-java.lang.ClassNotFoundException-<missing>-"), 116);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProjectForActiveEditor-org.eclipse.ajdt.internal.ui.diff.ComparisonReferenceDropDownAction----org.eclipse.core.resources.IProject-"), 99);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.ComparisonReferenceDropDownAction-org.eclipse.core.runtime.CoreException-<missing>-"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getMapFileNames-org.eclipse.ajdt.internal.ui.diff.ComparisonReferenceDropDownAction----[Ljava.lang.String;-"), 123);
    }

    private class SetComparisonReferenceAction
    extends Action {
        private IProject fProject;

        public SetComparisonReferenceAction(IProject project, String label) {
            super("", 8);
            this.setText(label);
            this.fProject = project;
        }

        public void run() {
            String txt = this.getText();
            if (txt.equals(UIMessages.changesView_ComparisonReference_last_full)) {
                txt = "last full build";
            } else if (txt.equals(UIMessages.changesView_ComparisonReference_last_inc)) {
                txt = "last build";
            }
            ChangesView.setReferencePoint(this.fProject, txt);
            ChangesView.refresh(false, this.fProject);
        }
    }
}

