/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.visualiser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.ajdt.core.javaelements.IAJCodeElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.markerImpl.ResourceMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.simpleImpl.StealthMarkupKind;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IActionBars;

public class AJDTMarkupProvider
extends SimpleMarkupProvider {
    private IAction hideErrorsAction;
    private Action hideWarningsAction;
    private boolean hideErrors;
    private boolean hideWarnings;
    private Map kindMap;
    protected static final String aspectJErrorKind = "declare error";
    protected static final String aspectJWarningKind = "declare warning";
    protected Map savedColours;
    private static Color aspectJErrorColor = new Color(null, new RGB(228, 5, 64));
    private static Color aspectJWarningColor = new Color(null, new RGB(255, 206, 90));
    private Action resetColorMemoryAction;
    private static String resetColorMemoryID = "ResetColorMemoryUniqueID32dfnio239";
    private IPreferenceStore prefs = AspectJUIPlugin.getDefault().getPreferenceStore();
    private static final String allPrefereceKeys = "AJDTVisualiserMarkupProvider.allPrefereceKeys";

    public List getMemberMarkups(IMember member) {
        List markupList;
        if (this.kindMap == null) {
            this.updateModel();
        }
        if ((markupList = super.getMemberMarkups(member)) != null) {
            return this.checkErrorsAndWarnings(markupList);
        }
        return null;
    }

    private void updateModel() {
        List allRelationships;
        IJavaProject jp;
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider && (jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null && (allRelationships = AJModel.getInstance().getAllRelationships(jp.getProject(), new AJRelationshipType[]{AJRelationshipManager.ADVISED_BY, AJRelationshipManager.ANNOTATED_BY, AJRelationshipManager.ASPECT_DECLARATIONS, AJRelationshipManager.MATCHES_DECLARE})) != null) {
            Iterator iter = allRelationships.iterator();
            while (iter.hasNext()) {
                IJavaElement compilationUnitAncestor;
                String aspectFullName;
                String aspectName;
                ArrayList<IMarkupKind> kinds = new ArrayList<IMarkupKind>();
                AJRelationship element = (AJRelationship)iter.next();
                IJavaElement target = element.getTarget();
                if (!(target instanceof IAJCodeElement)) {
                    IJavaElement enclosingAspect = element.getTarget().getAncestor(7);
                    aspectName = enclosingAspect.getElementName();
                    IJavaElement loopElement = enclosingAspect;
                    while (loopElement.getParent() instanceof IType) {
                        loopElement = loopElement.getParent();
                        aspectName = String.valueOf(loopElement.getElementName()) + "." + aspectName;
                    }
                    aspectFullName = aspectName;
                    String aspectPackageName = enclosingAspect.getAncestor(4).getElementName();
                    if (!aspectPackageName.equals("")) {
                        aspectFullName = String.valueOf(aspectPackageName) + "." + aspectFullName;
                    }
                } else {
                    aspectFullName = target.getElementName();
                    String[] parts = aspectFullName.split(" ");
                    String aNameWithExtension = parts[parts.length - 1];
                    aspectName = aNameWithExtension.indexOf(46) != -1 ? aNameWithExtension.substring(0, aNameWithExtension.lastIndexOf(46)) : aNameWithExtension;
                }
                int lineNum = AJModel.getInstance().getJavaElementLineNumber(element.getSource());
                if (element.getSource() == null || (compilationUnitAncestor = element.getSource().getAncestor(5)) == null) continue;
                String memberName = compilationUnitAncestor.getElementName();
                memberName = memberName.substring(0, memberName.lastIndexOf("."));
                String packageName = element.getSource().getAncestor(4).getElementName();
                if (!packageName.equals("")) {
                    memberName = String.valueOf(packageName) + "." + memberName;
                }
                Object markupKind = null;
                if (this.kindMap == null) {
                    this.kindMap = new HashMap();
                }
                if (element.getRelationship().equals(AJRelationshipManager.MATCHES_DECLARE)) {
                    String sourceName = element.getTarget().getElementName();
                    boolean errorKind = sourceName.startsWith(aspectJErrorKind);
                    if (this.kindMap.get(String.valueOf(sourceName) + ":::" + aspectFullName) instanceof IMarkupKind) {
                        markupKind = (IMarkupKind)this.kindMap.get(String.valueOf(sourceName) + ":::" + aspectFullName);
                    } else {
                        markupKind = new ErrorOrWarningMarkupKind(String.valueOf(sourceName) + ":::" + aspectName, errorKind);
                        this.kindMap.put(String.valueOf(sourceName) + ":::" + aspectFullName, markupKind);
                    }
                } else if (this.kindMap.get(aspectFullName) instanceof IMarkupKind) {
                    markupKind = (IMarkupKind)this.kindMap.get(aspectFullName);
                } else {
                    markupKind = new SimpleMarkupKind(aspectName, aspectFullName);
                    this.kindMap.put(aspectFullName, markupKind);
                }
                kinds.add((IMarkupKind)markupKind);
                Stripe stripe = new Stripe(kinds, lineNum, 1);
                this.addMarkup(memberName, stripe);
            }
        }
        this.processMarkups();
    }

    private List checkErrorsAndWarnings(List stripes) {
        ArrayList<Stripe> returningStripes = new ArrayList<Stripe>();
        Iterator iter = stripes.iterator();
        while (iter.hasNext()) {
            Stripe stripe = (Stripe)iter.next();
            ArrayList kinds = new ArrayList(stripe.getKinds());
            Iterator iterator = kinds.iterator();
            while (iterator.hasNext()) {
                String name;
                String[] parts;
                IMarkupKind kind = (IMarkupKind)iterator.next();
                if (!(kind instanceof StealthMarkupKind) || (parts = (name = kind.getName()).split(":::")).length <= 1) continue;
                String eOrWKind = parts[0];
                if (eOrWKind.startsWith(aspectJErrorKind) && this.hideErrors) {
                    iterator.remove();
                    continue;
                }
                if (eOrWKind.startsWith(aspectJWarningKind) && this.hideWarnings) {
                    iterator.remove();
                    continue;
                }
                String aspectName = parts[1];
                if (VisualiserPlugin.menu == null || VisualiserPlugin.menu.getActive(aspectName)) continue;
                iterator.remove();
            }
            if (kinds.size() <= 0) continue;
            Stripe newStripe = new Stripe(kinds, stripe.getOffset(), stripe.getDepth());
            returningStripes.add(newStripe);
        }
        return returningStripes;
    }

    public Color getColorFor(IMarkupKind kind) {
        if (kind.getName().startsWith(aspectJErrorKind)) {
            return aspectJErrorColor;
        }
        if (kind.getName().startsWith(aspectJWarningKind)) {
            return aspectJWarningColor;
        }
        Color savedColor = this.getSavedColour(kind.getFullName());
        if (savedColor == null) {
            return super.getColorFor(kind);
        }
        return savedColor;
    }

    public void setColorFor(IMarkupKind kind, Color color) {
        super.setColorFor(kind, color);
        this.saveColourForAspect(kind.getFullName(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public SortedSet getAllMarkupKinds() {
        if (this.kindMap == null) {
            this.updateModel();
        }
        TreeSet kinds = new TreeSet();
        if (this.kindMap != null) {
            kinds.addAll(this.kindMap.values());
        }
        return kinds;
    }

    public boolean processMouseclick(IMember member, Stripe stripe, int buttonClicked) {
        if (buttonClicked == 1) {
            IResource res;
            if (member instanceof JDTMember) {
                IJavaElement jEl = ((JDTMember)member).getResource();
                if (jEl != null) {
                    JDTUtils.openInEditor((IResource)jEl.getResource(), (int)stripe.getOffset());
                }
            } else if (member instanceof ResourceMember && (res = ((ResourceMember)member).getResource()) != null) {
                JDTUtils.openInEditor((IResource)res, (int)stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    protected void saveColourForAspect(String aspectName, int r, int g, int b) {
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
            String allColourKeys;
            IProject currentProject = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject().getProject();
            String key = currentProject + ":::" + aspectName;
            if (this.prefs.getString(key) == null) {
                this.prefs.setDefault(key, "");
            }
            if ((allColourKeys = this.prefs.getString(allPrefereceKeys)) == null) {
                this.prefs.putValue(allPrefereceKeys, key);
                this.prefs.setDefault(allPrefereceKeys, "");
            } else {
                allColourKeys = String.valueOf(allColourKeys) + "," + key;
                this.prefs.putValue(allPrefereceKeys, allColourKeys);
            }
            String value = String.valueOf(r) + "," + g + "," + b;
            this.prefs.setValue(key, value);
            if (this.savedColours == null) {
                this.savedColours = new HashMap();
            }
            this.savedColours.remove(key);
            this.savedColours.put(key, value);
        }
    }

    public void resetMarkupsAndKinds() {
        super.resetMarkupsAndKinds();
        this.kindMap = null;
    }

    protected Color getSavedColour(String aspectName) {
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
            String value;
            IProject currentProject = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject().getProject();
            String key = currentProject + ":::" + aspectName;
            if (this.savedColours == null) {
                this.savedColours = new HashMap();
            }
            if ((value = (String)this.savedColours.get(key)) == null) {
                IPreferenceStore prefs = AspectJUIPlugin.getDefault().getPreferenceStore();
                value = prefs.getString(key);
                this.savedColours.put(key, value);
            }
            if (value != null && value != "") {
                String[] rgb = value.split(",");
                if (rgb.length != 3) {
                    return null;
                }
                int r = Integer.parseInt(rgb[0]);
                int g = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                return new Color(null, new RGB(r, g, b));
            }
        }
        return null;
    }

    public void activate() {
        if (VisualiserPlugin.menu != null) {
            this.resetColorMemoryAction = new Action(){

                public void run() {
                    AJDTMarkupProvider.this.resetSavedColours();
                    VisualiserPlugin.refresh();
                }
            };
            this.resetColorMemoryAction.setImageDescriptor(AspectJImages.RESET_COLOURS.getImageDescriptor());
            this.resetColorMemoryAction.setText(UIMessages.ResetColorMemory);
            this.resetColorMemoryAction.setId(resetColorMemoryID);
            this.hideErrorsAction = new Action(){

                public int getStyle() {
                    return 2;
                }

                public void run() {
                    AJDTMarkupProvider.this.hideErrors = AJDTMarkupProvider.this.hideErrorsAction.isChecked();
                    VisualiserPlugin.refresh();
                }
            };
            this.hideErrorsAction.setImageDescriptor(AspectJImages.HIDE_ERRORS.getImageDescriptor());
            this.hideErrorsAction.setToolTipText(UIMessages.HideErrors);
            this.hideWarningsAction = new Action(){

                public int getStyle() {
                    return 2;
                }

                public void run() {
                    AJDTMarkupProvider.this.hideWarnings = AJDTMarkupProvider.this.hideWarningsAction.isChecked();
                    VisualiserPlugin.refresh();
                }
            };
            this.hideWarningsAction.setImageDescriptor(AspectJImages.HIDE_WARNINGS.getImageDescriptor());
            this.hideWarningsAction.setToolTipText(UIMessages.HideWarnings);
            IActionBars menuActionBars = VisualiserPlugin.menu.getViewSite().getActionBars();
            IToolBarManager toolBarManager = menuActionBars.getToolBarManager();
            toolBarManager.add(this.hideErrorsAction);
            toolBarManager.add((IAction)this.hideWarningsAction);
            toolBarManager.update(true);
            IMenuManager menuManager = menuActionBars.getMenuManager();
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.resetColorMemoryAction);
        }
    }

    protected void resetSavedColours() {
        String colourKeys = this.prefs.getString(allPrefereceKeys);
        if (colourKeys != null && colourKeys != "") {
            String[] keys = colourKeys.split(",");
            int i = 0;
            while (i < keys.length) {
                this.prefs.setToDefault(keys[i]);
                ++i;
            }
            this.prefs.setToDefault(allPrefereceKeys);
        }
        this.savedColours = new HashMap();
        super.resetColours();
    }

    public void deactivate() {
        super.deactivate();
        if (VisualiserPlugin.menu != null) {
            IActionBars menuActionBars = VisualiserPlugin.menu.getViewSite().getActionBars();
            IToolBarManager toolBarManager = menuActionBars.getToolBarManager();
            toolBarManager.removeAll();
            toolBarManager.update(true);
            IMenuManager menuManager = menuActionBars.getMenuManager();
            menuManager.remove(resetColorMemoryID);
            menuManager.update(true);
        }
    }

    private class ErrorOrWarningMarkupKind
    extends StealthMarkupKind {
        private boolean errorKind;
        private String declaringAspect;

        public ErrorOrWarningMarkupKind(String name, boolean errorKind) {
            super(name);
            this.errorKind = errorKind;
            String[] nameParts = name.split(":::");
            if (nameParts.length > 1) {
                this.declaringAspect = nameParts[1];
            }
        }

        public String toString() {
            if (this.errorKind) {
                return String.valueOf(UIMessages.AspectJError) + ": " + this.declaringAspect;
            }
            return String.valueOf(UIMessages.AspectJWarning) + ": " + this.declaringAspect;
        }
    }
}

