/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.jdt.core.IJavaElement;

public class ModelComparison {
    private boolean propagateUp;

    public ModelComparison(boolean propagateUp) {
        this.propagateUp = propagateUp;
    }

    public List[] compareProjects(AJProjectModel fromModel, AJProjectModel toModel) {
        AJRelationship rel;
        List fromRels = fromModel.getAllRelationships(AJRelationshipManager.getAllRelationshipTypes());
        List toRels = toModel.getAllRelationships(AJRelationshipManager.getAllRelationshipTypes());
        ArrayList<AJRelationship> addedList = new ArrayList<AJRelationship>();
        ArrayList<AJRelationship> removedList = new ArrayList<AJRelationship>();
        Iterator iter = fromRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            if (this.removeMatchingRel(toRels, rel)) continue;
            removedList.add(this.propagateRel(rel));
        }
        iter = toRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            addedList.add(this.propagateRel(rel));
        }
        return new List[]{addedList, removedList};
    }

    public List[] compareElements(AJProjectModel fromModel, AJProjectModel toModel, IJavaElement fromEl, IJavaElement toEl) {
        AJRelationship rel;
        List fromRels = fromModel.getAllRelationships(AJRelationshipManager.getAllRelationshipTypes());
        List toRels = toModel.getAllRelationships(AJRelationshipManager.getAllRelationshipTypes());
        ArrayList<AJRelationship> addedList = new ArrayList<AJRelationship>();
        ArrayList<AJRelationship> removedList = new ArrayList<AJRelationship>();
        HashSet<String> fromTargets = new HashSet<String>();
        HashSet<String> toTargets = new HashSet<String>();
        Iterator iter = fromRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            if (!this.matchJavaElements(fromEl, rel.getSource())) continue;
            fromTargets.add(this.propagate(rel.getTarget()).getHandleIdentifier());
            removedList.add(this.propagateRel(rel));
        }
        iter = toRels.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            if (!this.matchJavaElements(toEl, rel.getSource())) continue;
            String target = this.propagate(rel.getTarget()).getHandleIdentifier();
            toTargets.add(target);
            if (fromTargets.contains(target)) continue;
            addedList.add(this.propagateRel(rel));
        }
        iter = removedList.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            if (!toTargets.contains(this.propagate(rel.getTarget()).getHandleIdentifier())) continue;
            iter.remove();
        }
        return new List[]{addedList, removedList};
    }

    private IJavaElement propagate(IJavaElement el) {
        if (this.propagateUp && el instanceof AJCodeElement) {
            return el.getParent();
        }
        return el;
    }

    private AJRelationship propagateRel(AJRelationship rel) {
        rel.setSource(this.propagate(rel.getSource()));
        rel.setTarget(this.propagate(rel.getTarget()));
        return rel;
    }

    private boolean matchJavaElements(IJavaElement je1, IJavaElement je2) {
        return this.propagate(je1).getHandleIdentifier().equals(this.propagate(je2).getHandleIdentifier());
    }

    private boolean removeMatchingRel(List list, AJRelationship match) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AJRelationship rel = (AJRelationship)iter.next();
            if (!rel.getRelationship().equals(match.getRelationship()) || !this.matchJavaElements(rel.getSource(), match.getSource()) || !this.matchJavaElements(rel.getTarget(), match.getTarget())) continue;
            list.remove(rel);
            return true;
        }
        return false;
    }
}

