/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;

public class DeclareAnnotationDeclaration
extends DeclareDeclaration {
    private Annotation annotation;

    public DeclareAnnotationDeclaration(CompilationResult result, DeclareAnnotation symbolicDeclare, Annotation annotation) {
        super(result, (Declare)symbolicDeclare);
        this.annotation = annotation;
        this.addAnnotation(annotation);
        if (symbolicDeclare == null) {
            return;
        }
        symbolicDeclare.setAnnotationString(annotation.toString());
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo flowInfo) {
        super.analyseCode(classScope, initializationContext, flowInfo);
        long bits = this.annotation.resolvedType.getAnnotationTagBits();
        if ((bits & 0x400000000L) != 0L) {
            DeclareAnnotation.Kind k = ((DeclareAnnotation)this.declareDecl).getKind();
            if (k.equals((Object)DeclareAnnotation.AT_TYPE) && (bits & 0x2000000000L) != 0L) {
                classScope.problemReporter().disallowedTargetForAnnotation(this.annotation);
            }
            if (k.equals((Object)DeclareAnnotation.AT_FIELD) && (bits & 0x2000000000L) != 0L) {
                classScope.problemReporter().disallowedTargetForAnnotation(this.annotation);
            }
        }
    }

    public Annotation getDeclaredAnnotation() {
        return this.annotation;
    }

    protected boolean shouldDelegateCodeGeneration() {
        return true;
    }

    private void addAnnotation(Annotation ann) {
        if (this.annotations == null) {
            this.annotations = new Annotation[1];
        } else {
            Annotation[] old = this.annotations;
            this.annotations = new Annotation[old.length + 1];
            System.arraycopy(old, 0, this.annotations, 1, old.length);
        }
        this.annotations[0] = ann;
    }

    public void postParse(TypeDeclaration typeDec) {
        super.postParse(typeDec);
        if (this.declareDecl != null) {
            ((DeclareAnnotation)this.declareDecl).setAnnotationMethod(new String(this.selector));
        }
    }
}

