/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.Openable;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        super(hierarchy);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (this.hierarchy.focusType == null || computeSubtypes) {
                SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
                HashMap allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)typeInRegionMonitor);
                this.hierarchy.initialize(allOpenablesInRegion.size());
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
                this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)buildMonitor);
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.flushZipFiles();
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.flushZipFiles();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTypeHierarchyBasedOnRegion(HashMap allOpenablesInRegion, IProgressMonitor monitor) {
        int size = allOpenablesInRegion.size();
        if (size != 0) {
            this.infoToHandle = new HashMap(size);
        }
        Iterator javaProjects = allOpenablesInRegion.keySet().iterator();
        while (javaProjects.hasNext()) {
            Object var7_7;
            ArrayList allOpenables = (ArrayList)allOpenablesInRegion.get(javaProjects.next());
            Openable[] openables = new Openable[allOpenables.size()];
            allOpenables.toArray(openables);
            try {
                if (monitor != null) {
                    monitor.beginTask("", size * 2);
                }
                if (size > 0) {
                    this.hierarchyResolver.resolve(openables, null, monitor);
                }
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            {
                var7_7 = null;
                if (monitor == null) continue;
            }
            monitor.done();
        }
        return;
    }

    private HashMap determineOpenablesInRegion(IProgressMonitor monitor) {
        HashMap hashMap;
        block13: {
            try {
                HashMap allOpenables = new HashMap();
                IJavaElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
                int length = roots.length;
                if (monitor != null) {
                    monitor.beginTask("", length);
                }
                int i = 0;
                while (i < length) {
                    IJavaElement root = roots[i];
                    IJavaProject javaProject = root.getJavaProject();
                    ArrayList<IJavaElement> openables = (ArrayList<IJavaElement>)allOpenables.get(javaProject);
                    if (openables == null) {
                        openables = new ArrayList<IJavaElement>();
                        allOpenables.put(javaProject, openables);
                    }
                    switch (root.getElementType()) {
                        case 2: {
                            this.injectAllOpenablesForJavaProject((IJavaProject)root, openables);
                            break;
                        }
                        case 3: {
                            this.injectAllOpenablesForPackageFragmentRoot((IPackageFragmentRoot)root, openables);
                            break;
                        }
                        case 4: {
                            this.injectAllOpenablesForPackageFragment((IPackageFragment)root, openables);
                            break;
                        }
                        case 5: 
                        case 6: {
                            openables.add(root);
                            break;
                        }
                        case 7: {
                            IType type = (IType)root;
                            if (type.isBinary()) {
                                openables.add(type.getClassFile());
                                break;
                            }
                            openables.add(type.getCompilationUnit());
                            break;
                        }
                    }
                    this.worked(monitor, 1);
                    ++i;
                }
                hashMap = allOpenables;
                Object var10_11 = null;
                if (monitor == null) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var10_12 = null;
                    if (monitor == null) break block14;
                    monitor.done();
                }
                throw throwable;
            }
            monitor.done();
        }
        return hashMap;
    }

    private void injectAllOpenablesForJavaProject(IJavaProject project, ArrayList openables) {
        try {
            IPackageFragmentRoot[] devPathRoots = ((JavaProject)project).getPackageFragmentRoots();
            if (devPathRoots == null) {
                return;
            }
            int j = 0;
            while (j < devPathRoots.length) {
                IPackageFragmentRoot root = devPathRoots[j];
                this.injectAllOpenablesForPackageFragmentRoot(root, openables);
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragment(IPackageFragment packFrag, ArrayList openables) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    ICompilationUnit[] cus = packFrag.getCompilationUnits();
                    int i = 0;
                    int length = cus.length;
                    while (i < length) {
                        openables.add(cus[i]);
                        ++i;
                    }
                } else {
                    IClassFile[] classFiles = packFrag.getClassFiles();
                    int i = 0;
                    int length = classFiles.length;
                    while (i < length) {
                        openables.add(classFiles[i]);
                        ++i;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragmentRoot(IPackageFragmentRoot root, ArrayList openables) {
        try {
            IJavaElement[] packFrags = root.getChildren();
            int k = 0;
            while (k < packFrags.length) {
                IPackageFragment packFrag = (IPackageFragment)packFrags[k];
                this.injectAllOpenablesForPackageFragment(packFrag, openables);
                ++k;
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }
}

