/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.visualiser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTMarkupProvider;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtImpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AJDTContentProvider
extends JDTContentProvider {
    List currentGroups;
    List currentMembers;
    private List includedFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public List getAllGroups() {
        if (this.currentGroups == null) {
            this.updateData();
        }
        return this.currentGroups;
    }

    public List getAllMembers() {
        if (this.currentMembers == null) {
            this.updateData();
        }
        return this.currentMembers;
    }

    public void selectionChanged(IWorkbenchPart workbenchPart, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (!ProviderManager.getContentProvider().equals((Object)this)) {
            return;
        }
        boolean updateRequired = false;
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)firstElement;
            if (this.currentlySelectedJE == javaElement) {
                return;
            }
            this.currentlySelectedJE = javaElement;
            updateRequired = true;
            if (javaElement.getJavaProject() != null) {
                this.setCurrentProject(javaElement.getJavaProject());
            }
        }
        if (updateRequired) {
            this.reset();
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
            ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetMarkupsAndKinds();
        }
        long stime = System.currentTimeMillis();
        ArrayList<JDTGroup> newGroups = new ArrayList<JDTGroup>();
        ArrayList<JDTMember> newMembers = new ArrayList<JDTMember>();
        if (this.currentProject != null) {
            try {
                if (this.currentlySelectedJE instanceof IJavaProject) {
                    IPackageFragment[] packageFragments = ((IJavaProject)this.currentlySelectedJE).getPackageFragments();
                    int i = 0;
                    while (i < packageFragments.length) {
                        if (!packageFragments[i].isReadOnly()) {
                            this.addMembersAndGroups(newGroups, newMembers, packageFragments[i]);
                        }
                        ++i;
                    }
                } else if (this.currentlySelectedJE instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)this.currentlySelectedJE;
                    this.addMembersAndGroups(newGroups, newMembers, packageFragment);
                } else if (this.currentlySelectedJE instanceof ICompilationUnit) {
                    JDTMember member = null;
                    if (this.getIncludedFiles(this.currentProject.getProject()).contains(this.currentlySelectedJE.getResource())) {
                        String memberName = this.currentlySelectedJE.getElementName();
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        } else if (memberName.endsWith(".aj")) {
                            memberName = memberName.substring(0, memberName.length() - 3);
                        }
                        member = new JDTMember(memberName, this.currentlySelectedJE);
                        member.setSize(this.getLength((ICompilationUnit)this.currentlySelectedJE));
                        newMembers.add(member);
                    }
                    if (member != null) {
                        IPackageFragment packageFrag = (IPackageFragment)((ICompilationUnit)this.currentlySelectedJE).getParent();
                        boolean defaultPackage = packageFrag.isDefaultPackage();
                        JDTGroup group = new JDTGroup(packageFrag.getElementName());
                        if (defaultPackage) {
                            group.setName("(default package)");
                            group.setTooltip("(default package)");
                        }
                        if (defaultPackage) {
                            member.setFullName(member.getName());
                        }
                        group.add((IMember)member);
                        newGroups.add(group);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, ajc$tjp_1);
            }
            long etime = System.currentTimeMillis();
            AJLog.log((String)("AJDTContentProvider.updateData() executed - took " + (etime - stime) + "ms"));
        }
        this.currentMembers = newMembers;
        this.currentGroups = newGroups;
    }

    private void addMembersAndGroups(List newGroups, List newMembers, IPackageFragment packageFragment) {
        List classes = this.getMembersForPackage(packageFragment);
        if (classes.size() > 0) {
            boolean defaultPackage = packageFragment.isDefaultPackage();
            JDTGroup group = new JDTGroup(packageFragment.getElementName());
            if (defaultPackage) {
                group.setName("(default package)");
                group.setTooltip("(default package)");
            }
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                Object tempObject = iter.next();
                JDTMember jdtMember = (JDTMember)tempObject;
                group.add((IMember)jdtMember);
                newMembers.add(jdtMember);
                if (!defaultPackage) continue;
                jdtMember.setFullName(jdtMember.getName());
            }
            newGroups.add(group);
        }
    }

    protected void setCurrentProject(IJavaProject newProject) {
        if (this.currentProject == null || !this.currentProject.equals(newProject)) {
            if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
                ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetColours();
            }
            this.currentProject = newProject;
        }
    }

    public void reset() {
        this.currentGroups = null;
        this.currentMembers = null;
        this.includedFiles = null;
    }

    public boolean processMouseclick(IMember member, boolean markupWasClicked, int buttonClicked) {
        IJavaElement jEl;
        if (buttonClicked != 1) {
            return true;
        }
        if (markupWasClicked) {
            return false;
        }
        if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
            JDTUtils.openInEditor((IResource)jEl.getResource(), (int)JDTUtils.getClassDeclLineNum((IJavaElement)jEl));
        }
        return false;
    }

    public List getMembersForPackage(IPackageFragment packageFragment) {
        ArrayList<JDTMember> returningClasses = new ArrayList<JDTMember>();
        try {
            if (this.containsUsefulStuff(packageFragment)) {
                IJavaElement[] javaElements = packageFragment.getChildren();
                int j = 0;
                while (j < javaElements.length) {
                    if (javaElements[j].getElementType() == 5 && this.getIncludedFiles(packageFragment.getJavaProject().getProject()).contains(javaElements[j].getResource()) && (javaElements[j] instanceof AJCompilationUnit || javaElements[j].getElementName() == null || !javaElements[j].getElementName().endsWith(".aj"))) {
                        String memberName = javaElements[j].getElementName();
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        } else if (memberName.endsWith(".aj")) {
                            memberName = memberName.substring(0, memberName.length() - 3);
                        }
                        JDTMember member = new JDTMember(memberName, javaElements[j]);
                        member.setSize(this.getLength((ICompilationUnit)javaElements[j]));
                        returningClasses.add(member);
                    }
                    ++j;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
        return returningClasses;
    }

    private List getIncludedFiles(IProject project) {
        if (this.includedFiles == null) {
            this.includedFiles = BuildConfig.getIncludedSourceFiles((IProject)project);
        }
        return this.includedFiles;
    }

    static {
        Factory factory = new Factory("AJDTContentProvider.java", Class.forName("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider-org.eclipse.jdt.core.JavaModelException-<missing>-"), 192);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateData-org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider----void-"), 135);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider-org.eclipse.jdt.core.JavaModelException-<missing>-"), 312);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMembersForPackage-org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider-org.eclipse.jdt.core.IPackageFragment:-packageFragment:--java.util.List-"), 280);
    }
}

