/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildpath;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.buildpath.BuildConfigurationUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SaveBCAction
implements IWorkbenchWindowActionDelegate {
    private IProject currentProject;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public void run(IAction action) {
        if (this.currentProject != null) {
            String title = UIMessages.BCDialog_SaveBuildConfigurationAs_title;
            String msg = UIMessages.BCDialog_SaveBuildConfigurationAs_message;
            String defaultFileName = UIMessages.BCDialog_SaveBuildConfigurationAs_default;
            String fileName = AJDTUtils.getFreeFileName(this.currentProject, defaultFileName, "ajproperties");
            IInputValidator validator = new IInputValidator(){

                public String isValid(String input) {
                    IStatus status = PDEPlugin.getWorkspace().validateName(String.valueOf(input) + "." + "ajproperties", 1);
                    if (!status.isOK()) {
                        return status.getMessage();
                    }
                    return null;
                }
            };
            InputDialog md = new InputDialog(AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell(), title, msg, fileName, validator);
            md.setBlockOnOpen(true);
            if (md.open() == 0 && md.getValue() != null) {
                String newName = md.getValue();
                IFile newFile = this.getFile(this.currentProject, newName);
                if (newFile.exists()) {
                    this.askUserOverwrite(newFile.getName());
                    try {
                        newFile.delete(true, null);
                    }
                    catch (CoreException coreException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
                    }
                }
                BuildConfigurationUtils.saveBuildConfiguration(newFile);
            }
            try {
                this.currentProject.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, ajc$tjp_1);
            }
        }
    }

    private boolean askUserOverwrite(String fileName) {
        String[] options = new String[]{UIMessages.BCDialog_Overwrite_yes, UIMessages.BCDialog_Overwrite_no};
        String title = UIMessages.BCDialog_Overwrite_title;
        String msg = UIMessages.BCDialog_Overwrite_message.replaceAll("%fileName", fileName);
        MessageDialog mdiag = new MessageDialog(null, title, null, msg, 3, options, 1);
        return mdiag.open() == 0;
    }

    IFile getFile(IProject project, String name) {
        return project.getFile(String.valueOf(name) + "." + "ajproperties");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentProject = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IProject) {
                this.currentProject = (IProject)first;
            } else if (first instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)first;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_3, ajc$tjp_4);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.currentProject = (IProject)iAdaptable.getAdapter((Class)clazz);
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    static {
        Factory factory = new Factory("SaveBCAction.java", Class.forName("org.eclipse.ajdt.internal.buildpath.SaveBCAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.buildpath.SaveBCAction-org.eclipse.core.runtime.CoreException-<missing>-"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.buildpath.SaveBCAction-org.eclipse.jface.action.IAction:-action:--void-"), 48);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.buildpath.SaveBCAction-org.eclipse.core.runtime.CoreException-<missing>-"), 91);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.buildpath.SaveBCAction-java.lang.ClassNotFoundException-<missing>-"), 126);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-selectionChanged-org.eclipse.ajdt.internal.buildpath.SaveBCAction-org.eclipse.jface.action.IAction:org.eclipse.jface.viewers.ISelection:-action:selection:--void-"), 118);
    }
}

