/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.util.List;
import org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SuperInterfaceSelectionDialog
extends TypeSelectionDialog2 {
    private static final int ADD_ID = 1025;
    private NewTypeWizardPage fTypeWizardPage;
    private List fOldContent;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, NewTypeWizardPage page, IJavaProject p) {
        super(parent, true, context, SuperInterfaceSelectionDialog.createSearchScope(p), 6);
        this.fTypeWizardPage = page;
        this.fOldContent = this.fTypeWizardPage.getSuperInterfaces();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.SuperInterfaceSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(parent);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("DialogBounds_SuperInterfaceSelectionDialog");
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
    }

    protected void cancelPressed() {
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterface();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedInterface();
        super.okPressed();
    }

    private void addSelectedInterface() {
        TypeNameMatch[] selection = this.getSelectedTypes();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            TypeNameMatch type = selection[i];
            String qualifiedName = type.getFullyQualifiedName();
            String message = this.fTypeWizardPage.addSuperInterface(qualifiedName) ? Messages.format((String)NewWizardMessages.SuperInterfaceSelectionDialog_interfaceadded_info, (Object)qualifiedName) : Messages.format((String)NewWizardMessages.SuperInterfaceSelectionDialog_interfacealreadyadded_info, (Object)qualifiedName);
            this.updateStatus((IStatus)new StatusInfo(1, message));
            ++i;
        }
    }

    private static IJavaSearchScope createSearchScope(IJavaProject p) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
    }

    protected void handleDefaultSelected(TypeNameMatch[] selection) {
        if (selection.length > 0) {
            this.buttonPressed(1025);
        }
    }

    protected void handleWidgetSelected(TypeNameMatch[] selection) {
        super.handleWidgetSelected(selection);
        this.getButton(1025).setEnabled(selection.length > 0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.super_interface_selection_dialog_context");
    }
}

