/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.aspectj.org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.aspectj.org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.aspectj.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.CommentRegion;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.JavaDocRegion;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.MultiCommentRegion;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class DefaultCodeFormatter
extends CodeFormatter {
    private static Scanner ProbingScanner;
    public static final boolean DEBUG = false;
    private CodeSnippetParsingUtil codeSnippetParsingUtil;
    private Map defaultCompilerOptions;
    private CodeFormatterVisitor newCodeFormatter;
    private Map options;
    private DefaultCodeFormatterOptions preferences;

    public static CommentRegion createRegion(int kind, IDocument document, Position range, CodeFormatterVisitor formatter) {
        switch (kind) {
            case 16: {
                return new CommentRegion(document, range, formatter);
            }
            case 32: {
                return new MultiCommentRegion(document, range, formatter);
            }
            case 64: {
                return new JavaDocRegion(document, range, formatter);
            }
        }
        return null;
    }

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map options) {
        if (options != null) {
            this.options = options;
            this.preferences = new DefaultCodeFormatterOptions(options);
        } else {
            this.options = JavaCore.getOptions();
            this.preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        }
        this.defaultCompilerOptions = this.getDefaultCompilerOptions();
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public DefaultCodeFormatter(Map options) {
        this(null, options);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        if (offset < 0 || length < 0 || length > source.length()) {
            throw new IllegalArgumentException();
        }
        this.codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        switch (kind) {
            case 4: {
                return this.formatClassBodyDeclarations(source, indentationLevel, lineSeparator, offset, length);
            }
            case 8: {
                return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
            }
            case 1: {
                return this.formatExpression(source, indentationLevel, lineSeparator, offset, length);
            }
            case 2: {
                return this.formatStatements(source, indentationLevel, lineSeparator, offset, length);
            }
            case 0: {
                return this.probeFormatting(source, indentationLevel, lineSeparator, offset, length);
            }
            case 16: 
            case 32: 
            case 64: {
                return this.formatComment(kind, source, indentationLevel, lineSeparator, offset, length);
            }
        }
        return null;
    }

    private TextEdit formatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ASTNode[] bodyDeclarations = this.codeSnippetParsingUtil.parseClassBodyDeclarations(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (bodyDeclarations == null) {
            return null;
        }
        return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
    }

    private TextEdit formatComment(int kind, String source, int indentationLevel, String lineSeparator, int offset, int length) {
        boolean isFormattingComments = "true".equals(this.options.get("org.aspectj.org.eclipse.jdt.core.formatter.comment.format_comments"));
        if (isFormattingComments) {
            this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
            this.preferences.initial_indentation_level = indentationLevel;
            this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, null);
            CommentRegion region = DefaultCodeFormatter.createRegion(kind, (IDocument)new Document(source), new Position(offset, length), this.newCodeFormatter);
            if (region != null) {
                return this.newCodeFormatter.format(source, region);
            }
        }
        return new MultiTextEdit();
    }

    private TextEdit formatCompilationUnit(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        CompilationUnitDeclaration compilationUnitDeclaration = this.codeSnippetParsingUtil.parseCompilationUnit(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, compilationUnitDeclaration);
    }

    private TextEdit formatExpression(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        Expression expression = this.codeSnippetParsingUtil.parseExpression(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression == null) {
            return null;
        }
        return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
    }

    private TextEdit formatStatements(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (constructorDeclaration.statements == null) {
            return null;
        }
        return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
    }

    public String getDebugOutput() {
        return this.newCodeFormatter.scribe.toString();
    }

    private Map getDefaultCompilerOptions() {
        Object sourceOption;
        if (this.defaultCompilerOptions == null) {
            HashMap<String, String> optionsMap = new HashMap<String, String>(30);
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
            optionsMap.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "public");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "public");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", "ignore");
            optionsMap.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskTags", "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskPriorities", "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskCaseSensitive", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
            optionsMap.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", String.valueOf(100));
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "disabled");
            this.defaultCompilerOptions = optionsMap;
        }
        if ((sourceOption = this.options.get("org.eclipse.jdt.core.compiler.source")) != null) {
            this.defaultCompilerOptions.put("org.eclipse.jdt.core.compiler.source", sourceOption);
        } else {
            this.defaultCompilerOptions.put("org.eclipse.jdt.core.compiler.source", "1.3");
        }
        return this.defaultCompilerOptions;
    }

    private TextEdit internalFormatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, ASTNode[] bodyDeclarations, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, bodyDeclarations);
    }

    private TextEdit internalFormatExpression(String source, int indentationLevel, String lineSeparator, Expression expression, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        TextEdit textEdit = this.newCodeFormatter.format(source, expression);
        return textEdit;
    }

    private TextEdit internalFormatStatements(String source, int indentationLevel, String lineSeparator, ConstructorDeclaration constructorDeclaration, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, constructorDeclaration);
    }

    private TextEdit probeFormatting(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        if (ProbingScanner == null) {
            ProbingScanner = new Scanner(true, true, false, 0x2F0000L, 0x2F0000L, null, null, true);
        }
        ProbingScanner.setSource(source.toCharArray());
        ProbingScanner.resetTo(offset, offset + length);
        try {
            switch (ProbingScanner.getNextToken()) {
                case 1002: {
                    if (ProbingScanner.getCurrentTokenEndPosition() != offset + length - 1) break;
                    return this.formatComment(32, source, indentationLevel, lineSeparator, offset, length);
                }
                case 1001: {
                    if (ProbingScanner.getCurrentTokenEndPosition() != offset + length - 1) break;
                    return this.formatComment(16, source, indentationLevel, lineSeparator, offset, length);
                }
                case 1003: {
                    if (ProbingScanner.getCurrentTokenEndPosition() != offset + length - 1) break;
                    return this.formatComment(64, source, indentationLevel, lineSeparator, offset, length);
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        ProbingScanner.setSource((char[])null);
        Expression expression = this.codeSnippetParsingUtil.parseExpression(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression != null) {
            return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
        }
        ASTNode[] bodyDeclarations = this.codeSnippetParsingUtil.parseClassBodyDeclarations(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (bodyDeclarations != null) {
            return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
        }
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (constructorDeclaration.statements != null) {
            return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
        }
        return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
    }
}

