/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElementInfo;
import org.eclipse.ajdt.core.javaelements.IMockElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMethod;

public class MockSourceMethod
extends SourceMethod
implements IMockElement {
    private MethodElementInfo elementInfo;

    public MockSourceMethod(JavaElement parent, String name, String[] parameterTypes, MethodElementInfo elementInfo) {
        super(parent, name, parameterTypes);
        this.elementInfo = elementInfo;
    }

    public MockSourceMethod(JavaElement parent, String name, String[] parameterTypes, int offset, String accessibility) {
        super(parent, name, parameterTypes);
        this.elementInfo = new MethodElementInfo();
        if (accessibility.equals(IProgramElement.Accessibility.PRIVATE.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PRIVATE);
        } else if (accessibility.equals(IProgramElement.Accessibility.PROTECTED.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PROTECTED);
        } else if (accessibility.equals(IProgramElement.Accessibility.PUBLIC.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PUBLIC);
        } else if (accessibility.equals(IProgramElement.Accessibility.PACKAGE.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PACKAGE);
        } else if (accessibility.equals(IProgramElement.Accessibility.PRIVILEGED.toString())) {
            this.elementInfo.setAJAccessibility(IProgramElement.Accessibility.PRIVILEGED);
        }
        this.elementInfo.setSourceRangeStart(offset);
        this.elementInfo.setName(name.toCharArray());
        this.elementInfo.setAJKind(IProgramElement.Kind.METHOD);
    }

    public Object getElementInfo() throws JavaModelException {
        return this.elementInfo;
    }

    public String getHandleIdentifier() {
        return String.valueOf(super.getHandleIdentifier()) + '>' + this.elementInfo.getSourceRange().getOffset() + '>' + this.elementInfo.accessibility.toString();
    }

    public IProgramElement.Kind getAJKind() throws JavaModelException {
        return IProgramElement.Kind.METHOD;
    }

    public IProgramElement.Accessibility getAJAccessibility() throws JavaModelException {
        return this.elementInfo.accessibility;
    }

    public List getAJModifiers() throws JavaModelException {
        return this.elementInfo.modifiers;
    }

    public IProgramElement.ExtraInformation getAJExtraInformation() throws JavaModelException {
        return this.elementInfo.extra;
    }

    public static class MethodElementInfo
    extends AspectJMemberElementInfo {
    }
}

