/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.corext.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.corext.util.History;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History {
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map fTimestampMapping = new HashMap();
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_HANDLE = "handle";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";
    private static OpenTypeHistory fgInstance;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static synchronized void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME, NODE_ROOT, NODE_TYPE_INFO);
        this.load();
        this.fDeltaListener = new TypeHistoryDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Platform.getJobManager().join((Object)UpdateJob.FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, this, ajc$tjp_0, ajc$tjp_1);
            }
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(monitor);
    }

    public synchronized boolean contains(TypeNameMatch type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeNameMatch info) {
        if (!this.fTimestampMapping.containsKey(info)) {
            this.fTimestampMapping.put(info, new Long(this.getContainerTimestamp(info)));
        }
        super.accessed(info);
    }

    public synchronized TypeNameMatch remove(TypeNameMatch info) {
        this.fTimestampMapping.remove(info);
        return (TypeNameMatch)super.remove(info);
    }

    public synchronized void replace(TypeNameMatch old, TypeNameMatch newMatch) {
        this.fTimestampMapping.remove(old);
        this.fTimestampMapping.put(newMatch, new Long(this.getContainerTimestamp(newMatch)));
        super.remove(old);
        super.accessed(newMatch);
    }

    public synchronized TypeNameMatch[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeNameMatch[] result = new TypeNameMatch[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeNameMatch)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeNameMatch[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            TypeNameMatch type = (TypeNameMatch)iter.next();
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered((String)type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeNameMatch[result.size()]);
    }

    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        ArrayList typesToCheck = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, typesToCheck.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        Iterator iter = typesToCheck.iterator();
        while (iter.hasNext()) {
            TypeNameMatch type = (TypeNameMatch)iter.next();
            long currentTimestamp = this.getContainerTimestamp(type);
            Long lastTested = (Long)this.fTimestampMapping.get(type);
            if (lastTested != null && currentTimestamp != -1L && currentTimestamp == lastTested && !this.isContainerDirty(type)) continue;
            try {
                IType jType = type.getType();
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    int modifiers = jType.getFlags();
                    if (modifiers != type.getModifiers()) {
                        this.replace(type, SearchEngine.createTypeNameMatch((IType)jType, (int)modifiers));
                    } else {
                        this.fTimestampMapping.put(type, new Long(currentTimestamp));
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, ajc$tjp_3);
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getContainerTimestamp(TypeNameMatch match) {
        CoreException coreException2222222;
        block5: {
            block6: {
                block4: {
                    IType type = match.getType();
                    IResource resource = type.getResource();
                    if (resource == null) break block4;
                    URI location = resource.getLocationURI();
                    if (location == null) return -1L;
                    IFileInfo info = EFS.getStore((URI)location).fetchInfo();
                    if (!info.exists()) return -1L;
                    IJavaElement element = JavaCore.create((IResource)resource);
                    if (element == null) return -1L;
                    if (!element.exists()) return -1L;
                    return info.getLastModified();
                }
                try {}
                catch (CoreException coreException2222222) {
                    // empty catch block
                    break block5;
                }
                break block6;
                catch (CoreException coreException3) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException3, this, ajc$tjp_4, ajc$tjp_5);
                    CoreException coreException4 = coreException3;
                }
                break block5;
            }
            IPackageFragmentRoot root = match.getPackageFragmentRoot();
            IFileInfo info = EFS.getLocalFileSystem().getStore(root.getPath()).fetchInfo();
            if (!info.exists()) return -1L;
            return info.getLastModified();
        }
        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2222222, this, ajc$tjp_6, ajc$tjp_5);
        return -1L;
    }

    public boolean isContainerDirty(TypeNameMatch match) {
        ICompilationUnit cu = match.getType().getCompilationUnit();
        if (cu == null) {
            return false;
        }
        IResource resource = cu.getResource();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(resource.getFullPath());
        if (textFileBuffer != null) {
            return textFileBuffer.isDirty();
        }
        return false;
    }

    private void doShutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.save();
    }

    protected Object createFromElement(Element type) {
        String handle = type.getAttribute(NODE_HANDLE);
        if (handle == null) {
            return null;
        }
        IJavaElement element = JavaCore.create((String)handle);
        if (!(element instanceof IType)) {
            return null;
        }
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(numberFormatException, this, ajc$tjp_7, ajc$tjp_8);
        }
        TypeNameMatch info = SearchEngine.createTypeNameMatch((IType)((IType)element), (int)modifiers);
        long timestamp = -1L;
        String timestampValue = type.getAttribute(NODE_TIMESTAMP);
        if (timestampValue != null && timestampValue.length() > 0) {
            try {
                timestamp = Long.parseLong(timestampValue);
            }
            catch (NumberFormatException numberFormatException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(numberFormatException, this, ajc$tjp_9, ajc$tjp_8);
            }
        }
        if (timestamp != -1L) {
            this.fTimestampMapping.put(info, new Long(timestamp));
        }
        return info;
    }

    protected void setAttributes(Object object, Element typeElement) {
        TypeNameMatch type = (TypeNameMatch)object;
        String handleId = type.getType().getHandleIdentifier();
        typeElement.setAttribute(NODE_HANDLE, handleId);
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
        Long timestamp = (Long)this.fTimestampMapping.get(type);
        if (timestamp == null) {
            typeElement.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            typeElement.setAttribute(NODE_TIMESTAMP, timestamp.toString());
        }
    }

    static {
        Factory factory = new Factory("OpenTypeHistory.java", Class.forName("org.eclipse.ajdt.internal.corext.util.OpenTypeHistory"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-java.lang.InterruptedException-<missing>-"), 224);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-checkConsistency-org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.core.runtime.IProgressMonitor:-monitor:-org.eclipse.core.runtime.OperationCanceledException:-void-"), 215);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.jdt.core.JavaModelException-<missing>-"), 314);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-internalCheckConsistency-org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.core.runtime.IProgressMonitor:-monitor:-org.eclipse.core.runtime.OperationCanceledException:-void-"), 288);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.core.runtime.CoreException-<missing>-"), 348);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getContainerTimestamp-org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.jdt.core.search.TypeNameMatch:-match:--long-"), 325);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.eclipse.core.runtime.CoreException-<missing>-"), 348);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-java.lang.NumberFormatException-<missing>-"), 387);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-createFromElement-org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-org.w3c.dom.Element:-type:--java.lang.Object-"), 375);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory-java.lang.NumberFormatException-<missing>-"), 396);
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 7: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: 
                case 6: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)((ICompilationUnit)elem))) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        static {
            Factory factory = new Factory("OpenTypeHistory.java", Class.forName("org.eclipse.ajdt.internal.corext.util.OpenTypeHistory$UpdateJob"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory$UpdateJob-java.lang.ClassNotFoundException-<missing>-"), 145);
            ajc$tjp_1 = factory.makeSJP("staticinitialization", (Signature)factory.makeInitializerSig("8--org.eclipse.ajdt.internal.corext.util.OpenTypeHistory$UpdateJob-"), 145);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ajdt.internal.corext.util.OpenTypeHistory$UpdateJob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(classNotFoundException, ajc$tjp_0, ajc$tjp_1);
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FAMILY = clazz.getName();
        }

        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            history.internalCheckConsistency(monitor);
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

